/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.licensecommon.net.impl;

import com.intellij.licensecommon.message.Message;
import com.intellij.licensecommon.net.Address;
import com.intellij.licensecommon.net.CouldNotCreateSocketException;
import com.intellij.licensecommon.net.FatalNetworkException;
import com.intellij.licensecommon.net.Network;
import com.intellij.licensecommon.net.NetworkSendException;
import com.intellij.licensecommon.net.NetworkSocket;
import com.intellij.licensecommon.net.NetworkSocketFactory;
import com.intellij.licensecommon.net.NetworkTarget;
import com.intellij.licensecommon.net.Packet;
import com.intellij.licensecommon.net.impl.SocketListener;
import com.intellij.licensecommon.protocol.Protocol;
import com.intellij.licensecommon.protocol.ProtocolDecodingException;
import com.intellij.licensecommon.protocol.ProtocolEncodingException;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

public class NetworkImpl<M extends Message>
implements Network<M> {
    private volatile boolean myIsStarted;
    private final NetworkSocketFactory mySocketFactory;
    private final Protocol<M> myProtocol;
    private volatile NetworkSocket myLocalSocket;
    private volatile List<Address> myMulticastAddresses;
    private NetworkTarget<M> myTarget;
    private NetworkSocket myMulticastSocket;
    private Address myLocalAddress;
    @NotNull
    private final ExecutorService myMessageDispatcher;
    @NotNull
    private final Executor myTaskExecutor;

    public NetworkImpl(@NotNull NetworkSocketFactory socketFactory, @NotNull Protocol<M> protocol2, @NotNull Executor taskExecutor) {
        if (socketFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "socketFactory", "com/intellij/licensecommon/net/impl/NetworkImpl", "<init>"));
        }
        if (protocol2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/licensecommon/net/impl/NetworkImpl", "<init>"));
        }
        if (taskExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskExecutor", "com/intellij/licensecommon/net/impl/NetworkImpl", "<init>"));
        }
        this.mySocketFactory = socketFactory;
        this.myProtocol = protocol2;
        this.myTaskExecutor = taskExecutor;
        this.myMessageDispatcher = new SequentialTaskExecutor("NetworkImpl pool", taskExecutor);
    }

    @Override
    public synchronized void startWith(NetworkTarget<M> target) throws CouldNotCreateSocketException, FatalNetworkException {
        if (this.myIsStarted) {
            return;
        }
        this.myTarget = target;
        NetworkSocket localSocket = this.mySocketFactory.createLocalSocket();
        NetworkSocket multicastSocket = this.mySocketFactory.createMulticastSocket();
        this.myTaskExecutor.execute(new SocketListener(this, localSocket));
        this.myTaskExecutor.execute(new SocketListener(this, multicastSocket));
        try {
            localSocket.waitUntilReceiving();
            multicastSocket.waitUntilReceiving();
        }
        catch (InterruptedException e2) {
            throw new FatalNetworkException(e2);
        }
        this.myLocalSocket = localSocket;
        this.myLocalAddress = localSocket.getAddress();
        this.myMulticastSocket = multicastSocket;
        this.myMulticastAddresses = this.mySocketFactory.getMulticastAddresses();
        this.myIsStarted = true;
    }

    @Override
    public synchronized void shutDown() {
        NetworkSocket multicastSocket;
        NetworkSocket localSocket = this.myLocalSocket;
        if (localSocket != null) {
            this.myLocalSocket = null;
            localSocket.close();
        }
        if ((multicastSocket = this.myMulticastSocket) != null) {
            this.myMulticastSocket = null;
            multicastSocket.close();
        }
        this.myMulticastAddresses = null;
        this.myIsStarted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(M message2, Address to) throws NetworkSendException {
        try {
            byte[] bytes = this.myProtocol.encode(message2);
            NetworkImpl networkImpl = this;
            synchronized (networkImpl) {
                this.send(bytes, to);
            }
        }
        catch (ProtocolEncodingException e2) {
            throw new NetworkSendException(e2);
        }
    }

    @Override
    private void send(byte[] bytes, Address to) {
        this.myLocalSocket.send(new Packet(bytes, to));
    }

    @Override
    public boolean isStarted() {
        return this.myIsStarted;
    }

    @Override
    public void receive(Packet packet) {
        Address address = packet.getAddress();
        if (this.isMyLocalAddress(address)) {
            return;
        }
        try {
            M data = this.myProtocol.decode(packet.getBytes());
            this.myMessageDispatcher.submit(() -> {
                try {
                    this.myTarget.receivedData((Message)data, address);
                }
                catch (Throwable t2) {
                    this.myTarget.dataDeliveryFailure(t2);
                }
            });
        }
        catch (ProtocolDecodingException ex) {
            this.myTarget.dataDeliveryFailure(ex);
        }
    }

    private boolean isMyLocalAddress(Address address) {
        return address.equals(this.myLocalAddress);
    }

    @Override
    public void unrecoverableNetworkFailure(Throwable failure) {
        this.myTarget.receivedFatalNetworkFailure(failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcast(M message2) throws NetworkSendException {
        try {
            byte[] bytes = this.myProtocol.encode(message2);
            NetworkImpl networkImpl = this;
            synchronized (networkImpl) {
                for (Address address : this.myMulticastAddresses) {
                    this.send(bytes, address);
                }
            }
        }
        catch (ProtocolEncodingException e2) {
            throw new NetworkSendException(e2);
        }
    }
}

