/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.licensecommon.net.impl;

import com.intellij.licensecommon.net.Address;
import com.intellij.licensecommon.net.CouldNotCreateSocketException;
import com.intellij.licensecommon.net.NetworkSocket;
import com.intellij.licensecommon.net.NetworkSocketFactory;
import com.intellij.licensecommon.net.impl.AddressImpl;
import com.intellij.licensecommon.net.impl.SocketImpl;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NetworkSocketFactoryImpl
implements NetworkSocketFactory {
    private static final int[] PORTS = new int[]{8976, 8977, 8978, 8979};
    private static final String MULTICAST_HOST = "230.230.230.230";
    private static Address[] MULTICAST_ADDRESSES = new Address[PORTS.length];

    @Override
    public NetworkSocket createLocalSocket() throws CouldNotCreateSocketException {
        try {
            return NetworkSocketFactoryImpl.createLocalSocket(new AddressImpl(new InetSocketAddress(0)));
        }
        catch (Exception e2) {
            throw new CouldNotCreateSocketException(e2);
        }
    }

    @Override
    public NetworkSocket createMulticastSocket() throws CouldNotCreateSocketException {
        for (Address address : MULTICAST_ADDRESSES) {
            try {
                return NetworkSocketFactoryImpl.createMulticastSocket(address);
            }
            catch (CouldNotCreateSocketException couldNotCreateSocketException) {
            }
        }
        throw new CouldNotCreateSocketException();
    }

    @Override
    public List<Address> getMulticastAddresses() {
        return Arrays.asList(MULTICAST_ADDRESSES);
    }

    private static NetworkSocket createLocalSocket(@NotNull Address address) throws CouldNotCreateSocketException {
        if (address == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "address", "com/intellij/licensecommon/net/impl/NetworkSocketFactoryImpl", "createLocalSocket"));
        }
        try {
            return new SocketImpl(new DatagramSocket(address.getSocketAddress()), SocketImpl.DEFAULT_TIMEOUT);
        }
        catch (SocketException e2) {
            throw new CouldNotCreateSocketException(address.getDisplay(), e2);
        }
    }

    private static NetworkSocket createMulticastSocket(Address address) throws CouldNotCreateSocketException {
        DatagramSocket socket = null;
        try {
            socket = new MulticastSocket(address.getSocketAddress().getPort());
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface anInterface = networkInterfaces.nextElement();
                if (!NetworkSocketFactoryImpl.isValid(anInterface)) continue;
                ((MulticastSocket)socket).joinGroup(address.getSocketAddress(), anInterface);
            }
            return new SocketImpl(socket, SocketImpl.DEFAULT_TIMEOUT);
        }
        catch (Throwable e2) {
            if (socket != null) {
                socket.close();
            }
            throw new CouldNotCreateSocketException(e2);
        }
    }

    private static boolean isValid(NetworkInterface anInterface) throws SocketException {
        Enumeration<InetAddress> addresses = anInterface.getInetAddresses();
        if (!addresses.hasMoreElements()) {
            return false;
        }
        if (anInterface.isLoopback() || anInterface.isPointToPoint() || anInterface.isVirtual()) {
            return false;
        }
        do {
            InetAddress ifaceAddress;
            if ((ifaceAddress = addresses.nextElement()).getAddress().length != 4) continue;
            return true;
        } while (addresses.hasMoreElements());
        return false;
    }

    static {
        for (int i2 = 0; i2 < PORTS.length; ++i2) {
            NetworkSocketFactoryImpl.MULTICAST_ADDRESSES[i2] = new AddressImpl(MULTICAST_HOST, PORTS[i2]);
        }
    }
}

