/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.licensecommon.net.impl;

import com.intellij.licensecommon.log.Log;
import com.intellij.licensecommon.log.Logger;
import com.intellij.licensecommon.net.Address;
import com.intellij.licensecommon.net.FatalSocketException;
import com.intellij.licensecommon.net.NetworkSocket;
import com.intellij.licensecommon.net.Packet;
import com.intellij.licensecommon.net.SocketClosedException;
import com.intellij.licensecommon.net.impl.AddressImpl;
import com.intellij.licensecommon.net.impl.TimeoutOccurredException;
import com.intellij.util.concurrency.Semaphore;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class SocketImpl
implements NetworkSocket {
    private static final Logger LOG = Log.FACTORY.getInstance("#com.intellij.licensecommon.net.impl.SocketImpl");
    private final DatagramSocket mySocket;
    private final Semaphore myReceiveSemaphore = new Semaphore();
    public static int DEFAULT_TIMEOUT = 10000;

    public SocketImpl(DatagramSocket socket) {
        this.mySocket = socket;
        this.myReceiveSemaphore.down();
    }

    public SocketImpl(DatagramSocket socket, int timeout) {
        this(socket);
        try {
            this.mySocket.setSoTimeout(timeout);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public void send(Packet packet) {
        block6: {
            DatagramPacket p2;
            block5: {
                AddressImpl addressImpl = (AddressImpl)packet.getAddress();
                byte[] bytes = packet.getBytes();
                InetSocketAddress socketAddress = addressImpl.getSocketAddress();
                p2 = null;
                try {
                    p2 = new DatagramPacket(bytes, bytes.length, socketAddress);
                }
                catch (Exception e2) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug(e2);
                }
            }
            if (p2 == null) {
                return;
            }
            try {
                this.mySocket.send(p2);
            }
            catch (IOException e3) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug(e3);
            }
        }
    }

    @Override
    public Packet receive() throws SocketClosedException, FatalSocketException {
        this.myReceiveSemaphore.up();
        byte[] buf = new byte[10000];
        DatagramPacket p2 = new DatagramPacket(buf, buf.length);
        try {
            this.mySocket.receive(p2);
        }
        catch (SocketTimeoutException e2) {
            throw new TimeoutOccurredException(e2);
        }
        catch (SocketException e3) {
            throw new SocketClosedException(e3);
        }
        catch (IOException e4) {
            throw new FatalSocketException(e4);
        }
        byte[] bytes = new byte[p2.getLength()];
        System.arraycopy(p2.getData(), p2.getOffset(), bytes, 0, p2.getLength());
        return new Packet(bytes, new AddressImpl((InetSocketAddress)p2.getSocketAddress()));
    }

    @Override
    public void close() {
        this.mySocket.close();
    }

    @Override
    public void waitUntilReceiving() throws InterruptedException {
        this.myReceiveSemaphore.waitFor();
    }

    @Override
    public Address getAddress() {
        return new AddressImpl((InetSocketAddress)this.mySocket.getLocalSocketAddress());
    }
}

