/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.licensecommon.protocol.impl;

import com.intellij.licensecommon.license.LicenseBroadcastData;
import com.intellij.licensecommon.message.impl.ResharperMessage;
import com.intellij.licensecommon.protocol.Protocol;
import com.intellij.licensecommon.protocol.ProtocolDecodingException;
import com.intellij.licensecommon.protocol.ProtocolEncodingException;
import com.intellij.licensecommon.protocol.impl.EncryptionUtil;
import com.intellij.util.io.DataOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;

public class ResharperProtocol
implements Protocol<ResharperMessage> {
    private static final String DATA_ENCODING = "UTF-16le";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encode(ResharperMessage message2) throws ProtocolEncodingException {
        try {
            LicenseBroadcastData data = message2.getBroadcastData();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (DataOutputStream dataOut = new DataOutputStream((OutputStream)out);){
                this.writeInt((DataOutput)dataOut, 0);
                this.writeString((DataOutput)dataOut, data.getLicenseKeyId(), true);
                this.writeString((DataOutput)dataOut, data.getLicenseeName(), false);
                this.writeString((DataOutput)dataOut, data.getUserLogin(), false);
            }
            return out.toByteArray();
        }
        catch (Exception e2) {
            throw new ProtocolEncodingException(e2);
        }
    }

    @Override
    public ResharperMessage decode(byte[] buf) throws ProtocolDecodingException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buf));
        try {
            int code2 = this.readInt(in);
            String keyId = this.readString(in, true);
            String licenseeName = this.readString(in, false);
            String userLogin = this.readString(in, false);
            return new ResharperMessage(new LicenseBroadcastData(code2, keyId, licenseeName, userLogin));
        }
        catch (Exception e2) {
            throw new ProtocolDecodingException(e2);
        }
    }

    private void writeInt(DataOutput out, int value2) throws IOException {
        out.write(value2 & 0xFF);
        out.write(value2 >> 8 & 0xFF);
        out.write(value2 >> 16 & 0xFF);
        out.write(value2 >> 24 & 0xFF);
    }

    private int readInt(DataInput in) throws IOException {
        int value2 = in.readByte();
        value2 |= in.readByte() << 8;
        value2 |= in.readByte() << 16;
        return value2 |= in.readByte() << 24;
    }

    private void writeString(DataOutput out, String value2, boolean encrypt) throws Exception {
        byte[] bytes = (encrypt ? EncryptionUtil.encrypt(value2) : value2).getBytes(DATA_ENCODING);
        this.writeInt(out, bytes.length);
        out.write(bytes);
    }

    private String readString(DataInput in, boolean decrypt) throws Exception {
        int length = this.readInt(in);
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        String str = new String(bytes, DATA_ENCODING);
        return decrypt ? EncryptionUtil.decrypt(str) : str;
    }
}

