/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.licensecommon.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class Dates {
    public static final int JAN = 0;
    public static final int FEB = 1;
    public static final int MAR = 2;
    public static final int APR = 3;
    public static final int MAY = 4;
    public static final int JUN = 5;
    public static final int JUL = 6;
    public static final int AUG = 7;
    public static final int SEP = 8;
    public static final int OCT = 9;
    public static final int NOV = 10;
    public static final int DEC = 11;
    public static final String DEFAULT_TIME_ZONE = "Europe/Prague";

    public static Date makeDate(int year, int month, int day) {
        return Dates.makeDate(year, month, day, Calendar.getInstance(TimeZone.getTimeZone(DEFAULT_TIME_ZONE), Locale.US));
    }

    public static long seconds(double num) {
        return (long)(num * 1000.0);
    }

    public static long minutes(double num) {
        return (long)(num * 60.0 * 1000.0);
    }

    public static long hours(double num) {
        return (long)(num * 60.0 * 60.0 * 1000.0);
    }

    public static long days(double num) {
        return (long)(num * 24.0 * 60.0 * 60.0 * 1000.0);
    }

    public static Date after(Date date, long time) {
        return new Date(date.getTime() + time);
    }

    public static Date before(Date date, long time) {
        return new Date(date.getTime() - time);
    }

    public static Date afterNow(long time) {
        return new Date(System.currentTimeMillis() + time);
    }

    public static Date beforeNow(long time) {
        return new Date(System.currentTimeMillis() - time);
    }

    public static Date makeDate(int year, int month, int day, Calendar calendar) {
        calendar.clear();
        calendar.set(year, month, day);
        return calendar.getTime();
    }

    public static Date now() {
        return new Date();
    }

    public static Date after(Date date) {
        return Dates.after(date, 1L);
    }

    public static Date before(Date date) {
        return Dates.before(date, 1L);
    }

    public static Date makeDate(int year, int month, int day, int hour, int minute, int second, String timeZone) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.set(year, month, day, hour, minute, second);
        return calendar.getTime();
    }

    public static boolean isBeforeWithError(Date before, Date after2, long allowedError) {
        long afterTime;
        long beforeTime = before.getTime();
        return beforeTime < (afterTime = after2.getTime()) - allowedError;
    }

    public static Date dayAfter(Date date) {
        return Dates.after(date, Dates.days(1.0));
    }

    public static Date dayBefore(Date date) {
        return Dates.before(date, Dates.days(1.0));
    }
}

