/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.licensecommon.util;

import com.intellij.licensecommon.util.Dates;
import com.intellij.licensecommon.util.LicenseType;
import com.intellij.licensecommon.util.Product;
import java.util.Date;

public class LicenseInfo
implements Cloneable {
    public static LicenseInfo NULL_OBJECT = new LicenseInfo();
    public String userName;
    public int customerId = -1;
    public int productId;
    public int licenseType;
    public int majorVersion;
    public int minorVersion;
    public Date generationDate;
    public Date expirationDate;
    public Date subscriptionEndDate;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof LicenseInfo)) {
            return false;
        }
        LicenseInfo info = (LicenseInfo)o2;
        if (this.customerId != info.customerId) {
            return false;
        }
        if (this.licenseType != info.licenseType) {
            return false;
        }
        if (this.majorVersion != info.majorVersion) {
            return false;
        }
        if (this.minorVersion != info.minorVersion) {
            return false;
        }
        if (this.productId != info.productId) {
            return false;
        }
        if (this.expirationDate != null ? !this.expirationDate.equals(info.expirationDate) : info.expirationDate != null) {
            return false;
        }
        if (this.generationDate != null ? !this.generationDate.equals(info.generationDate) : info.generationDate != null) {
            return false;
        }
        return !(this.userName != null ? !this.userName.equals(info.userName) : info.userName != null);
    }

    public int hashCode() {
        return this.userName != null ? this.userName.hashCode() : 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        buffer.append("user name:" + this.userName + "\n");
        buffer.append("customer id:" + this.customerId + "\n");
        buffer.append("product id:" + Product.toString(this.productId) + "\n");
        buffer.append("license type:" + LicenseType.toString(this.licenseType) + "\n");
        buffer.append("major version:" + this.majorVersion + "\n");
        buffer.append("minor version:" + this.minorVersion + "\n");
        buffer.append("generationDate:" + this.generationDate + "\n");
        buffer.append("expirationDate:" + this.expirationDate + "\n");
        return buffer.toString();
    }

    static {
        LicenseInfo.NULL_OBJECT.userName = "Fake";
        LicenseInfo.NULL_OBJECT.productId = 0;
        LicenseInfo.NULL_OBJECT.licenseType = 1;
        LicenseInfo.NULL_OBJECT.majorVersion = 1;
        LicenseInfo.NULL_OBJECT.minorVersion = 0;
        LicenseInfo.NULL_OBJECT.generationDate = Dates.makeDate(1995, 1, 1);
        LicenseInfo.NULL_OBJECT.expirationDate = Dates.makeDate(1995, 1, 2);
    }
}

