/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.licensecommon.util;

import com.intellij.licensecommon.util.InvalidLicenseKeyException;
import com.intellij.licensecommon.util.LicenseUtil;
import com.intellij.licensecommon.util.SubscriptionLicenseInfo;
import java.math.BigInteger;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.rsa.RSADecoder;

public class SubscriptionLicenseDecoder {
    private static BigInteger PUBLIC_MOD = new BigInteger("bb62fbb57f105cd61b47ae2290fcb3ce1179942de171beddf6baa1a521b9368b735c7c931902eba8de6d160711a6ecc40f4a5e766e9fcdee8a38715db572ad3d", 16);
    private static BigInteger PUBLIC_EXP = new BigInteger("10001", 16);
    private static final Pattern ourLicenseBegin = Pattern.compile("=+\\s+LICENSE (BEGIN|END)\\s+=+");

    private SubscriptionLicenseDecoder() {
    }

    public static SubscriptionLicenseInfo decode(String key, String userName) throws InvalidLicenseKeyException {
        SubscriptionLicenseInfo info = new SubscriptionLicenseInfo();
        byte[] bytes = SubscriptionLicenseDecoder.decodeKeyAndCustomerId(key, info);
        SubscriptionLicenseDecoder.decodeData(bytes, info, userName, 14);
        SubscriptionLicenseDecoder.fillLicenseInfo(bytes, info, userName, -1);
        return info;
    }

    protected static byte[] decodeKeyAndCustomerId(String key, SubscriptionLicenseInfo info) throws InvalidLicenseKeyException {
        return SubscriptionLicenseDecoder.decodeKeyAndCustomerId(key, info, PUBLIC_EXP, PUBLIC_MOD);
    }

    protected static byte[] decodeKeyAndCustomerId(String key, SubscriptionLicenseInfo info, BigInteger exp, BigInteger mod) throws InvalidLicenseKeyException {
        Matcher m2 = ourLicenseBegin.matcher(key);
        int pos = (key = m2.replaceAll("").trim()).indexOf(10);
        if (pos < 0) {
            pos = key.indexOf(13);
        }
        if (pos < 0) {
            throw new InvalidLicenseKeyException();
        }
        String firstLine = key.substring(0, pos);
        int dashPos = firstLine.indexOf(45);
        if (dashPos > 0) {
            try {
                info.customerId = Integer.parseInt(firstLine.substring(0, dashPos));
            }
            catch (NumberFormatException e2) {
                throw new InvalidLicenseKeyException();
            }
        } else {
            info.customerId = -1;
        }
        return new RSADecoder(exp, mod, 64).decode(key.substring(pos + 1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void decodeData(byte[] bytes, SubscriptionLicenseInfo info, String userName, int dataLength) throws InvalidLicenseKeyException {
        if (bytes.length != dataLength) {
            byte[] newBytes;
            if (bytes.length == dataLength + 1) {
                if (bytes[0] != 0) throw new InvalidLicenseKeyException();
                newBytes = new byte[dataLength];
                System.arraycopy(bytes, 1, newBytes, 0, dataLength);
                bytes = newBytes;
            } else {
                if (bytes.length >= dataLength) throw new InvalidLicenseKeyException();
                newBytes = new byte[dataLength];
                System.arraycopy(bytes, 0, newBytes, dataLength - bytes.length, bytes.length);
                bytes = newBytes;
            }
        }
        if (userName == null) return;
        short checkSum = LicenseUtil.calculateCheckSum(userName, info.customerId, bytes);
        if (bytes[dataLength - 2] != (byte)(checkSum & 0xFF)) {
            throw new InvalidLicenseKeyException();
        }
        if (bytes[dataLength - 1] == (byte)(checkSum >> 8 & 0xFF)) return;
        throw new InvalidLicenseKeyException();
    }

    static void fillLicenseInfo(byte[] bytes, SubscriptionLicenseInfo info, String userName, int forcedSubscriptionLength) throws InvalidLicenseKeyException {
        try {
            int subscriptionLength;
            info.userName = userName;
            info.productId = bytes[0] & 0xF;
            info.licenseType = bytes[0] >> 4;
            info.minorVersion = bytes[1] >> 4;
            long time = ((long)bytes[2] & 0xFFL) + (((long)bytes[3] & 0xFFL) << 8) + (((long)bytes[4] & 0xFFL) << 16) + (((long)bytes[5] & 0xFFL) << 24) << 16;
            info.generationDate = new Date(time);
            info.majorVersion = bytes[1] & 0xF;
            int days = (bytes[6] & 0xFF) + ((bytes[7] & 0xFF) << 8);
            if (days != 0) {
                info.expirationDate = new Date(time + (long)days * 24L * 60L * 60L * 1000L);
            }
            int n2 = subscriptionLength = forcedSubscriptionLength > -1 ? forcedSubscriptionLength : (bytes[10] & 0xFF) + ((bytes[11] & 0xFF) << 8);
            if (days != 0) {
                subscriptionLength = days;
            }
            info.maintenanceDueDate = new Date(time + (long)subscriptionLength * 24L * 60L * 60L * 1000L);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new InvalidLicenseKeyException();
        }
    }
}

