/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import gnu.trove.THashMap;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockVirtualFileSystem
extends DeprecatedVirtualFileSystem {
    private final MyVirtualFile myRoot = new MyVirtualFile("", null);
    public static final String PROTOCOL = "mock";

    @NotNull
    public MyVirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/mock/MockVirtualFileSystem", "findFileByPath"));
        }
        path = path.replace(File.separatorChar, '/');
        if (StringUtil.startsWithChar((CharSequence)(path = path.replace('/', ':')), (char)':')) {
            path = path.substring(1);
        }
        MyVirtualFile file2 = this.myRoot;
        for (String component : StringUtil.split((String)path, (String)":")) {
            file2 = file2.getOrCreate(component);
        }
        MyVirtualFile myVirtualFile = file2;
        if (myVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFileSystem", "findFileByPath"));
        }
        return myVirtualFile;
    }

    @NotNull
    public MockVirtualFileSystem file(@NotNull String path, @NotNull String data) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/mock/MockVirtualFileSystem", "file"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/mock/MockVirtualFileSystem", "file"));
        }
        MyVirtualFile file2 = this.findFileByPath(path);
        file2.setContent(null, data, false);
        MockVirtualFileSystem mockVirtualFileSystem = this;
        if (mockVirtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFileSystem", "file"));
        }
        return mockVirtualFileSystem;
    }

    @NotNull
    public VirtualFile getRoot() {
        MyVirtualFile myVirtualFile = this.myRoot;
        if (myVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFileSystem", "getRoot"));
        }
        return myVirtualFile;
    }

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFileSystem", "getProtocol"));
        }
        return PROTOCOL;
    }

    public void refresh(boolean asynchronous) {
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/mock/MockVirtualFileSystem", "refreshAndFindFileByPath"));
        }
        return this.findFileByPath(path);
    }

    public class MyVirtualFile
    extends LightVirtualFile {
        @Nullable
        private Map<String, MyVirtualFile> myChildren;
        private final MyVirtualFile myParent;

        MyVirtualFile(@Nullable String name, MyVirtualFile parent) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/mock/MockVirtualFileSystem$MyVirtualFile", "<init>"));
            }
            super(name);
            this.myParent = parent;
        }

        @NotNull
        public VirtualFileSystem getFileSystem() {
            MockVirtualFileSystem mockVirtualFileSystem = MockVirtualFileSystem.this;
            if (mockVirtualFileSystem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFileSystem$MyVirtualFile", "getFileSystem"));
            }
            return mockVirtualFileSystem;
        }

        @NotNull
        public MyVirtualFile getOrCreate(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/mock/MockVirtualFileSystem$MyVirtualFile", "getOrCreate"));
            }
            MyVirtualFile file2 = this.findChild(name);
            if (file2 == null) {
                if (this.myChildren == null) {
                    this.myChildren = new THashMap();
                }
                file2 = new MyVirtualFile(name, this);
                this.myChildren.put(name, file2);
            }
            MyVirtualFile myVirtualFile = file2;
            if (myVirtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFileSystem$MyVirtualFile", "getOrCreate"));
            }
            return myVirtualFile;
        }

        public boolean isDirectory() {
            return this.myParent == null || this.myChildren != null && !this.myChildren.isEmpty();
        }

        @NotNull
        public String getPath() {
            MyVirtualFile parent = this.getParent();
            String string2 = parent == null ? this.getName() : parent.getPath() + "/" + this.getName();
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFileSystem$MyVirtualFile", "getPath"));
            }
            return string2;
        }

        public MyVirtualFile getParent() {
            return this.myParent;
        }

        public VirtualFile[] getChildren() {
            if (this.myChildren == null || this.myChildren.isEmpty()) {
                return EMPTY_ARRAY;
            }
            Collection<MyVirtualFile> children2 = this.myChildren.values();
            return (VirtualFile[])children2.toArray(new MyVirtualFile[children2.size()]);
        }

        @Nullable
        public MyVirtualFile findChild(@NotNull @NonNls String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/mock/MockVirtualFileSystem$MyVirtualFile", "findChild"));
            }
            return this.myChildren == null ? null : this.myChildren.get(name);
        }
    }
}

