/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.navigation.RelatedToHtmlFilesContributor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HtmlGotoRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/navigation/HtmlGotoRelatedProvider", "getItems"));
        }
        PsiFile file2 = context2.getContainingFile();
        if (file2 == null || !HtmlGotoRelatedProvider.isAvailable(file2)) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/navigation/HtmlGotoRelatedProvider", "getItems"));
            }
            return list2;
        }
        List<? extends GotoRelatedItem> list3 = HtmlGotoRelatedProvider.getRelatedFiles(file2);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/navigation/HtmlGotoRelatedProvider", "getItems"));
        }
        return list3;
    }

    private static boolean isAvailable(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/navigation/HtmlGotoRelatedProvider", "isAvailable"));
        }
        for (PsiFile file2 : psiFile.getViewProvider().getAllFiles()) {
            Language language = file2.getLanguage();
            if (!language.isKindOf((Language)HTMLLanguage.INSTANCE) && !language.isKindOf((Language)XHTMLLanguage.INSTANCE)) continue;
            return true;
        }
        return false;
    }

    private static List<? extends GotoRelatedItem> getRelatedFiles(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/navigation/HtmlGotoRelatedProvider", "getRelatedFiles"));
        }
        ArrayList<GotoRelatedItem> items2 = new ArrayList<GotoRelatedItem>();
        for (PsiFile psiFile : file2.getViewProvider().getAllFiles()) {
            if (!(psiFile instanceof XmlFile)) continue;
            XmlFile xmlFile = (XmlFile)psiFile;
            for (RelatedToHtmlFilesContributor contributor : (RelatedToHtmlFilesContributor[])RelatedToHtmlFilesContributor.EP_NAME.getExtensions()) {
                HashSet resultSet = new HashSet();
                contributor.fillRelatedFiles(xmlFile, (Set<PsiFile>)resultSet);
                for (PsiFile f2 : resultSet) {
                    items2.add(new GotoRelatedItem((PsiElement)f2, contributor.getGroupName()));
                }
            }
        }
        return items2;
    }
}

