/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.NotificationDisplayType;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationSettings {
    private final String myGroupId;
    private final NotificationDisplayType myDisplayType;
    private final boolean myShouldLog;
    private final boolean myShouldReadAloud;

    public NotificationSettings(String groupId, NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud) {
        this.myGroupId = groupId;
        this.myDisplayType = displayType;
        this.myShouldLog = shouldLog;
        this.myShouldReadAloud = shouldReadAloud;
    }

    @NotNull
    public String getGroupId() {
        String string2 = this.myGroupId;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationSettings", "getGroupId"));
        }
        return string2;
    }

    @NotNull
    public NotificationDisplayType getDisplayType() {
        NotificationDisplayType notificationDisplayType = this.myDisplayType;
        if (notificationDisplayType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationSettings", "getDisplayType"));
        }
        return notificationDisplayType;
    }

    public boolean isShouldLog() {
        return this.myShouldLog;
    }

    public NotificationSettings withShouldLog(boolean shouldLog) {
        return new NotificationSettings(this.myGroupId, this.myDisplayType, shouldLog, this.myShouldReadAloud);
    }

    public boolean isShouldReadAloud() {
        return this.myShouldReadAloud;
    }

    public NotificationSettings withShouldReadAloud(boolean shouldReadAloud) {
        return new NotificationSettings(this.myGroupId, this.myDisplayType, this.myShouldLog, shouldReadAloud);
    }

    public NotificationSettings withDisplayType(NotificationDisplayType displayType) {
        return new NotificationSettings(this.myGroupId, displayType, this.myShouldLog, this.myShouldReadAloud);
    }

    @Nullable
    public static NotificationSettings load(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/notification/impl/NotificationSettings", "load"));
        }
        String displayTypeString = element.getAttributeValue("displayType");
        NotificationDisplayType displayType = NotificationDisplayType.BALLOON;
        boolean shouldLog = !"false".equals(element.getAttributeValue("shouldLog"));
        boolean shouldReadAloud = "true".equals(element.getAttributeValue("shouldReadAloud"));
        if ("BALLOON_ONLY".equals(displayTypeString)) {
            shouldLog = false;
            displayType = NotificationDisplayType.BALLOON;
        } else if (displayTypeString != null) {
            try {
                displayType = NotificationDisplayType.valueOf((String)displayTypeString.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String groupId = element.getAttributeValue("groupId");
        return groupId != null ? new NotificationSettings(groupId, displayType, shouldLog, shouldReadAloud) : null;
    }

    @NotNull
    public Element save() {
        Element result2 = new Element("notification");
        result2.setAttribute("groupId", this.getGroupId());
        NotificationDisplayType displayType = this.getDisplayType();
        if (displayType != NotificationDisplayType.BALLOON) {
            result2.setAttribute("displayType", displayType.toString());
        }
        if (!this.myShouldLog) {
            result2.setAttribute("shouldLog", "false");
        }
        if (this.myShouldReadAloud) {
            result2.setAttribute("shouldReadAloud", "true");
        }
        Element element = result2;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationSettings", "save"));
        }
        return element;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof NotificationSettings)) {
            return false;
        }
        NotificationSettings settings = (NotificationSettings)o2;
        if (this.myShouldLog != settings.myShouldLog) {
            return false;
        }
        if (this.myShouldReadAloud != settings.myShouldReadAloud) {
            return false;
        }
        if (this.myDisplayType != settings.myDisplayType) {
            return false;
        }
        return this.myGroupId.equals(settings.myGroupId);
    }

    public int hashCode() {
        int result2 = this.myGroupId.hashCode();
        result2 = 31 * result2 + this.myDisplayType.hashCode();
        result2 = 31 * result2 + (this.myShouldLog ? 1 : 0);
        result2 = 31 * result2 + (this.myShouldReadAloud ? 1 : 0);
        return result2;
    }
}

