/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.impl.NotificationParentGroup;
import com.intellij.notification.impl.NotificationParentGroupBean;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.StripeTable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.IndexTreePathState;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class NotificationsConfigurablePanel
extends JPanel
implements Disposable {
    private static final String REMOVE_KEY = "REMOVE";
    private NotificationsTreeTable myTable;
    private final JCheckBox myDisplayBalloons;
    private final JCheckBox mySystemNotifications;

    public NotificationsConfigurablePanel() {
        this.setLayout(new BorderLayout(5, 5));
        this.myTable = new NotificationsTreeTable();
        this.myDisplayBalloons = new JCheckBox("Display balloon notifications");
        this.myDisplayBalloons.setMnemonic('b');
        this.myDisplayBalloons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                NotificationsConfigurablePanel.this.myTable.repaint();
            }
        });
        this.mySystemNotifications = new JCheckBox("Enable system notifications");
        this.mySystemNotifications.setMnemonic('s');
        this.mySystemNotifications.setVisible(SystemNotifications.getInstance().isAvailable());
        JPanel boxes = new JPanel();
        boxes.setLayout(new BoxLayout(boxes, 1));
        boxes.add(this.myDisplayBalloons);
        boxes.add(this.mySystemNotifications);
        this.add((Component)boxes, "North");
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTable)), "Center");
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), REMOVE_KEY);
        this.myTable.getActionMap().put(REMOVE_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                NotificationsConfigurablePanel.this.removeSelected();
            }
        });
    }

    private void removeSelected() {
        this.myTable.removeSelected();
    }

    public void dispose() {
        this.myTable = null;
    }

    public boolean isModified() {
        List<SettingsWrapper> list2 = this.myTable.getAllSettings();
        for (SettingsWrapper settingsWrapper : list2) {
            if (!settingsWrapper.hasChanged()) continue;
            return true;
        }
        NotificationsConfigurationImpl configuration = NotificationsConfigurationImpl.getInstanceImpl();
        return configuration.SHOW_BALLOONS != this.myDisplayBalloons.isSelected() || configuration.SYSTEM_NOTIFICATIONS != this.mySystemNotifications.isSelected();
    }

    public void apply() {
        List<SettingsWrapper> list2 = this.myTable.getAllSettings();
        for (SettingsWrapper settingsWrapper : list2) {
            settingsWrapper.apply();
        }
        NotificationsConfigurationImpl configuration = NotificationsConfigurationImpl.getInstanceImpl();
        configuration.SHOW_BALLOONS = this.myDisplayBalloons.isSelected();
        configuration.SYSTEM_NOTIFICATIONS = this.mySystemNotifications.isSelected();
    }

    public void reset() {
        List<SettingsWrapper> list2 = this.myTable.getAllSettings();
        for (SettingsWrapper settingsWrapper : list2) {
            settingsWrapper.reset();
        }
        NotificationsConfigurationImpl configuration = NotificationsConfigurationImpl.getInstanceImpl();
        this.myDisplayBalloons.setSelected(configuration.SHOW_BALLOONS);
        this.mySystemNotifications.setSelected(configuration.SYSTEM_NOTIFICATIONS);
        this.myTable.invalidate();
        this.myTable.repaint();
    }

    public void selectGroup(String searchQuery) {
        ((SpeedSearchSupply)ObjectUtils.assertNotNull((Object)SpeedSearchSupply.getSupply((JComponent)((Object)this.myTable), (boolean)true))).findAndSelectElement(searchQuery);
    }

    private static class NotificationsTreeTableModel
    extends DefaultTreeModel
    implements TreeTableModel {
        private final List<SettingsWrapper> mySettings = new ArrayList<SettingsWrapper>();
        private JTree myTree;

        public NotificationsTreeTableModel() {
            super(null);
            ArrayList<DefaultMutableTreeNode> rootChildren = new ArrayList<DefaultMutableTreeNode>();
            HashMap<NotificationParentGroupBean, List<DefaultMutableTreeNode>> parentChildrenTable = new HashMap<NotificationParentGroupBean, List<DefaultMutableTreeNode>>();
            for (NotificationSettings setting : NotificationsConfigurationImpl.getInstanceImpl().getAllSettings()) {
                ArrayList<DefaultMutableTreeNode> children2;
                SettingsWrapper wrapper = new SettingsWrapper(setting);
                this.mySettings.add(wrapper);
                NotificationParentGroupBean parentGroup = NotificationParentGroup.findParent(setting);
                DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(wrapper, false);
                if (parentGroup == null) {
                    rootChildren.add(treeNode);
                    continue;
                }
                wrapper.myTitle = NotificationParentGroup.getReplaceTitle(wrapper.getGroupId());
                if (wrapper.myTitle == null && parentGroup.titlePrefix != null) {
                    wrapper.myTitle = StringUtil.substringAfter((String)wrapper.getGroupId(), (String)parentGroup.titlePrefix);
                }
                if ((children2 = (ArrayList<DefaultMutableTreeNode>)parentChildrenTable.get((Object)parentGroup)) == null) {
                    children2 = new ArrayList<DefaultMutableTreeNode>();
                    parentChildrenTable.put(parentGroup, children2);
                }
                children2.add(treeNode);
            }
            for (NotificationParentGroupBean parentGroup : NotificationParentGroup.getParents()) {
                if (parentGroup.parentId != null) continue;
                DefaultMutableTreeNode node = new DefaultMutableTreeNode((Object)parentGroup);
                NotificationsTreeTableModel.addParentGroup(parentGroup, node, parentChildrenTable);
                rootChildren.add(node);
            }
            Collections.sort(rootChildren, (node1, node2) -> {
                Object object1 = node1.getUserObject();
                Object object2 = node2.getUserObject();
                if (object1 instanceof NotificationParentGroupBean) {
                    if (object2 instanceof NotificationParentGroupBean) {
                        return object1.toString().compareTo(object2.toString());
                    }
                    return -1;
                }
                if (object2 instanceof SettingsWrapper) {
                    return ((SettingsWrapper)object1).getGroupId().compareTo(((SettingsWrapper)object2).getGroupId());
                }
                return 1;
            });
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            for (DefaultMutableTreeNode child : rootChildren) {
                root.add(child);
            }
            this.setRoot(root);
        }

        private static void addParentGroup(@NotNull NotificationParentGroupBean parent, @NotNull DefaultMutableTreeNode node, @NotNull Map<NotificationParentGroupBean, List<DefaultMutableTreeNode>> parentChildrenTable) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTreeTableModel", "addParentGroup"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTreeTableModel", "addParentGroup"));
            }
            if (parentChildrenTable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentChildrenTable", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTreeTableModel", "addParentGroup"));
            }
            for (NotificationParentGroupBean child : NotificationParentGroup.getChildren(parent)) {
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode((Object)child);
                NotificationsTreeTableModel.addParentGroup(child, childNode, parentChildrenTable);
                node.add(childNode);
            }
            List<DefaultMutableTreeNode> nodes = parentChildrenTable.get((Object)parent);
            if (nodes != null) {
                for (DefaultMutableTreeNode childNode : nodes) {
                    node.add(childNode);
                }
            }
        }

        public int getColumnCount() {
            return SystemInfo.isMac ? 4 : 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Group";
                }
                case 2: {
                    return "Log";
                }
                case 3: {
                    return "Read aloud";
                }
            }
            return "Popup";
        }

        public Class getColumnClass(int column) {
            if (1 == column) {
                return NotificationDisplayType.class;
            }
            if (2 == column) {
                return Boolean.class;
            }
            if (3 == column) {
                return Boolean.class;
            }
            return TreeTableModel.class;
        }

        public boolean isCellEditable(Object node, int column) {
            return column > 0 && ((DefaultMutableTreeNode)node).getUserObject() instanceof SettingsWrapper;
        }

        public Object getValueAt(Object node, int column) {
            if (column == 0) {
                return node;
            }
            Object object = ((DefaultMutableTreeNode)node).getUserObject();
            if (object instanceof NotificationParentGroupBean) {
                return null;
            }
            SettingsWrapper wrapper = (SettingsWrapper)object;
            switch (column) {
                case 2: {
                    return wrapper.myVersion.isShouldLog();
                }
                case 3: {
                    return wrapper.myVersion.isShouldReadAloud();
                }
            }
            return wrapper.myVersion.getDisplayType();
        }

        public void setValueAt(Object value2, Object node, int column) {
            SettingsWrapper wrapper = (SettingsWrapper)((DefaultMutableTreeNode)node).getUserObject();
            switch (column) {
                case 1: {
                    wrapper.myVersion = wrapper.myVersion.withDisplayType((NotificationDisplayType)value2);
                    break;
                }
                case 2: {
                    wrapper.myVersion = wrapper.myVersion.withShouldLog((Boolean)value2);
                    break;
                }
                case 3: {
                    wrapper.myVersion = wrapper.myVersion.withShouldReadAloud((Boolean)value2);
                }
            }
        }

        public void setTree(JTree tree2) {
            this.myTree = tree2;
            tree2.setRootVisible(false);
        }

        public TreePath removeRow(int row) {
            Pair<DefaultMutableTreeNode, Object> rowValue = this.getRowValue(row);
            if (rowValue.second instanceof SettingsWrapper) {
                ((SettingsWrapper)rowValue.second).remove();
            } else {
                NotificationsTreeTableModel.removeChildSettings((DefaultMutableTreeNode)rowValue.first);
            }
            return this.removeNode((DefaultMutableTreeNode)rowValue.first);
        }

        private static void removeChildSettings(DefaultMutableTreeNode node) {
            int count = node.getChildCount();
            for (int i2 = 0; i2 < count; ++i2) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i2);
                Object object = child.getUserObject();
                if (object instanceof SettingsWrapper) {
                    ((SettingsWrapper)object).remove();
                    continue;
                }
                NotificationsTreeTableModel.removeChildSettings(child);
            }
        }

        private TreePath removeNode(DefaultMutableTreeNode node) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            if (parent != null) {
                IndexTreePathState state = new IndexTreePathState(TreeUtil.getPathFromRoot((TreeNode)node));
                this.removeNodeFromParent(node);
                if (parent.isLeaf()) {
                    return this.removeNode(parent);
                }
                return state.getRestoredPath();
            }
            return null;
        }

        public Pair<DefaultMutableTreeNode, Object> getRowValue(int row) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.myTree.getPathForRow(row).getLastPathComponent();
            return Pair.create((Object)node, (Object)node.getUserObject());
        }

        public List<SettingsWrapper> getAllSettings() {
            return this.mySettings;
        }
    }

    private static class TreeColumnCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private final JTable myTable;

        public TreeColumnCellRenderer(@NotNull JTable table2) {
            if (table2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$TreeColumnCellRenderer", "<init>"));
            }
            this.myTable = table2;
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setForeground(selected ? this.myTable.getSelectionForeground() : this.myTable.getForeground());
            this.setText(value2.toString());
            return this;
        }
    }

    private class NotificationsTreeTable
    extends TreeTable {
        private static final int ID_COLUMN = 0;
        private static final int DISPLAY_TYPE_COLUMN = 1;
        private static final int LOG_COLUMN = 2;
        private static final int READ_ALOUD_COLUMN = 3;

        public NotificationsTreeTable() {
            super((TreeTableModel)new NotificationsTreeTableModel());
            StripeTable.apply((JBTable)this);
            this.setSelectionMode(0);
            this.getTree().setCellRenderer((TreeCellRenderer)new TreeColumnCellRenderer((JTable)((Object)this)));
            TableColumn idColumn = this.getColumnModel().getColumn(0);
            idColumn.setPreferredWidth(200);
            TableColumn displayTypeColumn = this.getColumnModel().getColumn(1);
            displayTypeColumn.setMaxWidth(300);
            displayTypeColumn.setPreferredWidth(250);
            displayTypeColumn.setCellRenderer((TableCellRenderer)new ComboBoxTableRenderer<NotificationDisplayType>(NotificationDisplayType.values()){

                protected void customizeComponent(NotificationDisplayType value2, JTable table2, boolean isSelected) {
                    super.customizeComponent((Object)(NotificationsConfigurablePanel.this.myDisplayBalloons.isSelected() ? value2 : NotificationDisplayType.NONE), table2, isSelected);
                    if (!NotificationsConfigurablePanel.this.myDisplayBalloons.isSelected() && !isSelected) {
                        this.setBackground(UIUtil.getComboBoxDisabledBackground());
                        this.setForeground(UIUtil.getComboBoxDisabledForeground());
                    }
                }

                protected String getTextFor(@NotNull NotificationDisplayType value2) {
                    if (value2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTreeTable$1", "getTextFor"));
                    }
                    return value2.getTitle();
                }
            });
            displayTypeColumn.setCellEditor((TableCellEditor)new ComboBoxTableRenderer<NotificationDisplayType>(NotificationDisplayType.values()){

                public boolean isCellEditable(EventObject event) {
                    if (!NotificationsConfigurablePanel.this.myDisplayBalloons.isSelected()) {
                        return false;
                    }
                    if (event instanceof MouseEvent) {
                        return ((MouseEvent)event).getClickCount() >= 1;
                    }
                    return false;
                }

                protected boolean isApplicable(NotificationDisplayType value2, int row) {
                    if (value2 != NotificationDisplayType.TOOL_WINDOW) {
                        return true;
                    }
                    Object wrapper = ((NotificationsTreeTableModel)NotificationsTreeTable.this.getTableModel()).getRowValue((int)row).second;
                    String groupId = ((SettingsWrapper)wrapper).getGroupId();
                    return NotificationsConfigurationImpl.getInstanceImpl().hasToolWindowCapability(groupId);
                }

                protected String getTextFor(@NotNull NotificationDisplayType value2) {
                    if (value2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTreeTable$2", "getTextFor"));
                    }
                    return value2.getTitle();
                }
            });
            TableColumn logColumn = this.getColumnModel().getColumn(2);
            logColumn.setMaxWidth(logColumn.getPreferredWidth());
            logColumn.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
            if (SystemInfo.isMac) {
                TableColumn readAloudColumn = this.getColumnModel().getColumn(3);
                readAloudColumn.setMaxWidth(readAloudColumn.getPreferredWidth());
                readAloudColumn.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
            }
            new TableSpeedSearch((JTable)((Object)this));
            this.getEmptyText().setText("No notifications configured");
            TreeUtil.expandAll((JTree)this.getTree());
        }

        public Dimension getMinimumSize() {
            return this.calcSize(super.getMinimumSize());
        }

        public Dimension getPreferredSize() {
            return this.calcSize(super.getPreferredSize());
        }

        private Dimension calcSize(@NotNull Dimension s2) {
            if (s2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTreeTable", "calcSize"));
            }
            Container container = this.getParent();
            if (container != null) {
                Dimension size = container.getSize();
                return new Dimension(size.width, s2.height);
            }
            return s2;
        }

        public List<SettingsWrapper> getAllSettings() {
            return ((NotificationsTreeTableModel)this.getTableModel()).getAllSettings();
        }

        public void removeSelected() {
            ListSelectionModel selectionModel = this.getSelectionModel();
            if (!selectionModel.isSelectionEmpty()) {
                int selection = selectionModel.getMinSelectionIndex();
                TreePath newSelection = ((NotificationsTreeTableModel)this.getTableModel()).removeRow(selection);
                this.addSelectedPath(newSelection);
            }
        }
    }

    private static class SettingsWrapper {
        private boolean myRemoved = false;
        private NotificationSettings myVersion;
        private String myTitle;

        private SettingsWrapper(NotificationSettings settings) {
            this.myVersion = settings;
        }

        public boolean hasChanged() {
            return this.myRemoved || !this.getOriginalSettings().equals(this.myVersion);
        }

        public void remove() {
            this.myRemoved = true;
        }

        public boolean isRemoved() {
            return this.myRemoved;
        }

        @NotNull
        private NotificationSettings getOriginalSettings() {
            NotificationSettings notificationSettings = NotificationsConfigurationImpl.getSettings(this.getGroupId());
            if (notificationSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$SettingsWrapper", "getOriginalSettings"));
            }
            return notificationSettings;
        }

        public void apply() {
            if (this.myRemoved) {
                NotificationsConfigurationImpl.remove(this.getGroupId());
            } else {
                NotificationsConfigurationImpl.getInstanceImpl().changeSettings(this.myVersion);
            }
        }

        public void reset() {
            this.myVersion = this.getOriginalSettings();
            this.myRemoved = false;
        }

        String getGroupId() {
            return this.myVersion.getGroupId();
        }

        public String toString() {
            return this.myTitle == null ? this.getGroupId() : this.myTitle;
        }
    }
}

