/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.impl.ui.NotificationsUtil");
    private static final int TITLE_LIMIT = 1000;
    private static final int CONTENT_LIMIT = 10000;

    @NotNull
    public static String buildHtml(@NotNull Notification notification, @Nullable String style) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/ui/NotificationsUtil", "buildHtml"));
        }
        String title = notification.getTitle();
        String content2 = notification.getContent();
        if (title.length() > 1000 || content2.length() > 10000) {
            LOG.info("Too large notification " + notification + " of " + notification.getClass() + "\nListener=" + notification.getListener() + "\nTitle=" + title + "\nContent=" + content2);
            title = StringUtil.trimLog((String)title, (int)1000);
            content2 = StringUtil.trimLog((String)content2, (int)10000);
        }
        String string2 = NotificationsUtil.buildHtml(title, null, content2, style, "#" + ColorUtil.toHex((Color)NotificationsUtil.getMessageType(notification).getTitleForeground()), null, null);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/ui/NotificationsUtil", "buildHtml"));
        }
        return string2;
    }

    @NotNull
    public static String buildHtml(@NotNull Notification notification, @Nullable String style, boolean isContent, @Nullable Color color, @Nullable String contentStyle) {
        String content2;
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/ui/NotificationsUtil", "buildHtml"));
        }
        String title = !isContent ? notification.getTitle() : "";
        String subtitle = !isContent ? notification.getSubtitle() : null;
        String string2 = content2 = isContent ? notification.getContent() : "";
        if (title.length() > 1000 || StringUtil.length((CharSequence)subtitle) > 1000 || content2.length() > 10000) {
            LOG.info("Too large notification " + notification + " of " + notification.getClass() + "\nListener=" + notification.getListener() + "\nTitle=" + title + "\nSubtitle=" + subtitle + "\nContent=" + content2);
            title = StringUtil.trimLog((String)title, (int)1000);
            subtitle = StringUtil.trimLog((String)StringUtil.notNullize((String)subtitle), (int)1000);
            content2 = StringUtil.trimLog((String)content2, (int)10000);
        }
        if (isContent) {
            content2 = StringUtil.replace((String)content2, (String)"<p/>", (String)"<br>");
        }
        String colorText = color == null ? null : "#" + ColorUtil.toHex((Color)color);
        String string3 = NotificationsUtil.buildHtml(title, subtitle, content2, style, isContent ? null : colorText, isContent ? colorText : null, contentStyle);
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/ui/NotificationsUtil", "buildHtml"));
        }
        return string3;
    }

    @NotNull
    public static String buildHtml(@Nullable String title, @Nullable String subtitle, @Nullable String content2, @Nullable String style, @Nullable String titleColor, @Nullable String contentColor, @Nullable String contentStyle) {
        if (StringUtil.isEmpty((String)title) && !StringUtil.isEmpty((String)subtitle)) {
            title = subtitle;
            subtitle = null;
        } else if (!StringUtil.isEmpty((String)title) && !StringUtil.isEmpty((String)subtitle)) {
            title = title + ":";
        }
        StringBuilder result2 = new StringBuilder();
        if (style != null) {
            result2.append("<div style=\"").append(style).append("\">");
        }
        if (!StringUtil.isEmpty((String)title)) {
            result2.append("<b").append(titleColor == null ? ">" : " color=\"" + titleColor + "\">").append(title).append("</b>");
        }
        if (!StringUtil.isEmpty((String)subtitle)) {
            result2.append("&nbsp;").append(titleColor == null ? "" : "<span color=\"" + titleColor + "\">").append(subtitle).append(titleColor == null ? "" : "</span>");
        }
        if (!StringUtil.isEmpty((String)content2)) {
            result2.append("<div").append(contentStyle == null ? "" : " style=\"" + contentStyle + "\"").append(contentColor == null ? ">" : " color=\"" + contentColor + "\">").append(content2).append("</div>");
        }
        if (style != null) {
            result2.append("</div>");
        }
        String string2 = XmlStringUtil.wrapInHtml((CharSequence)result2.toString());
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/ui/NotificationsUtil", "buildHtml"));
        }
        return string2;
    }

    @Nullable
    public static String getFontStyle() {
        String fontName = NotificationsUtil.getFontName();
        return StringUtil.isEmpty((String)fontName) ? null : "font-family:" + fontName + ";";
    }

    @Nullable
    public static Pair<String, Integer> getFontData() {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getOverrideLafFonts()) {
            return Pair.create((Object)uiSettings.getFontFace(), (Object)uiSettings.getFontSize());
        }
        return UIUtil.getSystemFontData();
    }

    @Nullable
    public static String getFontName() {
        Pair<String, Integer> data = NotificationsUtil.getFontData();
        return data == null ? null : (String)data.first;
    }

    @Nullable
    public static HyperlinkListener wrapListener(final @NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/ui/NotificationsUtil", "wrapListener"));
        }
        NotificationListener listener2 = notification.getListener();
        if (listener2 == null) {
            return null;
        }
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e2) {
                NotificationListener listener1;
                if (e2.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (listener1 = notification.getListener()) != null) {
                    listener1.hyperlinkUpdate(notification, e2);
                }
            }
        };
    }

    @NotNull
    public static Icon getIcon(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/ui/NotificationsUtil", "getIcon"));
        }
        Icon icon = notification.getIcon();
        if (icon != null) {
            Icon icon2 = icon;
            if (icon2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/ui/NotificationsUtil", "getIcon"));
            }
            return icon2;
        }
        switch (notification.getType()) {
            case WARNING: {
                Icon icon3 = AllIcons.General.BalloonWarning;
                if (icon3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/ui/NotificationsUtil", "getIcon"));
                }
                return icon3;
            }
            case ERROR: {
                Icon icon4 = AllIcons.Ide.FatalError;
                if (icon4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/ui/NotificationsUtil", "getIcon"));
                }
                return icon4;
            }
        }
        Icon icon5 = AllIcons.General.BalloonInformation;
        if (icon5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/ui/NotificationsUtil", "getIcon"));
        }
        return icon5;
    }

    @NotNull
    public static MessageType getMessageType(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/ui/NotificationsUtil", "getMessageType"));
        }
        switch (notification.getType()) {
            case WARNING: {
                MessageType messageType = MessageType.WARNING;
                if (messageType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/ui/NotificationsUtil", "getMessageType"));
                }
                return messageType;
            }
            case ERROR: {
                MessageType messageType = MessageType.ERROR;
                if (messageType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/ui/NotificationsUtil", "getMessageType"));
                }
                return messageType;
            }
        }
        MessageType messageType = MessageType.INFO;
        if (messageType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/ui/NotificationsUtil", "getMessageType"));
        }
        return messageType;
    }
}

