/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.ui.Gray;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class StickyButtonUI<B extends AbstractButton>
extends BasicToggleButtonUI {
    public static final float FONT_SIZE = 11.0f;

    @Override
    protected void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        b2.setFont(UIManager.getFont("Button.font").deriveFont(1, 11.0f));
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        ButtonModel model2;
        AbstractButton button = (AbstractButton)c2;
        int width = button.getWidth();
        int height = button.getHeight();
        Graphics2D g22 = (Graphics2D)g2.create();
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int arcSize = this.getArcSize();
        if (c2.isOpaque()) {
            g22.setColor(c2.getBackground());
            g22.fillRoundRect(0, 0, width - 1, height - 1, arcSize, arcSize);
        }
        if ((model2 = button.getModel()).isSelected()) {
            g22.setColor(this.getSelectionColor(button));
            g22.fillRoundRect(0, 0, width - 1, height - 1, this.getArcSize(), this.getArcSize());
        } else if (model2.isRollover()) {
            g22.setColor(this.getRolloverColor(button));
            g22.fillRoundRect(0, 0, width - 1, height - 1, arcSize, arcSize);
        } else {
            Color bg = this.getBackgroundColor(button);
            if (bg != null) {
                g22.setColor(bg);
                g22.fillRoundRect(0, 0, width - 1, height - 1, arcSize, arcSize);
            }
        }
        if (button.hasFocus()) {
            g22.setColor(this.getFocusColor(button));
            g22.drawRoundRect(0, 0, width - 1, height - 1, arcSize, arcSize);
        }
        g22.dispose();
        super.paint(g2, c2);
    }

    protected Color getFocusColor(B button) {
        return Gray._100;
    }

    protected Color getSelectionColor(B button) {
        return Color.GRAY;
    }

    protected Color getRolloverColor(B button) {
        return Color.LIGHT_GRAY;
    }

    protected Color getBackgroundColor(B button) {
        return null;
    }

    protected int getArcSize() {
        return 10;
    }
}

