/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionPopupMenuImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionButton
extends JComponent
implements ActionButtonComponent,
AnActionHolder,
Accessible {
    private static final Icon ourEmptyIcon = EmptyIcon.ICON_18;
    private JBDimension myMinimumButtonSize;
    private PropertyChangeListener myPresentationListener;
    private Icon myDisabledIcon;
    private Icon myIcon;
    protected final Presentation myPresentation;
    protected final AnAction myAction;
    protected final String myPlace;
    private ActionButtonLook myLook;
    private boolean myMouseDown;
    private boolean myRollover;
    private static boolean ourGlobalMouseDown = false;
    private boolean myNoIconsInPopup;
    private Insets myInsets;

    public ActionButton(AnAction action2, Presentation presentation, String place, @NotNull Dimension minimumSize) {
        if (minimumSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimumSize", "com/intellij/openapi/actionSystem/impl/ActionButton", "<init>"));
        }
        this.myLook = ActionButtonLook.IDEA_LOOK;
        this.myNoIconsInPopup = false;
        this.setMinimumButtonSize(minimumSize);
        this.setIconInsets(null);
        this.myRollover = false;
        this.myMouseDown = false;
        this.myAction = action2;
        this.myPresentation = presentation;
        this.myPlace = place;
        this.setFocusable(ScreenReader.isActive());
        this.enableEvents(16L);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                if (e2.getModifiers() == 0 && e2.getKeyCode() == 32) {
                    ActionButton.this.click();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e2) {
                ActionButton.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e2) {
                ActionButton.this.repaint();
            }
        });
        this.putClientProperty("ToCenterTooltip", Boolean.TRUE);
    }

    public void setNoIconsInPopup(boolean noIconsInPopup) {
        this.myNoIconsInPopup = noIconsInPopup;
    }

    public void setMinimumButtonSize(@NotNull Dimension size) {
        if (size == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/openapi/actionSystem/impl/ActionButton", "setMinimumButtonSize"));
        }
        this.myMinimumButtonSize = JBDimension.create((Dimension)size);
    }

    @Override
    public void paintChildren(Graphics g2) {
    }

    public int getPopState() {
        if (this.myAction instanceof Toggleable) {
            Boolean selected = (Boolean)this.myPresentation.getClientProperty("selected");
            boolean flag1 = selected != null && selected != false;
            return this.getPopState(flag1);
        }
        return this.getPopState(false);
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.myPresentation.isEnabled();
    }

    protected boolean isButtonEnabled() {
        return this.isEnabled();
    }

    private void onMousePresenceChanged(boolean setInfo) {
        ActionMenu.showDescriptionInStatusBar(setInfo, this, this.myPresentation.getDescription());
    }

    public void click() {
        this.performAction(new MouseEvent(this, 500, System.currentTimeMillis(), 0, 0, 0, 1, false));
    }

    private void performAction(MouseEvent e2) {
        AnActionEvent event = AnActionEvent.createFromInputEvent((InputEvent)e2, (String)this.myPlace, (Presentation)this.myPresentation, (DataContext)this.getDataContext());
        if (!ActionUtil.lastUpdateAndCheckDumb((AnAction)this.myAction, (AnActionEvent)event, (boolean)false)) {
            return;
        }
        if (this.isButtonEnabled()) {
            ActionManagerEx manager = ActionManagerEx.getInstanceEx();
            DataContext dataContext = event.getDataContext();
            manager.fireBeforeActionPerformed(this.myAction, dataContext, event);
            Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            if (component != null && !component.isShowing()) {
                return;
            }
            this.actionPerformed(event);
            manager.queueActionPerformedEvent(this.myAction, dataContext, event);
        }
    }

    protected DataContext getDataContext() {
        ActionToolbar actionToolbar = (ActionToolbar)UIUtil.getParentOfType(ActionToolbar.class, (Component)this);
        return actionToolbar != null ? actionToolbar.getToolbarDataContext() : DataManager.getInstance().getDataContext();
    }

    private void actionPerformed(AnActionEvent event) {
        if (this.myAction instanceof ActionGroup && !(this.myAction instanceof CustomComponentAction) && ((ActionGroup)this.myAction).isPopup() && !((ActionGroup)this.myAction).canBePerformed(event.getDataContext())) {
            ActionManagerImpl am = (ActionManagerImpl)ActionManager.getInstance();
            ActionPopupMenuImpl popupMenu = (ActionPopupMenuImpl)am.createActionPopupMenu(event.getPlace(), (ActionGroup)this.myAction, new MenuItemPresentationFactory(){

                @Override
                protected void processPresentation(Presentation presentation) {
                    if (ActionButton.this.myNoIconsInPopup) {
                        presentation.setIcon(null);
                        presentation.setHoveredIcon(null);
                    }
                }
            });
            popupMenu.setDataContextProvider((Getter<DataContext>)((Getter)() -> this.getDataContext()));
            if (ActionPlaces.isToolbarPlace((String)event.getPlace())) {
                popupMenu.getComponent().show(this, 0, this.getHeight());
            } else {
                popupMenu.getComponent().show(this, this.getWidth(), 0);
            }
        } else {
            ActionUtil.performActionDumbAware((AnAction)this.myAction, (AnActionEvent)event);
        }
    }

    @Override
    public void removeNotify() {
        if (this.myPresentationListener != null) {
            this.myPresentation.removePropertyChangeListener(this.myPresentationListener);
            this.myPresentationListener = null;
        }
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.myPresentationListener == null) {
            this.myPresentationListener = this::presentationPropertyChanded;
            this.myPresentation.addPropertyChangeListener(this.myPresentationListener);
        }
        AnActionEvent e2 = new AnActionEvent(null, this.getDataContext(), this.myPlace, this.myPresentation, ActionManager.getInstance(), 0);
        ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)this.myAction, (AnActionEvent)e2, (boolean)false);
        this.updateToolTipText();
        this.updateIcon();
    }

    @Override
    public void setToolTipText(String s2) {
        String tooltipText = KeymapUtil.createTooltipText((String)s2, (AnAction)this.myAction);
        super.setToolTipText(tooltipText.length() > 0 ? tooltipText : null);
    }

    @Override
    public Dimension getPreferredSize() {
        Icon icon = this.getIcon();
        if (icon.getIconWidth() < this.myMinimumButtonSize.width && icon.getIconHeight() < this.myMinimumButtonSize.height) {
            return this.myMinimumButtonSize;
        }
        return new Dimension(Math.max(this.myMinimumButtonSize.width, icon.getIconWidth() + this.myInsets.left + this.myInsets.right), Math.max(this.myMinimumButtonSize.height, icon.getIconHeight() + this.myInsets.top + this.myInsets.bottom));
    }

    public void setIconInsets(@Nullable Insets insets) {
        this.myInsets = insets != null ? JBUI.insets((Insets)insets) : new Insets(0, 0, 0, 0);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected Icon getIcon() {
        Icon icon = this.isButtonEnabled() ? this.myIcon : this.myDisabledIcon;
        return icon == null ? ourEmptyIcon : icon;
    }

    public void updateIcon() {
        this.myIcon = this.myPresentation.getIcon();
        this.myDisabledIcon = this.myPresentation.getDisabledIcon() != null ? this.myPresentation.getDisabledIcon() : IconLoader.getDisabledIcon((Icon)this.myIcon);
    }

    private void setDisabledIcon(Icon icon) {
        this.myDisabledIcon = icon;
    }

    void updateToolTipText() {
        String text2 = this.myPresentation.getText();
        this.setToolTipText(text2 == null ? this.myPresentation.getDescription() : text2);
    }

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        this.paintButtonLook(g2);
        if (this.myAction instanceof ActionGroup && ((ActionGroup)this.myAction).isPopup()) {
            int x2 = 5;
            int y2 = 4;
            if (this.getPopState() == -1) {
                ++x2;
                ++y2;
            }
            AllIcons.General.Dropdown.paintIcon(this, g2, JBUI.scale((int)x2), JBUI.scale((int)y2));
        }
    }

    protected void paintButtonLook(Graphics g2) {
        ActionButtonLook look = this.getButtonLook();
        look.paintBackground(g2, this);
        look.paintIcon(g2, this, this.getIcon());
        look.paintBorder(g2, this);
    }

    protected ActionButtonLook getButtonLook() {
        return this.myLook;
    }

    public void setLook(ActionButtonLook look) {
        this.myLook = look != null ? look : ActionButtonLook.IDEA_LOOK;
        this.repaint();
    }

    @Override
    protected void processMouseEvent(MouseEvent e2) {
        super.processMouseEvent(e2);
        if (e2.isConsumed()) {
            return;
        }
        boolean skipPress = e2.isMetaDown() || e2.getButton() != 1;
        switch (e2.getID()) {
            case 501: {
                if (skipPress || !this.isButtonEnabled()) {
                    return;
                }
                this.myMouseDown = true;
                ourGlobalMouseDown = true;
                this.repaint();
                break;
            }
            case 502: {
                if (skipPress || !this.isButtonEnabled()) {
                    return;
                }
                this.myMouseDown = false;
                ourGlobalMouseDown = false;
                if (this.myRollover) {
                    this.performAction(e2);
                }
                this.repaint();
                break;
            }
            case 504: {
                if (!this.myMouseDown && ourGlobalMouseDown) break;
                this.myRollover = true;
                this.repaint();
                this.onMousePresenceChanged(true);
                break;
            }
            case 505: {
                this.myRollover = false;
                if (!this.myMouseDown && ourGlobalMouseDown) break;
                this.repaint();
                this.onMousePresenceChanged(false);
            }
        }
    }

    private int getPopState(boolean isPushed) {
        if (isPushed || this.myRollover && this.myMouseDown && this.isButtonEnabled()) {
            return -1;
        }
        if (this.myRollover && this.isButtonEnabled()) {
            return 1;
        }
        if (this.isFocusOwner()) {
            return 2;
        }
        return 0;
    }

    public AnAction getAction() {
        return this.myAction;
    }

    protected void presentationPropertyChanded(PropertyChangeEvent e2) {
        String propertyName = e2.getPropertyName();
        if ("text".equals(propertyName)) {
            this.updateToolTipText();
        } else if ("enabled".equals(propertyName)) {
            this.updateIcon();
            this.repaint();
        } else if ("icon".equals(propertyName)) {
            this.updateIcon();
            this.repaint();
        } else if ("disabledIcon".equals(propertyName)) {
            this.setDisabledIcon(this.myPresentation.getDisabledIcon());
            this.repaint();
        } else if (!"visible".equals(propertyName) && "selected".equals(propertyName)) {
            this.repaint();
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleActionButton();
        }
        return this.accessibleContext;
    }

    protected class AccessibleActionButton
    extends JComponent.AccessibleJComponent
    implements AccessibleAction {
        public AccessibleActionButton() {
            super(ActionButton.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        @Override
        public String getAccessibleName() {
            String name = this.accessibleName;
            if (name == null && (name = (String)ActionButton.this.getClientProperty("AccessibleName")) == null && (name = ActionButton.this.getToolTipText()) == null && (name = ActionButton.this.myPresentation.getText()) == null) {
                name = super.getAccessibleName();
            }
            return name;
        }

        @Override
        public AccessibleIcon[] getAccessibleIcon() {
            AccessibleContext context2;
            Icon icon = ActionButton.this.getIcon();
            if (icon instanceof Accessible && (context2 = ((Accessible)((Object)icon)).getAccessibleContext()) != null && context2 instanceof AccessibleIcon) {
                return new AccessibleIcon[]{(AccessibleIcon)((Object)context2)};
            }
            return null;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet var1 = super.getAccessibleStateSet();
            int state = ActionButton.this.getPopState();
            if (state == -1) {
                var1.add(AccessibleState.PRESSED);
            }
            if (state == 2) {
                var1.add(AccessibleState.CHECKED);
            }
            if (ActionButton.this.isFocusOwner()) {
                var1.add(AccessibleState.FOCUSED);
            }
            return var1;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int index) {
            return index == 0 ? UIManager.getString("AbstractButton.clickText") : null;
        }

        @Override
        public boolean doAccessibleAction(int index) {
            if (index == 0) {
                ActionButton.this.click();
                return true;
            }
            return false;
        }
    }
}

