/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChameleonAction
extends AnAction {
    private final Map<ProjectType, AnAction> myActions;

    public ChameleonAction(@NotNull AnAction first, ProjectType projectType) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/openapi/actionSystem/impl/ChameleonAction", "<init>"));
        }
        this.myActions = new HashMap<ProjectType, AnAction>();
        this.addAction(first, projectType);
        this.copyFrom(this.myActions.values().iterator().next());
    }

    public AnAction addAction(AnAction action2, ProjectType projectType) {
        if (action2 instanceof ActionStub) {
            String type = ((ActionStub)action2).getProjectType();
            if ((action2 = ActionManagerImpl.convertStub((ActionStub)action2)) == null) {
                return null;
            }
            projectType = type == null ? null : new ProjectType(type);
        }
        return this.myActions.put(projectType, action2);
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/impl/ChameleonAction", "actionPerformed"));
        }
        AnAction action2 = this.getAction(e2);
        assert (action2 != null);
        action2.actionPerformed(e2);
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/impl/ChameleonAction", "update"));
        }
        AnAction action2 = this.getAction(e2);
        if (action2 != null) {
            e2.getPresentation().setVisible(true);
            action2.update(e2);
        } else {
            e2.getPresentation().setVisible(false);
        }
    }

    @Nullable
    private AnAction getAction(AnActionEvent e2) {
        Project project2 = e2.getProject();
        ProjectType projectType = ProjectTypeService.getProjectType((Project)project2);
        AnAction action2 = this.myActions.get(projectType);
        if (action2 == null) {
            action2 = this.myActions.get(null);
        }
        return action2;
    }

    public Map<ProjectType, AnAction> getActions() {
        return this.myActions;
    }
}

