/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;

public class IdeaActionButtonLook
extends ActionButtonLook {
    private static final Color ALPHA_20 = Gray._0.withAlpha(20);
    private static final Color ALPHA_30 = Gray._0.withAlpha(30);
    private static final Color ALPHA_40 = Gray._0.withAlpha(40);
    private static final Color ALPHA_120 = Gray._0.withAlpha(120);
    private static final BasicStroke BASIC_STROKE = new BasicStroke();

    @Override
    public void paintBackground(Graphics g2, JComponent component, int state) {
        if (state != 0) {
            Component opaque = UIUtil.findNearestOpaque((Component)component);
            Color bg = opaque != null ? opaque.getBackground() : null;
            this.paintBackground(g2, component.getSize(), bg, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintBackground(Graphics g2, Dimension size, Color background, int state) {
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        try {
            Color bg;
            Color color = bg = background == null ? JBColor.background() : background;
            if (UIUtil.isUnderAquaLookAndFeel() || SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
                if (state == -1) {
                    if (UIUtil.isUnderAquaLookAndFeel()) {
                        ((Graphics2D)g2).setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)ALPHA_40, (float)size.width, (float)size.height, (Color)ALPHA_20));
                        ((Graphics2D)g2).fill(IdeaActionButtonLook.getShape(size));
                        g2.setColor(ALPHA_30);
                        ((Graphics2D)g2).draw(IdeaActionButtonLook.getShape(size));
                    } else {
                        g2.setColor(ColorUtil.darker((Color)bg, (int)1));
                        ((Graphics2D)g2).fill(IdeaActionButtonLook.getShape(size));
                        g2.setColor((Color)Gray.xC0);
                        ((Graphics2D)g2).draw(IdeaActionButtonLook.getShape(size));
                    }
                } else if (state == 1 || state == 2) {
                    if (UIUtil.isUnderAquaLookAndFeel()) {
                        ((Graphics2D)g2).setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)bg, (float)0.0f, (float)size.height, (Color)ColorUtil.darker((Color)bg, (int)2)));
                        ((Graphics2D)g2).fill(IdeaActionButtonLook.getShape(size));
                    } else {
                        ((Graphics2D)g2).setPaint(ColorUtil.darker((Color)bg, (int)1));
                        ((Graphics2D)g2).fill(IdeaActionButtonLook.getShape(size));
                        g2.setColor((Color)Gray.xCC);
                        ((Graphics2D)g2).draw(IdeaActionButtonLook.getShape(size));
                    }
                }
            } else {
                boolean dark = UIUtil.isUnderDarcula();
                Gray pushed = UIUtil.isUnderWin10LookAndFeel() ? Gray.xE6 : (dark ? ColorUtil.shift((Color)bg, (double)1.428) : Gray.xD0);
                Color dark_normal = Gray._255.withAlpha(40);
                g2.setColor((Color)(state == -1 ? pushed : (dark ? dark_normal : Gray.xD9)));
                ((Graphics2D)g2).fill(IdeaActionButtonLook.getShape(size));
            }
        }
        finally {
            config.restore();
        }
    }

    @Override
    public void paintBorder(Graphics g2, JComponent component, int state) {
        if (state != 0) {
            this.paintBorder(g2, component.getSize(), state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintBorder(Graphics g2, Dimension size, int state) {
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        try {
            if (UIUtil.isUnderAquaLookAndFeel()) {
                if (state == 1) {
                    g2.setColor((Color)JBColor.GRAY);
                    ((Graphics2D)g2).draw(IdeaActionButtonLook.getShape(size));
                }
            } else if (SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
            } else if (UIUtil.isUnderWin10LookAndFeel()) {
                g2.setColor((Color)Gray.xC4);
                g2.drawRect(1, 1, size.width - 3, size.height - 3);
                g2.setColor((Color)Gray.xD6);
                g2.drawLine(2, 2, size.width - 3, 2);
                g2.setColor((Color)Gray.xD9);
                g2.drawLine(2, 3, 2, size.width - 3);
                g2.drawLine(size.width - 3, 3, size.width - 3, size.width - 3);
            } else {
                Gray color = UIUtil.isUnderDarcula() ? ColorUtil.shift((Color)UIUtil.getPanelBackground(), (double)2.04) : Gray.xA1;
                g2.setColor((Color)color);
                ((Graphics2D)g2).setStroke(BASIC_STROKE);
                ((Graphics2D)g2).draw(IdeaActionButtonLook.getShape(size));
            }
        }
        finally {
            config.restore();
        }
    }

    private static Shape getShape(Dimension size) {
        if (UIUtil.isUnderWin10LookAndFeel()) {
            return new Rectangle2D.Double(1.0, 1.0, size.width - 3, size.height - 3);
        }
        return new RoundRectangle2D.Double(1.0, 1.0, size.width - 3, size.height - 3, 4.0, 4.0);
    }

    @Override
    public void paintIcon(Graphics g2, ActionButtonComponent actionButton, Icon icon) {
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        int x2 = (actionButton.getWidth() - width) / 2;
        int y2 = (actionButton.getHeight() - height) / 2;
        this.paintIconAt(g2, actionButton, icon, x2, y2);
    }

    @Override
    public void paintIconAt(Graphics g2, ActionButtonComponent button, Icon icon, int x2, int y2) {
        icon.paintIcon(null, g2, x2, y2);
    }
}

