/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.impl.IdeaActionButtonLook;
import com.intellij.ui.Gray;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;

public class PoppedIcon
implements Icon {
    private final Icon myIcon;
    private final int myWidth;
    private final int myHeight;
    private IdeaActionButtonLook myLook = new IdeaActionButtonLook();

    public PoppedIcon(Icon icon, int width, int height) {
        this.myIcon = icon;
        this.myWidth = width;
        this.myHeight = height;
    }

    public PoppedIcon(Icon icon) {
        this(icon, icon.getIconWidth(), icon.getIconHeight());
    }

    @Override
    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        Dimension size = new Dimension(this.getIconWidth() + 2 * x2, this.getIconHeight() + 2 * x2);
        this.myLook.paintBackground(g2, size, (Color)Gray._235, 1);
        this.myLook.paintBorder(g2, size, 1);
        this.myIcon.paintIcon(c2, g2, x2 + (this.getIconWidth() - this.myIcon.getIconWidth()) / 2, y2 + (this.getIconHeight() - this.myIcon.getIconHeight()) / 2);
    }

    @Override
    public int getIconWidth() {
        return this.myWidth;
    }

    @Override
    public int getIconHeight() {
        return this.myHeight;
    }
}

