/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AlwaysVisibleActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompactActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.IncludedInvisibleItemsActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Utils {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.impl.Utils");
    @NonNls
    public static final String NOTHING_HERE = "Nothing here";
    public static final AnAction EMPTY_MENU_FILLER = new AnAction("Nothing here"){
        {
            this.getTemplatePresentation().setEnabled(false);
        }

        public void actionPerformed(AnActionEvent e2) {
        }

        public void update(AnActionEvent e2) {
            e2.getPresentation().setEnabled(false);
            super.update(e2);
        }
    };

    private Utils() {
    }

    private static void handleUpdateException(AnAction action2, Presentation presentation, Throwable exc) {
        String id = ActionManager.getInstance().getId(action2);
        if (id != null) {
            LOG.error("update failed for AnAction with ID=" + id, exc);
        } else {
            LOG.error("update failed for ActionGroup: " + action2 + "[" + presentation.getText() + "]", exc);
        }
    }

    @Deprecated
    public static void expandActionGroup(@NotNull ActionGroup group, List<AnAction> list2, PresentationFactory presentationFactory, @NotNull DataContext context2, String place, ActionManager actionManager) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        Utils.expandActionGroup(false, group, list2, presentationFactory, context2, place, actionManager, false, group instanceof CompactActionGroup);
    }

    public static void expandActionGroup(boolean isInModalContext, @NotNull ActionGroup group, List<AnAction> list2, PresentationFactory presentationFactory, @NotNull DataContext context2, String place, ActionManager actionManager) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        Utils.expandActionGroup(isInModalContext, group, list2, presentationFactory, context2, place, actionManager, false, group instanceof CompactActionGroup);
    }

    @Deprecated
    public static void expandActionGroup(@NotNull ActionGroup group, List<AnAction> list2, PresentationFactory presentationFactory, DataContext context2, @NotNull String place, ActionManager actionManager, boolean transparentOnly) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        Utils.expandActionGroup(false, group, list2, presentationFactory, context2, place, actionManager, transparentOnly, false);
    }

    public static void expandActionGroup(boolean isInModalContext, @NotNull ActionGroup group, List<AnAction> list2, PresentationFactory presentationFactory, DataContext context2, @NotNull String place, ActionManager actionManager, boolean transparentOnly) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        Utils.expandActionGroup(isInModalContext, group, list2, presentationFactory, context2, place, actionManager, transparentOnly, false);
    }

    @Deprecated
    public static void expandActionGroup(@NotNull ActionGroup group, List<AnAction> list2, PresentationFactory presentationFactory, DataContext context2, @NotNull String place, ActionManager actionManager, boolean transparentOnly, boolean hideDisabled) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        Utils.expandActionGroup(false, group, list2, presentationFactory, context2, place, actionManager, transparentOnly, hideDisabled);
    }

    public static void expandActionGroup(boolean isInModalContext, @NotNull ActionGroup group, List<AnAction> list2, PresentationFactory presentationFactory, DataContext context2, @NotNull String place, ActionManager actionManager, boolean transparentOnly, boolean hideDisabled) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        Presentation presentation = presentationFactory.getPresentation((AnAction)group);
        AnActionEvent e2 = new AnActionEvent(null, context2, place, presentation, actionManager, 0);
        if (!Utils.doUpdate(isInModalContext, (AnAction)group, e2, presentation)) {
            return;
        }
        if (!presentation.isVisible()) {
            return;
        }
        AnAction[] children2 = group.getChildren(e2);
        boolean includeInvisibleActions = group instanceof IncludedInvisibleItemsActionGroup;
        for (int i2 = 0; i2 < children2.length; ++i2) {
            AnAction child = children2[i2];
            if (child == null) {
                String groupId = ActionManager.getInstance().getId((AnAction)group);
                LOG.error("action is null: i=" + i2 + " group=" + group + " group id=" + groupId);
                continue;
            }
            presentation = presentationFactory.getPresentation(child);
            AnActionEvent e1 = new AnActionEvent(null, context2, place, presentation, actionManager, 0);
            e1.setInjectedContext(child.isInInjectedContext());
            if ((transparentOnly && child.isTransparentUpdate() || !transparentOnly) && !Utils.doUpdate(isInModalContext, child, e1, presentation) || !includeInvisibleActions && !presentation.isVisible() || !presentation.isEnabled() && hideDisabled) continue;
            if (child instanceof ActionGroup) {
                boolean skip;
                ActionGroup actionGroup = (ActionGroup)child;
                boolean bl = skip = hideDisabled && !Utils.hasEnabledChildren(actionGroup, presentationFactory, context2, place);
                if (skip) continue;
                if (actionGroup.isPopup()) {
                    if (actionGroup.disableIfNoVisibleChildren()) {
                        boolean visibleChildren = Utils.hasVisibleChildren(actionGroup, presentationFactory, context2, place);
                        if (actionGroup.hideIfNoVisibleChildren() && !visibleChildren) continue;
                        presentation.setEnabled(actionGroup.canBePerformed(context2) || visibleChildren);
                    }
                    list2.add(child);
                    continue;
                }
                Utils.expandActionGroup(isInModalContext, (ActionGroup)child, list2, presentationFactory, context2, place, actionManager, false, hideDisabled);
                continue;
            }
            if (child instanceof Separator) {
                if (StringUtil.isEmpty((String)((Separator)child).getText()) && list2.stream().filter(it -> presentationFactory.getPresentation((AnAction)it).isVisible()).reduce((a, b2) -> b2).map(it -> it instanceof Separator).orElse(true).booleanValue()) continue;
                list2.add(child);
                continue;
            }
            if (hideDisabled && !Utils.hasEnabledChildren((ActionGroup)new DefaultActionGroup(new AnAction[]{child}), presentationFactory, context2, place)) continue;
            list2.add(child);
        }
    }

    @Deprecated
    private static boolean doUpdate(AnAction action2, AnActionEvent e2, Presentation presentation) {
        return Utils.doUpdate(false, action2, e2, presentation);
    }

    private static boolean doUpdate(boolean isInModalContext, AnAction action2, AnActionEvent e2, Presentation presentation) throws ProcessCanceledException {
        boolean result2;
        if (ApplicationManager.getApplication().isDisposed()) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        try {
            result2 = !ActionUtil.performDumbAwareUpdate((boolean)isInModalContext, (AnAction)action2, (AnActionEvent)e2, (boolean)false);
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Throwable exc) {
            Utils.handleUpdateException(action2, presentation, exc);
            return false;
        }
        long endTime = System.currentTimeMillis();
        if (endTime - startTime > 10L && LOG.isDebugEnabled()) {
            LOG.debug("Action " + action2 + ": updated in " + (endTime - startTime) + " ms");
        }
        return result2;
    }

    private static boolean hasVisibleChildren(ActionGroup group, PresentationFactory factory2, DataContext context2, String place) {
        return Utils.hasChildrenWithState(group, factory2, context2, place, true, false);
    }

    private static boolean hasEnabledChildren(ActionGroup group, PresentationFactory factory2, DataContext context2, String place) {
        return Utils.hasChildrenWithState(group, factory2, context2, place, false, true);
    }

    private static boolean hasChildrenWithState(ActionGroup group, PresentationFactory factory2, DataContext context2, String place, boolean checkVisible, boolean checkEnabled) {
        if (group instanceof AlwaysVisibleActionGroup) {
            return true;
        }
        AnActionEvent event = new AnActionEvent(null, context2, place, factory2.getPresentation((AnAction)group), ActionManager.getInstance(), 0);
        event.setInjectedContext(group.isInInjectedContext());
        for (AnAction anAction : group.getChildren(event)) {
            ActionGroup childGroup;
            Project project2;
            if (anAction == null) {
                LOG.error("Null action found in group " + group + ", " + factory2.getPresentation((AnAction)group));
                continue;
            }
            if (anAction instanceof Separator || (project2 = (Project)CommonDataKeys.PROJECT.getData(context2)) != null && DumbService.getInstance((Project)project2).isDumb() && !anAction.isDumbAware()) continue;
            Presentation presentation = factory2.getPresentation(anAction);
            Utils.updateGroupChild(context2, place, anAction, presentation);
            if (!(anAction instanceof ActionGroup ? !((childGroup = (ActionGroup)anAction).isPopup() && (checkVisible && !presentation.isVisible() || checkEnabled && !presentation.isEnabled()) || !Utils.hasChildrenWithState(childGroup, factory2, context2, place, checkVisible, checkEnabled)) : checkVisible && presentation.isVisible() || checkEnabled && presentation.isEnabled())) continue;
            return true;
        }
        return false;
    }

    public static void updateGroupChild(DataContext context2, String place, AnAction anAction, Presentation presentation) {
        AnActionEvent event1 = new AnActionEvent(null, context2, place, presentation, ActionManager.getInstance(), 0);
        event1.setInjectedContext(anAction.isInInjectedContext());
        Utils.doUpdate(false, anAction, event1, presentation);
    }

    @Deprecated
    public static void fillMenu(@NotNull ActionGroup group, JComponent component, boolean enableMnemonics, PresentationFactory presentationFactory, @NotNull DataContext context2, String place, boolean isWindowMenu, boolean mayDataContextBeInvalid) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "fillMenu"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/actionSystem/impl/Utils", "fillMenu"));
        }
        Utils.fillMenu(group, component, enableMnemonics, presentationFactory, context2, place, isWindowMenu, mayDataContextBeInvalid, false);
    }

    public static void fillMenu(@NotNull ActionGroup group, final JComponent component, boolean enableMnemonics, PresentationFactory presentationFactory, @NotNull DataContext context2, String place, boolean isWindowMenu, boolean mayDataContextBeInvalid, boolean isInModalContext) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "fillMenu"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/actionSystem/impl/Utils", "fillMenu"));
        }
        ActionCallback menuBuilt = new ActionCallback();
        boolean checked = group instanceof CheckedActionGroup;
        ArrayList<AnAction> list2 = new ArrayList<AnAction>();
        Utils.expandActionGroup(isInModalContext, group, list2, presentationFactory, context2, place, ActionManager.getInstance());
        boolean fixMacScreenMenu = SystemInfo.isMacSystemMenu && isWindowMenu && Registry.is((String)"actionSystem.mac.screenMenuNotUpdatedFix");
        ArrayList<Object> children2 = new ArrayList<Object>();
        int size = list2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            AnAction action2 = list2.get(i2);
            if (action2 instanceof Separator) {
                final String text2 = ((Separator)action2).getText();
                if (StringUtil.isEmpty((String)text2) && (i2 <= 0 || i2 >= size - 1)) continue;
                component.add(new JPopupMenu.Separator(){
                    private final JMenuItem myMenu;
                    {
                        this.myMenu = !StringUtil.isEmpty((String)text2) ? new JMenuItem(text2) : null;
                    }

                    @Override
                    public Insets getInsets() {
                        Insets insets = super.getInsets();
                        boolean fix = UIUtil.isUnderGTKLookAndFeel() && this.getBorder() != null && insets.top + insets.bottom == 0;
                        return fix ? new Insets(2, insets.left, 3, insets.right) : insets;
                    }

                    @Override
                    public void doLayout() {
                        super.doLayout();
                        if (this.myMenu != null) {
                            this.myMenu.setBounds(this.getBounds());
                        }
                    }

                    @Override
                    protected void paintComponent(Graphics g2) {
                        if (UIUtil.isUnderWindowsClassicLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderWindowsLookAndFeel() || SystemInfo.isWindows && Registry.is((String)"ide.intellij.laf.win10.ui")) {
                            g2.setColor(component.getBackground());
                            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                        }
                        if (this.myMenu != null) {
                            this.myMenu.paint(g2);
                        } else {
                            super.paintComponent(g2);
                        }
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        return this.myMenu != null ? this.myMenu.getPreferredSize() : super.getPreferredSize();
                    }
                });
                continue;
            }
            if (action2 instanceof ActionGroup && (!((ActionGroup)action2).canBePerformed(context2) || Utils.hasVisibleChildren((ActionGroup)action2, presentationFactory, context2, place))) {
                ActionMenu menu = new ActionMenu(context2, place, (ActionGroup)action2, presentationFactory, enableMnemonics, false);
                component.add((Component)((Object)menu));
                children2.add((Object)menu);
                continue;
            }
            ActionMenuItem each = new ActionMenuItem(action2, presentationFactory.getPresentation(action2), place, context2, enableMnemonics, !fixMacScreenMenu, checked);
            component.add((Component)((Object)each));
            children2.add((Object)each);
        }
        if (list2.isEmpty()) {
            ActionMenuItem each = new ActionMenuItem(EMPTY_MENU_FILLER, presentationFactory.getPresentation(EMPTY_MENU_FILLER), place, context2, enableMnemonics, !fixMacScreenMenu, checked);
            component.add((Component)((Object)each));
            children2.add((Object)each);
        }
        if (fixMacScreenMenu) {
            SwingUtilities.invokeLater(() -> {
                for (Component each : children2) {
                    if (each.getParent() == null || !(each instanceof ActionMenuItem)) continue;
                    ((ActionMenuItem)((Object)((Object)each))).prepare();
                }
                menuBuilt.setDone();
            });
        } else {
            menuBuilt.setDone();
        }
        menuBuilt.doWhenDone(() -> {
            if (group == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "lambda$fillMenu$5"));
            }
            if (!mayDataContextBeInvalid) {
                return;
            }
            if (IdeFocusManager.getInstance(null).isFocusBeingTransferred()) {
                IdeFocusManager.getInstance(null).doWhenFocusSettlesDown(() -> {
                    if (group == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "lambda$null$4"));
                    }
                    if (!component.isShowing()) {
                        return;
                    }
                    DataContext context1 = DataManager.getInstance().getDataContext();
                    Utils.expandActionGroup(LaterInvocator.isInModalContext(), group, new ArrayList<AnAction>(), presentationFactory, context1, place, ActionManager.getInstance());
                    for (Component each : children2) {
                        if (each instanceof ActionMenuItem) {
                            ((ActionMenuItem)((Object)((Object)((Object)each)))).updateContext(context1);
                            continue;
                        }
                        if (!(each instanceof ActionMenu)) continue;
                        ((ActionMenu)((Object)((Object)((Object)each)))).updateContext(context1);
                    }
                });
            }
        });
    }
}

