/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.Main;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ConfigImportSettings;
import com.intellij.openapi.application.ImportOldConfigsPanel;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Function;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import java.awt.Dialog;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PropertyResourceBundle;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigImportHelper {
    private static final String FIRST_SESSION_KEY = "intellij.first.ide.session";
    private static final String CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY = "intellij.config.imported.in.current.session";
    private static final String BUILD_NUMBER_FILE = SystemInfo.isMac ? "/Resources/build.txt" : "build.txt";
    private static final String PLUGINS_PATH = "plugins";
    private static final String BIN_FOLDER = "bin";
    private static final String CONFIG_RELATED_PATH = SystemInfo.isMac ? "" : "config/";
    private static final String OPTIONS_XML = "options/options.xml";

    private ConfigImportHelper() {
    }

    public static void importConfigsTo(@NotNull String newConfigPath) {
        block6: {
            ImportOldConfigsPanel dialog2;
            File installationHome;
            if (newConfigPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newConfigPath", "com/intellij/openapi/application/ConfigImportHelper", "importConfigsTo"));
            }
            System.setProperty(FIRST_SESSION_KEY, Boolean.TRUE.toString());
            ConfigImportSettings settings = ConfigImportHelper.getConfigImportSettings();
            File newConfigDir = new File(newConfigPath);
            File oldConfigDir = ConfigImportHelper.findOldConfigDir(newConfigDir, settings.getCustomPathsSelector());
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            do {
                dialog2 = new ImportOldConfigsPanel(oldConfigDir, settings);
                dialog2.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
                AppUIUtil.updateWindowIcon(dialog2);
                dialog2.setVisible(true);
                if (!dialog2.isImportEnabled()) break block6;
            } while (!ConfigImportHelper.validateOldConfigDir(installationHome = dialog2.getSelectedFile(), oldConfigDir = ConfigImportHelper.getOldConfigDir(installationHome, settings), settings));
            assert (oldConfigDir != null);
            ConfigImportHelper.doImport(newConfigDir, oldConfigDir, settings, installationHome);
            settings.importFinished(newConfigPath);
            System.setProperty(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY, Boolean.TRUE.toString());
            CloudConfigProvider provider = CloudConfigProvider.getProvider();
            if (provider != null) {
                provider.importFinished(newConfigDir);
            }
        }
    }

    public static boolean isFirstSession() {
        return Boolean.getBoolean(FIRST_SESSION_KEY);
    }

    public static boolean isConfigImported() {
        return Boolean.getBoolean(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY);
    }

    @NotNull
    private static ConfigImportSettings getConfigImportSettings() {
        block4: {
            ConfigImportSettings configImportSettings;
            try {
                Class<?> customProviderClass = Class.forName("com.intellij.openapi.application." + PlatformUtils.getPlatformPrefix() + "ConfigImportSettings");
                if (!ConfigImportSettings.class.isAssignableFrom(customProviderClass)) break block4;
                configImportSettings = (ConfigImportSettings)ReflectionUtil.newInstance(customProviderClass);
            }
            catch (ClassNotFoundException | RuntimeException exception) {
                // empty catch block
            }
            if (configImportSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/ConfigImportHelper", "getConfigImportSettings"));
            }
            return configImportSettings;
        }
        ConfigImportSettings configImportSettings = new ConfigImportSettings();
        if (configImportSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/ConfigImportHelper", "getConfigImportSettings"));
        }
        return configImportSettings;
    }

    @Nullable
    private static File findOldConfigDir(@NotNull File configDir, @Nullable String customPathSelector) {
        if (configDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configDir", "com/intellij/openapi/application/ConfigImportHelper", "findOldConfigDir"));
        }
        File selectorDir = CONFIG_RELATED_PATH.isEmpty() ? configDir : configDir.getParentFile();
        File parent = selectorDir.getParentFile();
        if (parent == null || !parent.exists()) {
            return null;
        }
        File maxFile = null;
        long lastModified = 0L;
        String selector = PathManager.getPathsSelector() != null ? PathManager.getPathsSelector() : selectorDir.getName();
        String prefix = ConfigImportHelper.getPrefixFromSelector(selector);
        String customPrefix = customPathSelector != null ? ConfigImportHelper.getPrefixFromSelector(customPathSelector) : null;
        for (File file2 : parent.listFiles((file1, name) -> StringUtil.startsWithIgnoreCase((String)name, (String)prefix) || customPrefix != null && StringUtil.startsWithIgnoreCase((String)name, (String)customPrefix))) {
            long modified;
            File options = new File(file2, CONFIG_RELATED_PATH + OPTIONS_XML);
            if (!options.exists() || (modified = options.lastModified()) <= lastModified) continue;
            lastModified = modified;
            maxFile = file2;
        }
        return maxFile != null ? new File(maxFile, CONFIG_RELATED_PATH) : null;
    }

    private static String getPrefixFromSelector(String selector) {
        return (SystemInfo.isMac ? "" : ".") + selector.replaceAll("\\d(\\.\\d)?", "");
    }

    private static void doImport(@NotNull File newConfigDir, @NotNull File oldConfigDir, ConfigImportSettings settings, File installationHome) {
        if (newConfigDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newConfigDir", "com/intellij/openapi/application/ConfigImportHelper", "doImport"));
        }
        if (oldConfigDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldConfigDir", "com/intellij/openapi/application/ConfigImportHelper", "doImport"));
        }
        try {
            ConfigImportHelper.copy(oldConfigDir, newConfigDir, settings, installationHome);
        }
        catch (IOException e2) {
            String message2 = ApplicationBundle.message((String)"error.unable.to.import.settings", (Object[])new Object[]{e2.getMessage()});
            Main.showMessage((String)ApplicationBundle.message((String)"title.settings.import.failed", (Object[])new Object[0]), (String)message2, (boolean)false);
        }
    }

    private static boolean validateOldConfigDir(@Nullable File installationHome, @Nullable File oldConfigDir, @NotNull ConfigImportSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/application/ConfigImportHelper", "validateOldConfigDir"));
        }
        if (oldConfigDir == null) {
            if (installationHome != null) {
                String message2 = ApplicationBundle.message((String)"error.invalid.installation.home", (Object[])new Object[]{installationHome.getAbsolutePath(), settings.getProductName(ThreeState.YES)});
                Main.showMessage((String)ApplicationBundle.message((String)"title.settings.import.failed", (Object[])new Object[0]), (String)message2, (boolean)false);
            }
            return false;
        }
        if (!oldConfigDir.exists()) {
            String message3 = ApplicationBundle.message((String)"error.no.settings.path", (Object[])new Object[]{oldConfigDir.getAbsolutePath()});
            Main.showMessage((String)ApplicationBundle.message((String)"title.settings.import.failed", (Object[])new Object[0]), (String)message3, (boolean)false);
            return false;
        }
        return true;
    }

    private static void copy(@NotNull File src, @NotNull File dest, ConfigImportSettings settings, File oldInstallationHome) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/openapi/application/ConfigImportHelper", "copy"));
        }
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/intellij/openapi/application/ConfigImportHelper", "copy"));
        }
        src = src.getCanonicalFile();
        dest = dest.getCanonicalFile();
        if (!src.isDirectory()) {
            throw new IOException(ApplicationBundle.message((String)"config.import.invalid.directory.error", (Object[])new Object[]{src.getAbsolutePath()}));
        }
        if (!dest.isDirectory()) {
            throw new IOException(ApplicationBundle.message((String)"config.import.invalid.directory.error", (Object[])new Object[]{dest.getAbsolutePath()}));
        }
        if (FileUtil.filesEqual((File)src, (File)dest)) {
            return;
        }
        FileUtil.ensureExists((File)dest);
        FileUtil.copyDir((File)src, (File)dest);
        FileUtil.delete((File)new File(dest, "user.token"));
        FileUtil.delete((File)new File(dest, "user.web.token"));
        File oldPluginsDir = new File(src, PLUGINS_PATH);
        if (!oldPluginsDir.isDirectory() && SystemInfo.isMac) {
            oldPluginsDir = ConfigImportHelper.getSettingsPath(oldInstallationHome, settings, "idea.plugins.path", (Function<String, String>)((Function)pathSelector -> PathManager.getDefaultPluginPathFor((String)pathSelector)));
            if (oldPluginsDir == null) {
                oldPluginsDir = new File(PathManager.getDefaultPluginPathFor((String)src.getName()));
            }
            File newPluginsDir = new File(PathManager.getPluginsPath());
            FileUtil.copyDir((File)oldPluginsDir, (File)newPluginsDir);
        }
        ConfigImportHelper.loadOldPlugins(oldPluginsDir, dest);
    }

    private static boolean loadOldPlugins(File plugins2, File dest) throws IOException {
        if (plugins2.exists()) {
            SmartList descriptors = new SmartList();
            PluginManagerCore.loadDescriptors(plugins2, (List<IdeaPluginDescriptorImpl>)descriptors, null, 0);
            SmartList oldPlugins = new SmartList();
            for (IdeaPluginDescriptorImpl descriptor2 : descriptors) {
                if (!descriptor2.isEnabled() || descriptor2.isBundled()) continue;
                oldPlugins.add(descriptor2.getPluginId().getIdString());
            }
            if (!oldPlugins.isEmpty()) {
                PluginManagerCore.savePluginsList((Collection<String>)oldPlugins, false, new File(dest, "installed.txt"));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static File getOldConfigDir(@Nullable File oldInstallHome, ConfigImportSettings settings) {
        if (oldInstallHome == null) {
            return null;
        }
        if (new File(oldInstallHome, OPTIONS_XML).exists()) {
            return oldInstallHome;
        }
        if (new File(oldInstallHome, CONFIG_RELATED_PATH + OPTIONS_XML).exists()) {
            return new File(oldInstallHome, CONFIG_RELATED_PATH);
        }
        int oldBuildNumber = ConfigImportHelper.getBuildNumber(oldInstallHome);
        if (oldBuildNumber != -1 && oldBuildNumber <= 600) {
            return new File(oldInstallHome, "config");
        }
        return ConfigImportHelper.getSettingsPath(oldInstallHome, settings, "idea.config.path", (Function<String, String>)((Function)pathsSelector -> PathManager.getDefaultConfigPathFor((String)pathsSelector)));
    }

    private static File getSettingsPath(File installHome, ConfigImportSettings settings, String propertyName, Function<String, String> fromPathSelector) {
        List<File> launchFileCandidates = ConfigImportHelper.getLaunchFilesCandidates(installHome, settings);
        for (File candidate : launchFileCandidates) {
            File probableConfig;
            String configDir;
            if (!candidate.exists() || (configDir = PathManager.substituteVars((String)ConfigImportHelper.getPropertyFromLaxFile(candidate, propertyName), (String)installHome.getPath())) == null || !(probableConfig = new File(configDir)).exists()) continue;
            return probableConfig;
        }
        for (File candidate : launchFileCandidates) {
            File candidateDir;
            String pathsSelector;
            if (!candidate.exists() || (pathsSelector = ConfigImportHelper.getPropertyFromLaxFile(candidate, "idea.paths.selector")) == null || !(candidateDir = new File((String)fromPathSelector.fun((Object)pathsSelector))).exists()) continue;
            return candidateDir;
        }
        return null;
    }

    private static List<File> getLaunchFilesCandidates(@NotNull File instHome, @NotNull ConfigImportSettings settings) {
        if (instHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instHome", "com/intellij/openapi/application/ConfigImportHelper", "getLaunchFilesCandidates"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/application/ConfigImportHelper", "getLaunchFilesCandidates"));
        }
        File bin = new File(instHome, BIN_FOLDER);
        ArrayList<File> files2 = new ArrayList<File>();
        if (SystemInfo.isMac) {
            files2.add(new File(new File(instHome, "Contents"), "Info.plist"));
            files2.add(new File(new File(new File(bin, "idea.app"), "Contents"), "Info.plist"));
            files2.add(new File(new File(new File(instHome, "idea.app"), "Contents"), "Info.plist"));
        }
        files2.add(new File(bin, "idea.properties"));
        String executableName = StringUtil.toLowerCase((String)settings.getExecutableName());
        ConfigImportHelper.addLaunchExecutableScriptsCandidates(files2, executableName, bin);
        files2.addAll(settings.getCustomLaunchFilesCandidates(instHome, bin));
        if (!"idea".equals(executableName)) {
            ConfigImportHelper.addLaunchExecutableScriptsCandidates(files2, "idea", bin);
        }
        return files2;
    }

    private static void addLaunchExecutableScriptsCandidates(List<File> files2, String executableName, File binFolder) {
        files2.add(new File(binFolder, executableName + ".lax"));
        files2.add(new File(binFolder, executableName + ".bat"));
        files2.add(new File(binFolder, executableName + ".sh"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getPropertyFromLaxFile(@NotNull File file2, @NotNull String propertyName) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/application/ConfigImportHelper", "getPropertyFromLaxFile"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/openapi/application/ConfigImportHelper", "getPropertyFromLaxFile"));
        }
        if (file2.getName().endsWith(".properties")) {
            try {
                PropertyResourceBundle bundle;
                try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file2));){
                    bundle = new PropertyResourceBundle(fis);
                }
                if (bundle.containsKey(propertyName)) {
                    return bundle.getString(propertyName);
                }
                return null;
            }
            catch (IOException e2) {
                return null;
            }
        }
        String fileContent = ConfigImportHelper.getContent(file2);
        String propertyValue = ConfigImportHelper.findProperty(propertyName, fileContent);
        if (!StringUtil.isEmpty((String)propertyValue)) {
            return propertyValue;
        }
        return null;
    }

    @Nullable
    private static String findProperty(String propertyName, String fileContent) {
        String param = propertyName + "=";
        int idx = fileContent.indexOf(param);
        if (idx == -1) {
            param = "<key>" + propertyName + "</key>";
            idx = fileContent.indexOf(param);
            if (idx == -1) {
                return null;
            }
            if ((idx = fileContent.indexOf("<string>", idx)) == -1) {
                return null;
            }
            return ConfigImportHelper.fixDirName(fileContent.substring(idx += "<string>".length(), fileContent.indexOf("</string>", idx)), true);
        }
        String configDir = "";
        if (fileContent.length() > (idx += param.length())) {
            if (fileContent.charAt(idx) == '\"') {
                ++idx;
                while (fileContent.length() > idx && fileContent.charAt(idx) != '\"' && fileContent.charAt(idx) != '\n' && fileContent.charAt(idx) != '\r') {
                    configDir = configDir + fileContent.charAt(idx);
                    ++idx;
                }
            } else {
                while (fileContent.length() > idx && !Character.isSpaceChar(fileContent.charAt(idx)) && fileContent.charAt(idx) != '\n' && fileContent.charAt(idx) != '\r') {
                    configDir = configDir + fileContent.charAt(idx);
                    ++idx;
                }
            }
        }
        if ((configDir = ConfigImportHelper.fixDirName(configDir, true)).length() > 0) {
            configDir = new File(configDir).getPath();
        }
        return configDir;
    }

    @Nullable
    private static String getContent(File file2) {
        try {
            return FileUtil.loadFile((File)file2);
        }
        catch (IOException e2) {
            return null;
        }
    }

    private static String fixDirName(String dir, boolean replaceUserHome) {
        if (StringUtil.startsWithChar((CharSequence)dir, (char)'\"') && StringUtil.endsWithChar((CharSequence)dir, (char)'\"')) {
            dir = dir.substring(1, dir.length() - 1);
        }
        if (replaceUserHome) {
            dir = FileUtil.expandUserHome((String)dir);
        }
        return dir;
    }

    public static boolean isInstallationHomeOrConfig(@NotNull String installationHome, @NotNull ConfigImportSettings settings) {
        String[] mainJarNames;
        if (installationHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installationHome", "com/intellij/openapi/application/ConfigImportHelper", "isInstallationHomeOrConfig"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/application/ConfigImportHelper", "isInstallationHomeOrConfig"));
        }
        if (new File(installationHome, OPTIONS_XML).exists()) {
            return true;
        }
        if (new File(installationHome, CONFIG_RELATED_PATH + OPTIONS_XML).exists()) {
            return true;
        }
        if (!new File(installationHome, BIN_FOLDER).exists()) {
            return false;
        }
        File libFolder = new File(installationHome, "lib");
        boolean quickTest = false;
        for (String name : mainJarNames = settings.getMainJarNames()) {
            String mainJarName = StringUtil.toLowerCase((String)name) + ".jar";
            if (!new File(libFolder, mainJarName).exists()) continue;
            quickTest = true;
            break;
        }
        if (!quickTest) {
            return false;
        }
        List<File> files2 = ConfigImportHelper.getLaunchFilesCandidates(new File(installationHome), settings);
        for (File file2 : files2) {
            if (!file2.exists()) continue;
            return true;
        }
        return false;
    }

    private static int getBuildNumber(File installDirectory) {
        File buildTxt = new File(installDirectory = installDirectory.getAbsoluteFile(), BUILD_NUMBER_FILE);
        if (!buildTxt.exists() || buildTxt.isDirectory()) {
            buildTxt = new File(new File(installDirectory, BIN_FOLDER), BUILD_NUMBER_FILE);
        }
        if (buildTxt.exists() && !buildTxt.isDirectory()) {
            int buildNumber = -1;
            String buildNumberText = ConfigImportHelper.getContent(buildTxt);
            if (buildNumberText != null) {
                try {
                    if (buildNumberText.length() > 1) {
                        buildNumberText = buildNumberText.trim();
                        buildNumber = Integer.parseInt(buildNumberText);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return buildNumber;
        }
        return -1;
    }
}

