/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBProtocolCommand {
    public static final ExtensionPointName<JBProtocolCommand> EP_NAME = new ExtensionPointName("com.intellij.jbProtocolCommand");
    private final String myCommand;

    public JBProtocolCommand(@NotNull String command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/application/JBProtocolCommand", "<init>"));
        }
        this.myCommand = command;
    }

    @NotNull
    public final String getCommandName() {
        String string2 = this.myCommand;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/JBProtocolCommand", "getCommandName"));
        }
        return string2;
    }

    public abstract void perform(String var1, Map<String, String> var2);

    @Nullable
    public static JBProtocolCommand findCommand(@Nullable String commandName) {
        if (commandName != null) {
            for (JBProtocolCommand command : (JBProtocolCommand[])EP_NAME.getExtensions()) {
                if (!command.getCommandName().equals(commandName)) continue;
                return command;
            }
        }
        return null;
    }

    public static void handleCurrentCommand() {
        JBProtocolCommand command = JBProtocolCommand.findCommand(JetBrainsProtocolHandler.getCommand());
        if (command != null) {
            try {
                command.perform(JetBrainsProtocolHandler.getMainParameter(), JetBrainsProtocolHandler.getParameters());
            }
            finally {
                JetBrainsProtocolHandler.clear();
            }
        }
    }
}

