/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApplicationUtil {
    public static <T> T tryRunReadAction(@NotNull Computable<T> computable) throws CannotRunReadActionException {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/openapi/application/ex/ApplicationUtil", "tryRunReadAction"));
        }
        Ref result2 = new Ref();
        ApplicationUtil.tryRunReadAction(() -> {
            if (computable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/openapi/application/ex/ApplicationUtil", "lambda$tryRunReadAction$0"));
            }
            result2.set(computable.compute());
        });
        return (T)result2.get();
    }

    public static void tryRunReadAction(@NotNull Runnable computable) throws CannotRunReadActionException {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/openapi/application/ex/ApplicationUtil", "tryRunReadAction"));
        }
        if (!((ApplicationEx)ApplicationManager.getApplication()).tryRunReadAction(computable)) {
            throw new CannotRunReadActionException();
        }
    }

    public static <T> T runWithCheckCanceled(@NotNull Callable<T> callable, @NotNull ProgressIndicator indicator) throws Exception {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/intellij/openapi/application/ex/ApplicationUtil", "runWithCheckCanceled"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/application/ex/ApplicationUtil", "runWithCheckCanceled"));
        }
        Ref result2 = Ref.create();
        Ref error = Ref.create();
        Future<?> future2 = PooledThreadExecutor.INSTANCE.submit(() -> {
            if (callable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/intellij/openapi/application/ex/ApplicationUtil", "lambda$runWithCheckCanceled$2"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/application/ex/ApplicationUtil", "lambda$runWithCheckCanceled$2"));
            }
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                if (callable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/intellij/openapi/application/ex/ApplicationUtil", "lambda$null$1"));
                }
                try {
                    result2.set(callable.call());
                }
                catch (Throwable t2) {
                    error.set((Object)t2);
                }
            }, indicator);
        });
        while (true) {
            try {
                indicator.checkCanceled();
            }
            catch (ProcessCanceledException e2) {
                future2.cancel(true);
                throw e2;
            }
            try {
                future2.get(200L, TimeUnit.MILLISECONDS);
                ExceptionUtil.rethrowAll((Throwable)((Throwable)error.get()));
                return (T)result2.get();
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    public static class CannotRunReadActionException
    extends ProcessCanceledException {
    }
}

