/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.SystemInfo;
import java.awt.datatransfer.DataFlavor;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class ClipboardUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.Clipboard");
    private static final String USE_LEGACY_MERGE_SORT_PROPERTY_NAME = "java.util.Arrays.useLegacyMergeSort";

    public static <E> E handleClipboardSafely(Supplier<E> supplier, Supplier<E> onFail) {
        try {
            return ClipboardUtil.useLegacyMergeSort(supplier);
        }
        catch (IllegalStateException e2) {
            if (SystemInfo.isWindows) {
                LOG.debug("Clipboard is busy");
            } else {
                LOG.warn((Throwable)e2);
            }
            return onFail.get();
        }
    }

    public static <T> T useLegacyMergeSort(Supplier<T> supplier) {
        String originalValue = System.getProperty(USE_LEGACY_MERGE_SORT_PROPERTY_NAME);
        System.setProperty(USE_LEGACY_MERGE_SORT_PROPERTY_NAME, "true");
        try {
            T t2 = supplier.get();
            return t2;
        }
        finally {
            if (originalValue != null) {
                System.setProperty(USE_LEGACY_MERGE_SORT_PROPERTY_NAME, originalValue);
            }
        }
    }

    @Nullable
    public static String getTextInClipboard() {
        return (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
    }
}

