/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import gnu.trove.THashMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecodeDefaultsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.ex.DecodeDefaultsUtil");
    private static final Map<String, URL> RESOURCE_CACHE = Collections.synchronizedMap(new THashMap());

    public static URL getDefaults(Object requestor, @NotNull String componentResourcePath) {
        if (componentResourcePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentResourcePath", "com/intellij/openapi/application/ex/DecodeDefaultsUtil", "getDefaults"));
        }
        URL url = RESOURCE_CACHE.get(componentResourcePath);
        if (url == null) {
            Class<?> requestorClass = requestor.getClass();
            if (StringUtil.startsWithChar((CharSequence)componentResourcePath, (char)'/')) {
                url = requestorClass.getResource(componentResourcePath + ".xml");
            } else {
                url = requestorClass.getResource('/' + ApplicationManagerEx.getApplicationEx().getName() + '/' + componentResourcePath + ".xml");
                if (url == null) {
                    url = requestorClass.getResource('/' + componentResourcePath + ".xml");
                }
            }
            RESOURCE_CACHE.put(componentResourcePath, url);
        }
        return url;
    }

    @Nullable
    public static InputStream getDefaultsInputStream(Object requestor, @NotNull String componentResourcePath) {
        if (componentResourcePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentResourcePath", "com/intellij/openapi/application/ex/DecodeDefaultsUtil", "getDefaultsInputStream"));
        }
        try {
            URL defaults = DecodeDefaultsUtil.getDefaults(requestor, componentResourcePath);
            return defaults == null ? null : URLUtil.openStream((URL)defaults);
        }
        catch (IOException e2) {
            LOG.error((Throwable)e2);
            return null;
        }
    }
}

