/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.BundleBase;
import com.intellij.CommonBundle;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.concurrency.JobScheduler;
import com.intellij.diagnostic.LogEventException;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ApplicationActivationStateManager;
import com.intellij.ide.ApplicationLoadListener;
import com.intellij.ide.CommandLineProcessor;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.WindowsCommandLineProcessor;
import com.intellij.idea.IdeaApplication;
import com.intellij.idea.Main;
import com.intellij.idea.StartupUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityInvokator;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.application.impl.AWTExceptionHandler;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityInvokatorImpl;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.application.impl.NoSwingUnderWriteAction;
import com.intellij.openapi.application.impl.ReadMostlyRWLock;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.PlatformComponentManagerImpl;
import com.intellij.openapi.components.impl.ServiceManagerImpl;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaPicoContainer;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.ui.DialogEarthquakeShaker;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiLock;
import com.intellij.ui.AppIcon;
import com.intellij.ui.Splash;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PausesStat;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.Restarter;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.Stack;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.picocontainer.MutablePicoContainer;
import sun.awt.AWTAccessor;

public class ApplicationImpl
extends PlatformComponentManagerImpl
implements ApplicationEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.impl.ApplicationImpl");
    final ReadMostlyRWLock myLock;
    private final ModalityInvokator myInvokator;
    private final EventDispatcher<ApplicationListener> myDispatcher;
    private final boolean myTestModeFlag;
    private final boolean myHeadlessMode;
    private final boolean myCommandLineMode;
    private final boolean myIsInternal;
    private final String myName;
    private final Stack<Class> myWriteActionsStack;
    private final TransactionGuardImpl myTransactionGuard;
    private int myWriteStackBase;
    private volatile Thread myWriteActionThread;
    private int myInEditorPaintCounter;
    private final long myStartTime;
    @Nullable
    private Splash mySplash;
    private boolean myDoNotSave;
    private volatile boolean myExitInProgress;
    private volatile boolean myDisposeInProgress;
    private final Disposable myLastDisposable;
    private final AtomicBoolean mySaveSettingsIsInProgress;
    private static final int ourDumpThreadsOnLongWriteActionWaiting = Integer.getInteger("dump.threads.on.long.write.action.waiting", 0);
    private final ExecutorService ourThreadExecutorsService;
    private boolean myLoaded;
    private static final String WAS_EVER_SHOWN = "was.ever.shown";
    private static final ModalityState ANY = new ModalityState(){

        public boolean dominates(@NotNull ModalityState anotherState) {
            if (anotherState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anotherState", "com/intellij/openapi/application/impl/ApplicationImpl$1", "dominates"));
            }
            return false;
        }

        public String toString() {
            return "ANY";
        }
    };
    private volatile boolean myWriteActionPending;
    private final boolean gatherStatistics;
    private final boolean myExtraChecks;

    public ApplicationImpl(boolean isInternal, boolean isUnitTestMode, boolean isHeadless, boolean isCommandLine, @NotNull String appName, @Nullable Splash splash) {
        if (appName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appName", "com/intellij/openapi/application/impl/ApplicationImpl", "<init>"));
        }
        super(null);
        this.myInvokator = new ModalityInvokatorImpl();
        this.myDispatcher = EventDispatcher.create(ApplicationListener.class);
        this.myWriteActionsStack = new Stack();
        this.myTransactionGuard = new TransactionGuardImpl();
        this.myLastDisposable = Disposer.newDisposable();
        this.mySaveSettingsIsInProgress = new AtomicBoolean(false);
        this.ourThreadExecutorsService = PooledThreadExecutor.INSTANCE;
        this.myExtraChecks = this.isUnitTestMode();
        ApplicationManager.setApplication((Application)this, (Disposable)this.myLastDisposable);
        this.getPicoContainer().registerComponentInstance(Application.class, (Object)this);
        this.getPicoContainer().registerComponentInstance((Object)TransactionGuard.class.getName(), (Object)this.myTransactionGuard);
        IconLoader.STRICT = isUnitTestMode || isInternal;
        BundleBase.assertKeyIsFound = IconLoader.STRICT;
        AWTExceptionHandler.register();
        Disposer.setDebugMode((isInternal || isUnitTestMode || Disposer.isDebugDisposerOn() ? 1 : 0) != 0);
        this.myStartTime = System.currentTimeMillis();
        this.mySplash = splash;
        this.myName = appName;
        this.myIsInternal = isInternal;
        this.myTestModeFlag = isUnitTestMode;
        this.myHeadlessMode = isHeadless;
        this.myCommandLineMode = isCommandLine;
        this.myDoNotSave = isUnitTestMode || isHeadless;
        CommandLineUtil.VERBOSE_COMMAND_LINE_MODE = isUnitTestMode;
        if (!isUnitTestMode && !isHeadless) {
            Disposer.register((Disposable)this, (Disposable)Disposer.newDisposable(), (String)"ui");
            StartupUtil.addExternalInstanceListener((Consumer<List<String>>)((Consumer)args -> this.invokeLater(() -> {
                JFrame frame;
                LOG.info("ApplicationImpl.externalInstanceListener invocation");
                String currentDirectory = args.isEmpty() ? null : (String)args.get(0);
                List<String> realArgs = args.isEmpty() ? args : args.subList(1, args.size());
                Project project2 = CommandLineProcessor.processExternalCommandLine(realArgs, currentDirectory);
                JFrame jFrame = frame = project2 == null ? WindowManager.getInstance().findVisibleFrame() : (JFrame)WindowManager.getInstance().getIdeFrame(project2);
                if (frame != null) {
                    if (frame instanceof IdeFrame) {
                        AppIcon.getInstance().requestFocus((IdeFrame)frame);
                    } else {
                        frame.toFront();
                        DialogEarthquakeShaker.shake((Window)frame);
                    }
                }
            })));
            WindowsCommandLineProcessor.LISTENER = (currentDirectory, commandLine) -> {
                LOG.info("Received external Windows command line: current directory " + currentDirectory + ", command line " + commandLine);
                this.invokeLater(() -> {
                    List args = StringUtil.splitHonorQuotes((String)commandLine, (char)' ');
                    args.remove(0);
                    CommandLineProcessor.processExternalCommandLine(args, currentDirectory);
                });
            };
        }
        if (isUnitTestMode && IdeaApplication.getInstance() == null) {
            String[] args2 = new String[]{"inspect", "", "", ""};
            Main.setFlags((String[])args2);
            System.setProperty("idea.is.unit.test", Boolean.TRUE.toString());
            assert (Main.isHeadless());
            assert (Main.isCommandLine());
            new IdeaApplication(args2);
        }
        this.gatherStatistics = LOG.isDebugEnabled() || this.isUnitTestMode() || this.isInternal();
        Thread edt = (Thread)UIUtil.invokeAndWaitIfNeeded(() -> {
            AppExecutorUtil.getAppScheduledExecutorService();
            return Thread.currentThread();
        });
        this.myLock = new ReadMostlyRWLock(edt);
        NoSwingUnderWriteAction.watchForEvents(this);
    }

    public void executeByImpatientReader(@NotNull Runnable runnable2) throws ApplicationUtil.CannotRunReadActionException {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "executeByImpatientReader"));
        }
        if (this.isDispatchThread()) {
            runnable2.run();
        } else {
            this.myLock.executeByImpatientReader(runnable2);
        }
    }

    private boolean disposeSelf(boolean checkCanCloseProject) {
        ProjectManagerImpl manager = (ProjectManagerImpl)ProjectManagerEx.getInstanceEx();
        if (manager != null) {
            boolean[] canClose = new boolean[]{true};
            for (Project project2 : manager.getOpenProjects()) {
                try {
                    CommandProcessor.getInstance().executeCommand(project2, () -> {
                        if (!manager.closeProject(project2, true, true, checkCanCloseProject)) {
                            canClose[0] = false;
                        }
                    }, ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]), null);
                }
                catch (Throwable e2) {
                    LOG.error(e2);
                }
                if (canClose[0]) continue;
                return false;
            }
        }
        this.runWriteAction(() -> Disposer.dispose((Disposable)this));
        Disposer.assertIsEmpty();
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getName"));
        }
        return string2;
    }

    @Override
    public boolean holdsReadLock() {
        return this.myLock.isReadLockedByThisThread();
    }

    @Override
    @NotNull
    protected MutablePicoContainer createPicoContainer() {
        AreaPicoContainer areaPicoContainer = Extensions.getRootArea().getPicoContainer();
        if (areaPicoContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "createPicoContainer"));
        }
        return areaPicoContainer;
    }

    public boolean isInternal() {
        return this.myIsInternal;
    }

    public boolean isEAP() {
        return ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    public boolean isUnitTestMode() {
        return this.myTestModeFlag;
    }

    public boolean isHeadlessEnvironment() {
        return this.myHeadlessMode;
    }

    public boolean isCommandLine() {
        return this.myCommandLineMode;
    }

    public static boolean isRunningFromSources() {
        return Holder.ourIsRunningFromSources;
    }

    @NotNull
    public Future<?> executeOnPooledThread(final @NotNull Runnable action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "executeOnPooledThread"));
        }
        final ReadMostlyRWLock.SuspensionId suspensionId = this.myLock.currentReadPrivilege();
        Future<?> future2 = this.ourThreadExecutorsService.submit(new Runnable(){

            public String toString() {
                return action2.toString();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (AccessToken ignored2 = ApplicationImpl.this.myLock.applyReadPrivilege(suspensionId);){
                    action2.run();
                }
                catch (ProcessCanceledException ignored2) {
                }
                catch (Throwable t2) {
                    LOG.error(t2);
                }
                finally {
                    Thread.interrupted();
                }
            }
        });
        if (future2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "executeOnPooledThread"));
        }
        return future2;
    }

    @NotNull
    public <T> Future<T> executeOnPooledThread(final @NotNull Callable<T> action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "executeOnPooledThread"));
        }
        final ReadMostlyRWLock.SuspensionId suspensionId = this.myLock.currentReadPrivilege();
        Future future2 = this.ourThreadExecutorsService.submit(new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public T call() {
                Object v2;
                Throwable throwable;
                AccessToken ignored2222;
                block19: {
                    block20: {
                        ignored2222 = ApplicationImpl.this.myLock.applyReadPrivilege(suspensionId);
                        throwable = null;
                        v2 = action2.call();
                        if (ignored2222 == null) break block19;
                        if (throwable == null) break block20;
                        try {
                            ignored2222.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block19;
                    }
                    ignored2222.close();
                }
                Thread.interrupted();
                return v2;
                {
                    catch (Throwable throwable3) {
                        try {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (ignored2222 != null) {
                                    if (throwable != null) {
                                        try {
                                            ignored2222.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        ignored2222.close();
                                    }
                                }
                                throw throwable4;
                            }
                        }
                        catch (ProcessCanceledException ignored2222) {
                            Thread.interrupted();
                        }
                        catch (Throwable t2) {
                            try {
                                LOG.error(t2);
                            }
                            catch (Throwable throwable6) {
                                throw throwable6;
                            }
                            finally {
                                Thread.interrupted();
                            }
                        }
                    }
                }
                return null;
            }

            public String toString() {
                return action2.toString();
            }
        });
        if (future2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "executeOnPooledThread"));
        }
        return future2;
    }

    public boolean isDispatchThread() {
        return this.myLock.isWriteThread();
    }

    @NotNull
    public ModalityInvokator getInvokator() {
        ModalityInvokator modalityInvokator = this.myInvokator;
        if (modalityInvokator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getInvokator"));
        }
        return modalityInvokator;
    }

    public void invokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        this.invokeLater(runnable2, this.getDisposed());
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull Condition expired) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        if (expired == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expired", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        this.invokeLater(runnable2, ModalityState.defaultModalityState(), expired);
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState state) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        this.invokeLater(runnable2, state, this.getDisposed());
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState state, @NotNull Condition expired) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        if (expired == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expired", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeLater"));
        }
        this.myInvokator.invokeLater(this.myTransactionGuard.wrapLaterInvocation(runnable2, state), state, expired);
    }

    @Override
    public void load() {
        this.load(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(@Nullable String configPath) {
        AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Loading application components");
        try {
            long start2 = System.currentTimeMillis();
            EmptyProgressIndicator indicator = this.mySplash == null ? null : new EmptyProgressIndicator(){

                public void setFraction(double fraction) {
                    ApplicationImpl.this.mySplash.showProgress("", (float)fraction);
                }
            };
            this.init((ProgressIndicator)indicator, () -> {
                ApplicationLoadListener[] applicationLoadListeners;
                this.getPicoContainer().getComponentInstance(ServiceManagerImpl.class);
                String effectiveConfigPath = FileUtilRt.toSystemIndependentName((String)(configPath == null ? PathManager.getConfigPath() : configPath));
                for (ApplicationLoadListener listener2 : applicationLoadListeners = (ApplicationLoadListener[])ApplicationLoadListener.EP_NAME.getExtensions()) {
                    try {
                        listener2.beforeApplicationLoaded(this, effectiveConfigPath);
                    }
                    catch (Throwable e2) {
                        LOG.error(e2);
                    }
                }
                ServiceKt.getStateStore(this).setPath(effectiveConfigPath);
                for (ApplicationLoadListener listener2 : applicationLoadListeners) {
                    try {
                        listener2.beforeComponentsCreated();
                    }
                    catch (Throwable e3) {
                        LOG.error(e3);
                    }
                }
            });
            LOG.info(this.getComponentConfigCount() + " application components initialized in " + (System.currentTimeMillis() - start2) + "ms");
        }
        finally {
            token.finish();
        }
        this.myLoaded = true;
        this.mySplash = null;
        ApplicationImpl.createLocatorFile();
    }

    @Override
    protected void createComponents(@Nullable ProgressIndicator indicator) {
        Runnable task2 = () -> super.createComponents(indicator);
        if (indicator == null) {
            task2.run();
        } else {
            ProgressManager.getInstance().runProcess(task2, indicator);
        }
    }

    @Override
    @Nullable
    protected ProgressIndicator getProgressIndicator() {
        ProgressManager progressManager = (ProgressManager)this.getPicoContainer().getComponentInstance((Object)ProgressManager.class.getName());
        return progressManager == null ? null : progressManager.getProgressIndicator();
    }

    @Override
    protected void setProgressDuringInit(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/application/impl/ApplicationImpl", "setProgressDuringInit"));
        }
        float start2 = 0.65f;
        indicator.setFraction((double)start2 + this.getPercentageOfComponentsLoaded() * (double)(1.0f - start2));
    }

    private static void createLocatorFile() {
        File locatorFile = new File(PathManager.getSystemPath() + "/" + ".home");
        try {
            byte[] data = PathManager.getHomePath().getBytes(CharsetToolkit.UTF8_CHARSET);
            FileUtil.writeToFile((File)locatorFile, (byte[])data);
        }
        catch (IOException e2) {
            LOG.warn("can't store a location in '" + locatorFile + "'", (Throwable)e2);
        }
    }

    @Override
    public boolean isLoaded() {
        return this.myLoaded;
    }

    @Override
    public void dispose() {
        HeavyProcessLatch.INSTANCE.stopThreadPrioritizing();
        this.fireApplicationExiting();
        ShutDownTracker.getInstance().ensureStopperThreadsFinished();
        this.disposeComponents();
        AppScheduledExecutorService service = (AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService();
        service.shutdownAppScheduledExecutorService();
        super.dispose();
        Disposer.dispose((Disposable)this.myLastDisposable);
        if (this.gatherStatistics) {
            LOG.info(this.writeActionStatistics());
            LOG.info(ActionUtil.ActionPauses.STAT.statistics());
            LOG.info(((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).statistics() + "; ProcessIOExecutorService threads: " + ((ProcessIOExecutorService)ProcessIOExecutorService.INSTANCE).getThreadCounter());
        }
    }

    @NotNull
    public String writeActionStatistics() {
        String string2 = ActionPauses.WRITE.statistics();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "writeActionStatistics"));
        }
        return string2;
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull String progressTitle, boolean canBeCanceled, Project project2) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        return this.runProcessWithProgressSynchronously(process2, progressTitle, canBeCanceled, project2, null);
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project2, JComponent parentComponent) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        return this.runProcessWithProgressSynchronously(process2, progressTitle, canBeCanceled, project2, parentComponent, null);
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project2, JComponent parentComponent, String cancelText) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronously"));
        }
        this.assertIsDispatchThread();
        boolean writeAccessAllowed = this.isWriteAccessAllowed();
        if (writeAccessAllowed || this.isHeadlessEnvironment() && !this.isUnitTestMode()) {
            if (writeAccessAllowed) {
                LOG.debug("Starting process with progress from within write action makes no sense");
            }
            try {
                ProgressManager.getInstance().runProcess(process2, (ProgressIndicator)new EmptyProgressIndicator());
            }
            catch (ProcessCanceledException e2) {
                return false;
            }
            return true;
        }
        ProgressWindow progress = new ProgressWindow(canBeCanceled, false, project2, parentComponent, cancelText);
        Disposer.register((Disposable)this, (Disposable)progress);
        progress.setTitle(progressTitle);
        AtomicBoolean threadStarted = new AtomicBoolean();
        SwingUtilities.invokeLater(() -> {
            if (process2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/application/impl/ApplicationImpl", "lambda$runProcessWithProgressSynchronously$10"));
            }
            this.executeOnPooledThread(() -> {
                if (process2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/application/impl/ApplicationImpl", "lambda$null$9"));
                }
                try {
                    ProgressManager.getInstance().runProcess(process2, (ProgressIndicator)progress);
                }
                catch (ProcessCanceledException e2) {
                    progress.cancel();
                }
                catch (RuntimeException e3) {
                    progress.cancel();
                    throw e3;
                }
            });
            threadStarted.set(true);
        });
        progress.startBlocking();
        LOG.assertTrue(threadStarted.get());
        LOG.assertTrue(!progress.isRunning());
        return !progress.isCanceled();
    }

    @Override
    public boolean runProcessWithProgressSynchronouslyInReadAction(@Nullable Project project2, @NotNull String progressTitle, boolean canBeCanceled, String cancelText, JComponent parentComponent, @NotNull Runnable process2) {
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronouslyInReadAction"));
        }
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/application/impl/ApplicationImpl", "runProcessWithProgressSynchronouslyInReadAction"));
        }
        this.assertIsDispatchThread();
        boolean writeAccessAllowed = this.isWriteAccessAllowed();
        if (writeAccessAllowed) {
            throw new IncorrectOperationException("Starting process with progress from within write action makes no sense");
        }
        ProgressWindow progress = new ProgressWindow(canBeCanceled, false, project2, parentComponent, cancelText);
        Disposer.register((Disposable)this, (Disposable)progress);
        progress.setTitle(progressTitle);
        Semaphore readActionAcquired = new Semaphore();
        readActionAcquired.down();
        Semaphore modalityEntered = new Semaphore();
        modalityEntered.down();
        this.executeOnPooledThread(() -> {
            if (process2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/application/impl/ApplicationImpl", "lambda$runProcessWithProgressSynchronouslyInReadAction$12"));
            }
            try {
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (process2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/application/impl/ApplicationImpl", "lambda$null$11"));
                    }
                    readActionAcquired.up();
                    modalityEntered.waitFor();
                    ProgressManager.getInstance().runProcess(process2, (ProgressIndicator)progress);
                });
            }
            catch (ProcessCanceledException e2) {
                progress.cancel();
            }
            catch (RuntimeException e3) {
                progress.cancel();
                throw e3;
            }
        });
        readActionAcquired.waitFor();
        progress.startBlocking(() -> ((Semaphore)modalityEntered).up());
        LOG.assertTrue(!progress.isRunning());
        return !progress.isCanceled();
    }

    public void invokeAndWait(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeAndWait"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeAndWait"));
        }
        if (this.isDispatchThread()) {
            runnable2.run();
            return;
        }
        if (this.holdsReadLock()) {
            LOG.error("Calling invokeAndWait from read-action leads to possible deadlock.");
        }
        LaterInvocator.invokeAndWait(this.myTransactionGuard.wrapLaterInvocation(runnable2, modalityState), modalityState);
    }

    public void invokeAndWait(@NotNull Runnable runnable2) throws ProcessCanceledException {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "invokeAndWait"));
        }
        this.invokeAndWait(runnable2, ModalityState.defaultModalityState());
    }

    @NotNull
    public ModalityState getCurrentModalityState() {
        if (Thread.currentThread() == this.myWriteActionThread) {
            ModalityState modalityState = this.getDefaultModalityState();
            if (modalityState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getCurrentModalityState"));
            }
            return modalityState;
        }
        ModalityState modalityState = LaterInvocator.getCurrentModalityState();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getCurrentModalityState"));
        }
        return modalityState;
    }

    @NotNull
    public ModalityState getModalityStateForComponent(@NotNull Component c2) {
        if (c2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/application/impl/ApplicationImpl", "getModalityStateForComponent"));
        }
        Window window = UIUtil.getWindow((Component)c2);
        if (window == null) {
            ModalityState modalityState = this.getNoneModalityState();
            if (modalityState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getModalityStateForComponent"));
            }
            return modalityState;
        }
        ModalityStateEx modalityStateEx = LaterInvocator.modalityStateForWindow(window);
        if (modalityStateEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getModalityStateForComponent"));
        }
        return modalityStateEx;
    }

    @NotNull
    public ModalityState getAnyModalityState() {
        ModalityState modalityState = ANY;
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getAnyModalityState"));
        }
        return modalityState;
    }

    @NotNull
    public ModalityState getDefaultModalityState() {
        ModalityState modalityState = this.isDispatchThread() ? this.getCurrentModalityState() : CoreProgressManager.getCurrentThreadProgressModality();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getDefaultModalityState"));
        }
        return modalityState;
    }

    @NotNull
    public ModalityState getNoneModalityState() {
        ModalityState modalityState = ModalityState.NON_MODAL;
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getNoneModalityState"));
        }
        return modalityState;
    }

    public long getStartTime() {
        return this.myStartTime;
    }

    public long getIdleTime() {
        this.assertIsDispatchThread();
        return IdeEventQueue.getInstance().getIdleTime();
    }

    public void exit() {
        this.exit(false, false);
    }

    @Override
    public void exit(boolean force, boolean exitConfirmed) {
        this.exit(false, exitConfirmed, false);
    }

    public void restart() {
        this.restart(false);
    }

    @Override
    public void restart(boolean exitConfirmed) {
        this.exit(false, exitConfirmed, true);
    }

    public void exit(boolean force, boolean exitConfirmed, boolean restart) {
        this.exit(force, exitConfirmed, restart, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void exit(boolean force, boolean exitConfirmed, boolean restart, @NotNull String[] beforeRestart) {
        if (beforeRestart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeRestart", "com/intellij/openapi/application/impl/ApplicationImpl", "exit"));
        }
        if (!force) {
            if (this.myExitInProgress) {
                return;
            }
            if (!exitConfirmed && this.getDefaultModalityState() != ModalityState.NON_MODAL) {
                return;
            }
        }
        this.myExitInProgress = true;
        if (this.isDispatchThread()) {
            this.doExit(force, exitConfirmed, restart, beforeRestart);
        } else {
            this.invokeLater(() -> {
                if (beforeRestart == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeRestart", "com/intellij/openapi/application/impl/ApplicationImpl", "lambda$exit$13"));
                }
                this.doExit(force, exitConfirmed, restart, beforeRestart);
            }, ModalityState.NON_MODAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExit(boolean force, boolean exitConfirmed, boolean restart, String[] beforeRestart) {
        try {
            if (!force && !ApplicationImpl.confirmExitIfNeeded(exitConfirmed)) {
                return;
            }
            AppLifecycleListener lifecycleListener = (AppLifecycleListener)this.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC);
            lifecycleListener.appClosing();
            this.myDisposeInProgress = true;
            if (!force && !this.canExit()) {
                return;
            }
            this.saveSettings();
            lifecycleListener.appWillBeClosed(restart);
            boolean success = this.disposeSelf(!force);
            if (!success || this.isUnitTestMode() || Boolean.getBoolean("idea.test.guimode")) {
                if (Boolean.getBoolean("idea.test.guimode")) {
                    IdeaApplication.getInstance().shutdown();
                }
                return;
            }
            int exitCode = 0;
            if (restart && Restarter.isSupported()) {
                try {
                    Restarter.scheduleRestart(beforeRestart);
                }
                catch (Throwable t2) {
                    LOG.error("Restart failed", t2);
                    Main.showMessage((String)"Restart failed", (Throwable)t2);
                    exitCode = 2;
                }
            }
            System.exit(exitCode);
        }
        finally {
            this.myDisposeInProgress = false;
            this.myExitInProgress = false;
        }
    }

    private static boolean confirmExitIfNeeded(boolean exitConfirmed) {
        final boolean hasUnsafeBgTasks = ProgressManager.getInstance().hasUnsafeProgressIndicator();
        if (exitConfirmed && !hasUnsafeBgTasks) {
            return true;
        }
        DialogWrapper.DoNotAskOption option = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return GeneralSettings.getInstance().isConfirmExit() && ProjectManager.getInstance().getOpenProjects().length > 0;
            }

            public void setToBeShown(boolean value2, int exitCode) {
                GeneralSettings.getInstance().setConfirmExit(value2);
            }

            public boolean canBeHidden() {
                return !hasUnsafeBgTasks;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                if ("Do not ask me again" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl$5", "getDoNotShowMessage"));
                }
                return "Do not ask me again";
            }
        };
        if (hasUnsafeBgTasks || option.isToBeShown()) {
            final AtomicBoolean alreadyGone = new AtomicBoolean(false);
            if (hasUnsafeBgTasks) {
                final Runnable dialogRemover = Messages.createMessageDialogRemover(null);
                Runnable task2 = new Runnable(){

                    @Override
                    public void run() {
                        if (alreadyGone.get()) {
                            return;
                        }
                        if (!ProgressManager.getInstance().hasUnsafeProgressIndicator()) {
                            alreadyGone.set(true);
                            dialogRemover.run();
                        } else {
                            JobScheduler.getScheduler().schedule(this, 1L, TimeUnit.SECONDS);
                        }
                    }
                };
                JobScheduler.getScheduler().schedule(task2, 1L, TimeUnit.SECONDS);
            }
            String name = ApplicationNamesInfo.getInstance().getFullProductName();
            String message2 = ApplicationBundle.message((String)(hasUnsafeBgTasks ? "exit.confirm.prompt.tasks" : "exit.confirm.prompt"), (Object[])new Object[]{name});
            int result2 = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)ApplicationBundle.message((String)"exit.confirm.title", (Object[])new Object[0]), (String)message2).yesText(ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]))).noText(CommonBundle.message((String)"button.cancel", (Object[])new Object[0]))).doNotAsk(option)).show();
            if (alreadyGone.getAndSet(true)) {
                if (!option.isToBeShown()) {
                    return true;
                }
                result2 = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)ApplicationBundle.message((String)"exit.confirm.title", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"exit.confirm.prompt", (Object[])new Object[]{name})).yesText(ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]))).noText(CommonBundle.message((String)"button.cancel", (Object[])new Object[0]))).doNotAsk(option)).show();
            }
            if (result2 != 0) {
                return false;
            }
        }
        return true;
    }

    private boolean canExit() {
        Project[] projects;
        for (ApplicationListener applicationListener : this.myDispatcher.getListeners()) {
            if (applicationListener.canExitApplication()) continue;
            return false;
        }
        ProjectManagerEx projectManager = (ProjectManagerEx)ProjectManager.getInstance();
        for (Project project2 : projects = projectManager.getOpenProjects()) {
            if (projectManager.canClose(project2)) continue;
            return false;
        }
        return true;
    }

    public void runReadAction(@NotNull Runnable action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "runReadAction"));
        }
        if (this.isReadAccessAllowed()) {
            action2.run();
        } else {
            this.startRead();
            try {
                action2.run();
            }
            finally {
                this.endRead();
            }
        }
    }

    public <T> T runReadAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/openapi/application/impl/ApplicationImpl", "runReadAction"));
        }
        if (this.isReadAccessAllowed()) {
            return (T)computation.compute();
        }
        this.startRead();
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            this.endRead();
        }
    }

    public <T, E extends Throwable> T runReadAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/openapi/application/impl/ApplicationImpl", "runReadAction"));
        }
        if (this.isReadAccessAllowed()) {
            return (T)computation.compute();
        }
        this.startRead();
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            this.endRead();
        }
    }

    private void startRead() {
        this.assertNoPsiLock();
        this.myLock.readLock();
    }

    private void endRead() {
        this.myLock.readUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Experimental
    public boolean runWriteActionWithProgressInDispatchThread(@NotNull String title, @Nullable Project project2, @Nullable JComponent parentComponent, @Nullable String cancelText, @NotNull Consumer<ProgressIndicator> action2) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/application/impl/ApplicationImpl", "runWriteActionWithProgressInDispatchThread"));
        }
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "runWriteActionWithProgressInDispatchThread"));
        }
        Class<?> clazz = action2.getClass();
        this.startWrite(clazz);
        try {
            PotemkinProgress indicator = new PotemkinProgress(title, project2, parentComponent, cancelText);
            indicator.runInSwingThread(() -> {
                if (action2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "lambda$runWriteActionWithProgressInDispatchThread$14"));
                }
                action2.consume((Object)indicator);
            });
            boolean bl = !indicator.isCanceled();
            return bl;
        }
        finally {
            this.endWrite(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Experimental
    public boolean runWriteActionWithProgressInBackgroundThread(@NotNull String title, @Nullable Project project2, @Nullable JComponent parentComponent, @Nullable String cancelText, @NotNull Consumer<ProgressIndicator> action2) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/application/impl/ApplicationImpl", "runWriteActionWithProgressInBackgroundThread"));
        }
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "runWriteActionWithProgressInBackgroundThread"));
        }
        Class<?> clazz = action2.getClass();
        this.startWrite(clazz);
        try {
            PotemkinProgress indicator = new PotemkinProgress(title, project2, parentComponent, cancelText);
            indicator.runInBackground(() -> {
                if (action2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "lambda$runWriteActionWithProgressInBackgroundThread$15"));
                }
                assert (this.myWriteActionThread == null);
                this.myWriteActionThread = Thread.currentThread();
                try {
                    action2.consume((Object)indicator);
                }
                finally {
                    this.myWriteActionThread = null;
                }
            });
            boolean bl = !indicator.isCanceled();
            return bl;
        }
        finally {
            this.endWrite(clazz);
        }
    }

    public void runWriteAction(@NotNull Runnable action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "runWriteAction"));
        }
        Class<?> clazz = action2.getClass();
        this.startWrite(clazz);
        try {
            action2.run();
        }
        finally {
            this.endWrite(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runWriteAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/openapi/application/impl/ApplicationImpl", "runWriteAction"));
        }
        Class<?> clazz = computation.getClass();
        this.startWrite(clazz);
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            this.endWrite(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T runWriteAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/openapi/application/impl/ApplicationImpl", "runWriteAction"));
        }
        Class<?> clazz = computation.getClass();
        this.startWrite(clazz);
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            this.endWrite(clazz);
        }
    }

    public boolean hasWriteAction(@NotNull Class<?> actionClass) {
        if (actionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionClass", "com/intellij/openapi/application/impl/ApplicationImpl", "hasWriteAction"));
        }
        this.assertReadAccessAllowed();
        for (int i2 = this.myWriteActionsStack.size() - 1; i2 >= 0; --i2) {
            Class action2 = (Class)this.myWriteActionsStack.get(i2);
            if (actionClass != action2 && !ReflectionUtil.isAssignable(actionClass, (Class)action2)) continue;
            return true;
        }
        return false;
    }

    public void assertReadAccessAllowed() {
        if (!this.isReadAccessAllowed()) {
            LOG.error("Read access is allowed from event dispatch thread or inside read-action only (see com.intellij.openapi.application.Application.runReadAction())", new String[]{"Current thread: " + ApplicationImpl.describe(Thread.currentThread()), "; dispatch thread: " + EventQueue.isDispatchThread() + "; isDispatchThread(): " + this.isDispatchThread(), "SystemEventQueueThread: " + ApplicationImpl.describe(ApplicationImpl.getEventQueueThread())});
        }
    }

    private static String describe(Thread o2) {
        if (o2 == null) {
            return "null";
        }
        return o2 + " " + System.identityHashCode(o2);
    }

    private static Thread getEventQueueThread() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        return AWTAccessor.getEventQueueAccessor().getDispatchThread(eventQueue);
    }

    public boolean isReadAccessAllowed() {
        if (this.isDispatchThread()) {
            return this.myWriteActionThread == null;
        }
        return this.myLock.isReadLockedByThisThread() || this.myWriteActionThread == Thread.currentThread();
    }

    public void assertIsDispatchThread() {
        if (this.isDispatchThread()) {
            return;
        }
        if (ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        this.assertIsDispatchThread("Access is allowed from event dispatch thread only.");
    }

    private void assertIsDispatchThread(@NotNull String message2) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/application/impl/ApplicationImpl", "assertIsDispatchThread"));
        }
        if (this.isDispatchThread()) {
            return;
        }
        Attachment dump = new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString());
        throw new LogEventException(message2, " EventQueue.isDispatchThread()=" + EventQueue.isDispatchThread() + " isDispatchThread()=" + this.isDispatchThread() + " Toolkit.getEventQueue()=" + Toolkit.getDefaultToolkit().getSystemEventQueue() + " Current thread: " + ApplicationImpl.describe(Thread.currentThread()) + " SystemEventQueueThread: " + ApplicationImpl.describe(ApplicationImpl.getEventQueueThread()), dump);
    }

    @Override
    public void runEdtSafeAction(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "runEdtSafeAction"));
        }
        runnable2.run();
    }

    @Override
    public void assertIsDispatchThread(@Nullable JComponent component) {
        if (component == null) {
            return;
        }
        if (this.isDispatchThread()) {
            return;
        }
        if (Boolean.TRUE.equals(component.getClientProperty(WAS_EVER_SHOWN))) {
            this.assertIsDispatchThread();
        } else {
            JRootPane root = component.getRootPane();
            if (root != null) {
                component.putClientProperty(WAS_EVER_SHOWN, Boolean.TRUE);
                this.assertIsDispatchThread();
            }
        }
    }

    @Override
    public void assertTimeConsuming() {
        if (this.myTestModeFlag || this.myHeadlessMode || ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        LOG.assertTrue(!this.isDispatchThread(), (Object)"This operation is time consuming and must not be called on EDT");
    }

    @Override
    public boolean tryRunReadAction(@NotNull Runnable action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "tryRunReadAction"));
        }
        if (this.isReadAccessAllowed()) {
            action2.run();
        } else {
            this.assertNoPsiLock();
            if (!this.myLock.tryReadLock()) {
                return false;
            }
            try {
                action2.run();
            }
            finally {
                this.endRead();
            }
        }
        return true;
    }

    public boolean isActive() {
        if (this.isHeadlessEnvironment()) {
            return true;
        }
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (ApplicationActivationStateManager.getState().isInactive() && activeWindow != null) {
            ApplicationActivationStateManager.updateState(activeWindow);
        }
        return ApplicationActivationStateManager.getState().isActive();
    }

    @NotNull
    public AccessToken acquireReadActionLock() {
        Object object = this.isReadAccessAllowed() ? AccessToken.EMPTY_ACCESS_TOKEN : new ReadAccessToken();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "acquireReadActionLock"));
        }
        return object;
    }

    @Override
    public boolean isWriteActionPending() {
        return this.myWriteActionPending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWrite(@NotNull Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/application/impl/ApplicationImpl", "startWrite"));
        }
        if (!this.isWriteAccessAllowed()) {
            this.assertIsDispatchThread("Write access is allowed from event dispatch thread only");
        }
        HeavyProcessLatch.INSTANCE.stopThreadPrioritizing();
        boolean writeActionPending = this.myWriteActionPending;
        if (this.gatherStatistics && this.myWriteActionsStack.isEmpty() && !writeActionPending) {
            ActionPauses.WRITE.started();
        }
        this.myWriteActionPending = true;
        try {
            ActivityTracker.getInstance().inc();
            this.fireBeforeWriteActionStart(clazz);
            if (!this.myLock.isWriteLocked()) {
                this.assertNoPsiLock();
                if (!this.myLock.tryWriteLock()) {
                    ScheduledFuture<?> reportSlowWrite = ourDumpThreadsOnLongWriteActionWaiting <= 0 ? null : JobScheduler.getScheduler().scheduleWithFixedDelay(() -> PerformanceWatcher.getInstance().dumpThreads("waiting", true), ourDumpThreadsOnLongWriteActionWaiting, ourDumpThreadsOnLongWriteActionWaiting, TimeUnit.MILLISECONDS);
                    this.myLock.writeLock();
                    if (reportSlowWrite != null) {
                        reportSlowWrite.cancel(false);
                    }
                }
            }
        }
        finally {
            this.myWriteActionPending = writeActionPending;
        }
        this.myWriteActionsStack.push((Object)clazz);
        this.fireWriteActionStarted(clazz);
    }

    private void endWrite(@NotNull Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/application/impl/ApplicationImpl", "endWrite"));
        }
        try {
            this.fireWriteActionFinished(clazz);
        }
        finally {
            this.myWriteActionsStack.pop();
            if (this.gatherStatistics && this.myWriteActionsStack.isEmpty() && !this.myWriteActionPending) {
                ActionPauses.WRITE.finished("write action (" + clazz + ")");
            }
            if (this.myWriteActionsStack.size() == this.myWriteStackBase) {
                this.myLock.writeUnlock();
            }
            if (this.myWriteActionsStack.isEmpty()) {
                this.fireAfterWriteActionFinished(clazz);
            }
        }
    }

    @NotNull
    public AccessToken acquireWriteActionLock(@NotNull Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/application/impl/ApplicationImpl", "acquireWriteActionLock"));
        }
        WriteAccessToken writeAccessToken = new WriteAccessToken(clazz);
        if (writeAccessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "acquireWriteActionLock"));
        }
        return writeAccessToken;
    }

    private void assertNoPsiLock() {
        if (this.myExtraChecks) {
            LOG.assertTrue(!Thread.holdsLock(PsiLock.LOCK), (Object)"Thread must not hold PsiLock while performing readAction");
        }
    }

    public void assertWriteAccessAllowed() {
        LOG.assertTrue(this.isWriteAccessAllowed(), (Object)"Write access is allowed inside write-action only (see com.intellij.openapi.application.Application.runWriteAction())");
    }

    public boolean isWriteAccessAllowed() {
        return this.isDispatchThread() && this.myLock.isWriteLocked() || this.myWriteActionThread == Thread.currentThread();
    }

    @Override
    public boolean isWriteActionInProgress() {
        return this.myLock.isWriteLocked();
    }

    public void executeSuspendingWriteAction(@Nullable Project project2, @NotNull String title, @NotNull Runnable runnable2) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/application/impl/ApplicationImpl", "executeSuspendingWriteAction"));
        }
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "executeSuspendingWriteAction"));
        }
        this.assertIsDispatchThread();
        if (!this.myLock.isWriteLocked()) {
            ApplicationImpl.runModalProgress(project2, title, runnable2);
            return;
        }
        this.myTransactionGuard.submitTransactionAndWait(() -> {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/application/impl/ApplicationImpl", "lambda$executeSuspendingWriteAction$18"));
            }
            if (runnable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "lambda$executeSuspendingWriteAction$18"));
            }
            int prevBase = this.myWriteStackBase;
            this.myWriteStackBase = this.myWriteActionsStack.size();
            try (AccessToken ignored = this.myLock.writeSuspend();){
                ApplicationImpl.runModalProgress(project2, title, () -> {
                    if (runnable2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "lambda$null$17"));
                    }
                    try (AccessToken ignored1 = this.myLock.grantReadPrivilege();){
                        runnable2.run();
                    }
                });
            }
            finally {
                this.myWriteStackBase = prevBase;
            }
        });
    }

    private static void runModalProgress(@Nullable Project project2, @NotNull String title, final @NotNull Runnable runnable2) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/application/impl/ApplicationImpl", "runModalProgress"));
        }
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ApplicationImpl", "runModalProgress"));
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(project2, title, false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/application/impl/ApplicationImpl$7", "run"));
                }
                runnable2.run();
            }
        });
    }

    public void editorPaintStart() {
        ++this.myInEditorPaintCounter;
    }

    public void editorPaintFinish() {
        --this.myInEditorPaintCounter;
        LOG.assertTrue(this.myInEditorPaintCounter >= 0);
    }

    public void addApplicationListener(@NotNull ApplicationListener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/openapi/application/impl/ApplicationImpl", "addApplicationListener"));
        }
        this.myDispatcher.addListener((EventListener)l2);
    }

    public void addApplicationListener(@NotNull ApplicationListener l2, @NotNull Disposable parent) {
        if (l2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/openapi/application/impl/ApplicationImpl", "addApplicationListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/application/impl/ApplicationImpl", "addApplicationListener"));
        }
        this.myDispatcher.addListener((EventListener)l2, parent);
    }

    public void removeApplicationListener(@NotNull ApplicationListener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/openapi/application/impl/ApplicationImpl", "removeApplicationListener"));
        }
        this.myDispatcher.removeListener((EventListener)l2);
    }

    private void fireApplicationExiting() {
        ((ApplicationListener)this.myDispatcher.getMulticaster()).applicationExiting();
    }

    private void fireBeforeWriteActionStart(@NotNull Class action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "fireBeforeWriteActionStart"));
        }
        ((ApplicationListener)this.myDispatcher.getMulticaster()).beforeWriteActionStart((Object)action2);
    }

    private void fireWriteActionStarted(@NotNull Class action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "fireWriteActionStarted"));
        }
        ((ApplicationListener)this.myDispatcher.getMulticaster()).writeActionStarted((Object)action2);
    }

    private void fireWriteActionFinished(@NotNull Class action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "fireWriteActionFinished"));
        }
        ((ApplicationListener)this.myDispatcher.getMulticaster()).writeActionFinished((Object)action2);
    }

    private void fireAfterWriteActionFinished(@NotNull Class action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/impl/ApplicationImpl", "fireAfterWriteActionFinished"));
        }
        ((ApplicationListener)this.myDispatcher.getMulticaster()).afterWriteActionFinished((Object)action2);
    }

    public void saveSettings() {
        if (this.myDoNotSave) {
            return;
        }
        if (this.mySaveSettingsIsInProgress.compareAndSet(false, true)) {
            HeavyProcessLatch.INSTANCE.prioritizeUiActivity();
            try {
                StoreUtil.save(ServiceKt.getStateStore(this), null);
            }
            finally {
                this.mySaveSettingsIsInProgress.set(false);
            }
        }
    }

    public void saveAll() {
        Project[] openProjects;
        if (this.myDoNotSave) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ProjectManager projectManager = ProjectManager.getInstance();
        if (projectManager instanceof ProjectManagerEx) {
            ((ProjectManagerEx)projectManager).flushChangedProjectFileAlarm();
        }
        for (Project openProject : openProjects = projectManager.getOpenProjects()) {
            openProject.save();
        }
        this.saveSettings();
    }

    @Override
    public void doNotSave() {
        this.doNotSave(true);
    }

    @Override
    public void doNotSave(boolean value2) {
        this.myDoNotSave = value2;
    }

    @Override
    public boolean isDoNotSave() {
        return this.myDoNotSave;
    }

    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/openapi/application/impl/ApplicationImpl", "getExtensions"));
        }
        Object[] objectArray = Extensions.getRootArea().getExtensionPoint(extensionPointName).getExtensions();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationImpl", "getExtensions"));
        }
        return objectArray;
    }

    public boolean isDisposeInProgress() {
        return this.myDisposeInProgress || ShutDownTracker.isShutdownHookRunning();
    }

    public boolean isRestartCapable() {
        return Restarter.isSupported();
    }

    @Override
    protected boolean logSlowComponents() {
        return super.logSlowComponents() || ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    public void setDisposeInProgress(boolean disposeInProgress) {
        this.myDisposeInProgress = disposeInProgress;
    }

    public String toString() {
        return "Application" + (this.isDisposed() ? " (Disposed)" : "") + (this.isUnitTestMode() ? " (Unit test)" : "") + (this.isInternal() ? " (Internal)" : "") + (this.isHeadlessEnvironment() ? " (Headless)" : "") + (this.isCommandLine() ? " (Command line)" : "");
    }

    void disableEventsUntil(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/application/impl/ApplicationImpl", "disableEventsUntil"));
        }
        ArrayList listeners = new ArrayList(this.myDispatcher.getListeners());
        this.myDispatcher.getListeners().removeAll(listeners);
        Disposer.register((Disposable)disposable, () -> this.myDispatcher.getListeners().addAll(listeners));
    }

    public void exit(boolean force, boolean exitConfirmed, boolean allowListenersToCancel, boolean restart) {
        this.exit(force, exitConfirmed, restart);
    }

    static {
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool();
    }

    private class ReadAccessToken
    extends AccessToken {
        private ReadAccessToken() {
            ApplicationImpl.this.startRead();
        }

        public void finish() {
            ApplicationImpl.this.endRead();
        }
    }

    private class WriteAccessToken
    extends AccessToken {
        @NotNull
        private final Class clazz;

        public WriteAccessToken(Class clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/application/impl/ApplicationImpl$WriteAccessToken", "<init>"));
            }
            this.clazz = clazz;
            ApplicationImpl.this.startWrite(clazz);
            this.markThreadNameInStackTrace();
        }

        public void finish() {
            try {
                ApplicationImpl.this.endWrite(this.clazz);
            }
            finally {
                this.unmarkThreadNameInStackTrace();
            }
        }

        private void markThreadNameInStackTrace() {
            String id = this.id();
            if (id != null) {
                Thread thread2 = Thread.currentThread();
                thread2.setName(thread2.getName() + id);
            }
        }

        private void unmarkThreadNameInStackTrace() {
            String id = this.id();
            if (id != null) {
                Thread thread2 = Thread.currentThread();
                String name = thread2.getName();
                name = StringUtil.replace((String)name, (String)id, (String)"");
                thread2.setName(name);
            }
        }

        private String id() {
            Class<?> aClass = ((Object)((Object)this)).getClass();
            String name = aClass.getName();
            while (name == null) {
                aClass = aClass.getSuperclass();
                name = aClass.getName();
            }
            name = name.substring(name.lastIndexOf(46) + 1);
            if (!(name = name.substring(name.lastIndexOf(36) + 1)).equals("AccessToken")) {
                return " [" + name + "]";
            }
            return null;
        }
    }

    private static class ActionPauses {
        private static final PausesStat WRITE = new PausesStat("Write action");

        private ActionPauses() {
        }
    }

    private static class Holder {
        private static final boolean ourIsRunningFromSources = new File(PathManager.getHomePath(), ".idea").isDirectory();

        private Holder() {
        }
    }
}

