/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReadMostlyRWLock {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.impl.ReadMostlyRWLock");
    private final Thread writeThread;
    volatile boolean writeRequested;
    private volatile boolean writeAcquired;
    private final ConcurrentList<Reader> readers;
    private final Map<Thread, SuspensionId> privilegedReaders;
    private volatile SuspensionId currentSuspension;
    private final ThreadLocal<Reader> R;
    private static final int SPIN_TO_WAIT_FOR_LOCK = 100;

    ReadMostlyRWLock(@NotNull Thread writeThread) {
        if (writeThread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writeThread", "com/intellij/openapi/application/impl/ReadMostlyRWLock", "<init>"));
        }
        this.readers = ContainerUtil.createConcurrentList();
        this.privilegedReaders = new ConcurrentHashMap<Thread, SuspensionId>();
        this.R = ThreadLocal.withInitial(() -> {
            Reader status = new Reader(Thread.currentThread());
            boolean added = this.readers.addIfAbsent((Object)status);
            assert (added) : this.readers + "; " + Thread.currentThread();
            return status;
        });
        this.writeThread = writeThread;
    }

    boolean isWriteThread() {
        return Thread.currentThread() == this.writeThread;
    }

    boolean isReadLockedByThisThread() {
        this.checkReadThreadAccess();
        Reader status = this.R.get();
        this.throwIfImpatient(status);
        return status.readRequested;
    }

    void readLock() {
        this.checkReadThreadAccess();
        Reader status = this.R.get();
        int iter = 0;
        while (!this.tryReadLock(status, true)) {
            ProgressManager.checkCanceled();
            this.waitABit(status, iter);
            ++iter;
        }
        return;
    }

    private void waitABit(Reader status, int iteration) {
        if (iteration > 100) {
            status.blocked = true;
            try {
                this.throwIfImpatient(status);
                LockSupport.parkNanos(this, 1000000L);
            }
            finally {
                status.blocked = false;
            }
        } else {
            Thread.yield();
        }
    }

    private void throwIfImpatient(Reader status) {
        if (status.impatientReads && this.writeRequested && !ProgressManager.getInstance().isInNonCancelableSection()) {
            throw new ApplicationUtil.CannotRunReadActionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeByImpatientReader(@NotNull Runnable runnable2) throws ApplicationUtil.CannotRunReadActionException {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ReadMostlyRWLock", "executeByImpatientReader"));
        }
        this.checkReadThreadAccess();
        Reader status = this.R.get();
        boolean old = status.impatientReads;
        try {
            status.impatientReads = true;
            runnable2.run();
        }
        finally {
            status.impatientReads = old;
        }
    }

    void readUnlock() {
        this.checkReadThreadAccess();
        Reader status = this.R.get();
        status.readRequested = false;
        if (this.writeRequested) {
            LockSupport.unpark(this.writeThread);
        }
    }

    boolean tryReadLock() {
        this.checkReadThreadAccess();
        Reader status = this.R.get();
        return this.tryReadLock(status, true);
    }

    private boolean tryReadLock(Reader status, boolean checkPrivileges) {
        if (!this.writeRequested) {
            if (checkPrivileges && this.currentSuspension != null && !this.privilegedReaders.containsKey(Thread.currentThread())) {
                return false;
            }
            status.readRequested = true;
            if (!this.writeRequested) {
                return true;
            }
            status.readRequested = false;
        }
        return false;
    }

    void writeLock() {
        this.checkWriteThreadAccess();
        assert (!this.writeRequested);
        assert (!this.writeAcquired);
        this.writeRequested = true;
        int iter = 0;
        while (true) {
            if (this.areAllReadersIdle()) break;
            if (iter > 100) {
                LockSupport.parkNanos(this, 1000000L);
            } else {
                Thread.yield();
            }
            ++iter;
        }
        this.writeAcquired = true;
    }

    AccessToken writeSuspend() {
        final SuspensionId prevSuspension = this.currentSuspension;
        if (prevSuspension == null) {
            this.currentSuspension = new SuspensionId();
        }
        this.writeUnlock();
        return new AccessToken(){

            public void finish() {
                ReadMostlyRWLock.this.writeLock();
                ReadMostlyRWLock.this.currentSuspension = prevSuspension;
                if (prevSuspension == null) {
                    ReadMostlyRWLock.this.ensureNoPrivilegedReaders();
                }
            }
        };
    }

    private void ensureNoPrivilegedReaders() {
        if (!this.privilegedReaders.isEmpty()) {
            List offenderNames = ContainerUtil.map(this.privilegedReaders.keySet(), Thread::getName);
            this.privilegedReaders.clear();
            LOG.error("Pooled threads created during write action suspension should have been terminated: " + offenderNames, new Attachment[]{new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString())});
        }
    }

    @Nullable
    SuspensionId currentReadPrivilege() {
        return this.privilegedReaders.get(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    AccessToken applyReadPrivilege(@Nullable SuspensionId context2) {
        Reader status = this.R.get();
        int iter = 0;
        while (context2 != null && context2 == this.currentSuspension) {
            if (this.tryReadLock(status, false)) {
                AccessToken accessToken = context2 == this.currentSuspension ? this.grantReadPrivilege() : AccessToken.EMPTY_ACCESS_TOKEN;
                AccessToken accessToken2 = accessToken;
                if (accessToken2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ReadMostlyRWLock", "applyReadPrivilege"));
                }
                return accessToken2;
                finally {
                    this.readUnlock();
                }
            }
            this.waitABit(status, iter++);
        }
        AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ReadMostlyRWLock", "applyReadPrivilege"));
        }
        return accessToken;
    }

    @NotNull
    AccessToken grantReadPrivilege() {
        final Thread thread2 = Thread.currentThread();
        this.privilegedReaders.put(thread2, this.currentSuspension);
        AccessToken accessToken = new AccessToken(){

            public void finish() {
                ReadMostlyRWLock.this.privilegedReaders.remove(thread2);
            }
        };
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ReadMostlyRWLock", "grantReadPrivilege"));
        }
        return accessToken;
    }

    void writeUnlock() {
        this.checkWriteThreadAccess();
        this.writeAcquired = false;
        this.writeRequested = false;
        ArrayList<Reader> dead = new ArrayList<Reader>(this.readers.size());
        for (Reader reader : this.readers) {
            if (reader.blocked) {
                LockSupport.unpark(reader.thread);
                continue;
            }
            if (reader.thread.isAlive()) continue;
            dead.add(reader);
        }
        this.readers.removeAll(dead);
    }

    private void checkWriteThreadAccess() {
        if (Thread.currentThread() != this.writeThread) {
            throw new IllegalStateException("Current thread: " + Thread.currentThread() + "; expected: " + this.writeThread);
        }
    }

    private void checkReadThreadAccess() {
        if (Thread.currentThread() == this.writeThread) {
            throw new IllegalStateException("Must not start read from the write thread: " + Thread.currentThread());
        }
    }

    boolean tryWriteLock() {
        this.checkWriteThreadAccess();
        assert (!this.writeRequested);
        assert (!this.writeAcquired);
        this.writeRequested = true;
        if (this.areAllReadersIdle()) {
            this.writeAcquired = true;
            return true;
        }
        this.writeRequested = false;
        return false;
    }

    private boolean areAllReadersIdle() {
        for (Reader reader : this.readers) {
            if (!reader.readRequested) continue;
            return false;
        }
        return true;
    }

    boolean isWriteLocked() {
        return this.writeAcquired;
    }

    static class SuspensionId {
        SuspensionId() {
        }
    }

    private static class Reader {
        @NotNull
        private final Thread thread;
        private volatile boolean readRequested;
        private volatile boolean blocked;
        private boolean impatientReads;

        Reader(@NotNull Thread readerThread) {
            if (readerThread == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readerThread", "com/intellij/openapi/application/impl/ReadMostlyRWLock$Reader", "<init>"));
            }
            this.thread = readerThread;
        }
    }
}

