/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.history.LocalHistory;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.impl.ChangeRange;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoProvider;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.ForceUndo;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FileUndoProvider
extends VirtualFileAdapter
implements UndoProvider {
    public static final Logger LOG = Logger.getInstance((String)("#" + FileUndoProvider.class.getName()));
    private final Key<DocumentReference> DELETION_WAS_UNDOABLE = new Key(FileUndoProvider.class.getName() + ".DeletionWasUndoable");
    private final Project myProject;
    private boolean myIsInsideCommand;
    private LocalHistoryFacade myLocalHistory;
    private IdeaGateway myGateway;
    private long myLastChangeId;

    public FileUndoProvider() {
        this(null);
    }

    public FileUndoProvider(Project project2) {
        this.myProject = project2;
        if (this.myProject == null) {
            return;
        }
        LocalHistoryImpl localHistory = LocalHistoryImpl.getInstanceImpl();
        this.myLocalHistory = localHistory.getFacade();
        this.myGateway = localHistory.getGateway();
        if (this.myLocalHistory == null || this.myGateway == null) {
            return;
        }
        localHistory.addVFSListenerAfterLocalHistoryOne((VirtualFileListener)this, (Disposable)project2);
        this.myLocalHistory.addListener(new LocalHistoryFacade.Listener(){

            @Override
            public void changeAdded(Change c2) {
                if (!(c2 instanceof StructuralChange) || c2 instanceof ContentChange) {
                    return;
                }
                FileUndoProvider.this.myLastChangeId = c2.getId();
            }
        }, (Disposable)this.myProject);
    }

    @Override
    public void commandStarted(Project p2) {
        if (this.myProject != p2) {
            return;
        }
        this.myIsInsideCommand = true;
    }

    @Override
    public void commandFinished(Project p2) {
        if (this.myProject != p2) {
            return;
        }
        this.myIsInsideCommand = false;
    }

    public void fileCreated(@NotNull VirtualFileEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/command/impl/FileUndoProvider", "fileCreated"));
        }
        this.processEvent(e2);
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/command/impl/FileUndoProvider", "propertyChanged"));
        }
        if (!e2.getPropertyName().equals("name")) {
            return;
        }
        this.processEvent((VirtualFileEvent)e2);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/command/impl/FileUndoProvider", "fileMoved"));
        }
        this.processEvent((VirtualFileEvent)e2);
    }

    private void processEvent(VirtualFileEvent e2) {
        if (this.shouldNotProcess(e2)) {
            return;
        }
        if (FileUndoProvider.isUndoable(e2)) {
            this.registerUndoableAction(e2);
        } else {
            this.registerNonUndoableAction(e2);
        }
    }

    public void beforeContentsChange(@NotNull VirtualFileEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/command/impl/FileUndoProvider", "beforeContentsChange"));
        }
        if (this.shouldNotProcess(e2)) {
            return;
        }
        if (ForceUndo.IgnoreVFContentChanges) {
            return;
        }
        if (FileUndoProvider.isUndoable(e2)) {
            return;
        }
        this.registerNonUndoableAction(e2);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/command/impl/FileUndoProvider", "beforeFileDeletion"));
        }
        if (this.shouldNotProcess(e2)) {
            this.invalidateActionsFor(e2);
            return;
        }
        if (FileUndoProvider.isUndoable(e2)) {
            VirtualFile file2 = e2.getFile();
            file2.putUserData(this.DELETION_WAS_UNDOABLE, (Object)FileUndoProvider.createDocumentReference(e2));
        } else {
            this.registerNonUndoableAction(e2);
        }
    }

    public void fileDeleted(@NotNull VirtualFileEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/command/impl/FileUndoProvider", "fileDeleted"));
        }
        VirtualFile f2 = e2.getFile();
        DocumentReference ref = (DocumentReference)f2.getUserData(this.DELETION_WAS_UNDOABLE);
        if (ref != null) {
            this.registerUndoableAction(ref);
            f2.putUserData(this.DELETION_WAS_UNDOABLE, null);
        }
    }

    private boolean shouldNotProcess(VirtualFileEvent e2) {
        return this.isProjectClosed() || !LocalHistory.getInstance().isUnderControl(e2.getFile()) || !this.myIsInsideCommand || "FileContentUtilCore.saveOrReload".equals(e2.getRequestor());
    }

    private boolean isProjectClosed() {
        return this.myProject.isDisposed();
    }

    private static boolean isUndoable(VirtualFileEvent e2) {
        return !e2.isFromRefresh();
    }

    private void registerUndoableAction(VirtualFileEvent e2) {
        this.registerUndoableAction(FileUndoProvider.createDocumentReference(e2));
    }

    private void registerUndoableAction(DocumentReference ref) {
        this.getUndoManager().undoableActionPerformed((UndoableAction)new MyUndoableAction(ref));
    }

    private void registerNonUndoableAction(VirtualFileEvent e2) {
        this.getUndoManager().nonundoableActionPerformed(FileUndoProvider.createDocumentReference(e2), true);
    }

    private void invalidateActionsFor(VirtualFileEvent e2) {
        this.getUndoManager().invalidateActionsFor(FileUndoProvider.createDocumentReference(e2));
    }

    private static DocumentReference createDocumentReference(VirtualFileEvent e2) {
        return DocumentReferenceManager.getInstance().create(e2.getFile());
    }

    private UndoManagerImpl getUndoManager() {
        if (this.myProject != null) {
            return (UndoManagerImpl)UndoManager.getInstance((Project)this.myProject);
        }
        return (UndoManagerImpl)UndoManager.getGlobalInstance();
    }

    private class MyUndoableAction
    extends GlobalUndoableAction {
        private ChangeRange myActionChangeRange;
        private ChangeRange myUndoChangeRange;

        public MyUndoableAction(DocumentReference r2) {
            super(new DocumentReference[]{r2});
            this.myActionChangeRange = new ChangeRange(FileUndoProvider.this.myGateway, FileUndoProvider.this.myLocalHistory, FileUndoProvider.this.myLastChangeId);
        }

        public void undo() throws UnexpectedUndoException {
            try {
                this.myUndoChangeRange = this.myActionChangeRange.revert(this.myUndoChangeRange);
            }
            catch (IOException e2) {
                LOG.warn((Throwable)e2);
                throw new UnexpectedUndoException(e2.getMessage());
            }
        }

        public void redo() throws UnexpectedUndoException {
            try {
                this.myActionChangeRange = this.myUndoChangeRange.revert(this.myActionChangeRange);
            }
            catch (IOException e2) {
                LOG.warn((Throwable)e2);
                throw new UnexpectedUndoException(e2.getMessage());
            }
        }
    }
}

