/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FinishMarkAction
extends BasicUndoableAction {
    @NotNull
    private final StartMarkAction myStartAction;
    private boolean myGlobal;
    private String myCommandName;
    private DocumentReference myReference;

    private FinishMarkAction(DocumentReference reference, @NotNull StartMarkAction action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/command/impl/FinishMarkAction", "<init>"));
        }
        super(new DocumentReference[]{reference});
        this.myGlobal = false;
        this.myReference = reference;
        this.myStartAction = action2;
    }

    public void undo() {
    }

    public void redo() {
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    public void setGlobal(boolean isGlobal) {
        this.myStartAction.setGlobal(isGlobal);
        this.myGlobal = isGlobal;
    }

    public void setCommandName(String commandName) {
        this.myStartAction.setCommandName(commandName);
        this.myCommandName = commandName;
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    public DocumentReference getAffectedDocument() {
        return this.myReference;
    }

    public static void finish(Project project2, Editor editor, @Nullable StartMarkAction startAction) {
        if (startAction == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            DocumentReference reference = DocumentReferenceManager.getInstance().create(editor.getDocument());
            UndoManager.getInstance((Project)project2).undoableActionPerformed((UndoableAction)new FinishMarkAction(reference, startAction));
            StartMarkAction.markFinished(project2);
        }, "finish", null);
    }
}

