/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.WeakList;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class UndoRedoStacksHolder {
    private final Key<LinkedList<UndoableGroup>> STACK_IN_DOCUMENT_KEY = Key.create((String)"STACK_IN_DOCUMENT_KEY");
    private final boolean myUndo;
    private final LinkedList<UndoableGroup> myGlobalStack = new LinkedList();
    private final Map<DocumentReference, LinkedList<UndoableGroup>> myDocumentStacks = new HashMap();
    private final List<Document> myDocumentsWithStacks = new WeakList();
    private final List<VirtualFile> myNonlocalVirtualFilesWithStacks = new WeakList();

    public UndoRedoStacksHolder(boolean isUndo) {
        this.myUndo = isUndo;
    }

    @NotNull
    LinkedList<UndoableGroup> getStack(@NotNull DocumentReference r2) {
        if (r2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "getStack"));
        }
        LinkedList<UndoableGroup> linkedList = r2.getFile() != null ? this.doGetStackForFile(r2) : this.doGetStackForDocument(r2);
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "getStack"));
        }
        return linkedList;
    }

    @NotNull
    private LinkedList<UndoableGroup> doGetStackForFile(@NotNull DocumentReference r2) {
        LinkedList<UndoableGroup> result2;
        if (r2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "doGetStackForFile"));
        }
        VirtualFile file2 = r2.getFile();
        if (!file2.isInLocalFileSystem()) {
            result2 = this.addWeaklyTrackedEmptyStack(file2, this.myNonlocalVirtualFilesWithStacks);
        } else {
            result2 = this.myDocumentStacks.get(r2);
            if (result2 == null) {
                result2 = new LinkedList();
                this.myDocumentStacks.put(r2, result2);
            }
        }
        LinkedList<UndoableGroup> linkedList = result2;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "doGetStackForFile"));
        }
        return linkedList;
    }

    @NotNull
    private LinkedList<UndoableGroup> doGetStackForDocument(@NotNull DocumentReference r2) {
        if (r2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "doGetStackForDocument"));
        }
        LinkedList<UndoableGroup> linkedList = this.addWeaklyTrackedEmptyStack(r2.getDocument(), this.myDocumentsWithStacks);
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "doGetStackForDocument"));
        }
        return linkedList;
    }

    @NotNull
    private <T extends UserDataHolder> LinkedList<UndoableGroup> addWeaklyTrackedEmptyStack(@NotNull T holder, @NotNull List<T> allHolders) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "addWeaklyTrackedEmptyStack"));
        }
        if (allHolders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allHolders", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "addWeaklyTrackedEmptyStack"));
        }
        LinkedList result2 = (LinkedList)holder.getUserData(this.STACK_IN_DOCUMENT_KEY);
        if (result2 == null) {
            result2 = new LinkedList();
            holder.putUserData(this.STACK_IN_DOCUMENT_KEY, result2);
            allHolders.add(holder);
        }
        LinkedList linkedList = result2;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "addWeaklyTrackedEmptyStack"));
        }
        return linkedList;
    }

    boolean canBeUndoneOrRedone(@NotNull Collection<DocumentReference> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "canBeUndoneOrRedone"));
        }
        if (refs.isEmpty()) {
            return !this.myGlobalStack.isEmpty() && this.myGlobalStack.getLast().isValid();
        }
        for (DocumentReference each : refs) {
            if (this.getStack(each).isEmpty() || !this.getStack(each).getLast().isValid()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    UndoableGroup getLastAction(@NotNull Collection<DocumentReference> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "getLastAction"));
        }
        if (refs.isEmpty()) {
            UndoableGroup undoableGroup = this.myGlobalStack.getLast();
            if (undoableGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "getLastAction"));
            }
            return undoableGroup;
        }
        UndoableGroup mostRecentAction = null;
        int mostRecentDocTimestamp = this.myUndo ? -1 : Integer.MAX_VALUE;
        for (DocumentReference each : refs) {
            LinkedList<UndoableGroup> stack = this.getStack(each);
            if (stack.isEmpty()) continue;
            UndoableGroup lastAction = stack.getLast();
            int timestamp = lastAction.getCommandTimestamp();
            if (!(this.myUndo ? timestamp > mostRecentDocTimestamp : timestamp < mostRecentDocTimestamp)) continue;
            mostRecentAction = lastAction;
            mostRecentDocTimestamp = timestamp;
        }
        UndoableGroup undoableGroup = mostRecentAction;
        if (undoableGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "getLastAction"));
        }
        return undoableGroup;
    }

    @NotNull
    Set<DocumentReference> collectClashingActions(@NotNull UndoableGroup group) {
        UndoableGroup last;
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "collectClashingActions"));
        }
        THashSet result2 = new THashSet();
        for (DocumentReference each : group.getAffectedDocuments()) {
            UndoableGroup last2 = this.getStack(each).getLast();
            if (last2 == group) continue;
            result2.addAll(last2.getAffectedDocuments());
        }
        if (group.isGlobal() && (last = this.myGlobalStack.peekLast()) != group && last != null) {
            result2.addAll(last.getAffectedDocuments());
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "collectClashingActions"));
        }
        return tHashSet;
    }

    void addToStacks(@NotNull UndoableGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "addToStacks"));
        }
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(group)) {
            this.doAddToStack(each, group, each == this.myGlobalStack ? UndoManagerImpl.getGlobalUndoLimit() : UndoManagerImpl.getDocumentUndoLimit());
        }
    }

    private void doAddToStack(@NotNull LinkedList<UndoableGroup> stack, @NotNull UndoableGroup group, int limit) {
        if (stack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stack", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "doAddToStack"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "doAddToStack"));
        }
        if (!group.isUndoable() && stack.isEmpty()) {
            return;
        }
        stack.add(group);
        while (stack.size() > limit) {
            UndoableGroup first = stack.getFirst();
            stack.removeFirst();
            this.clearStacksFrom(first);
        }
    }

    void removeFromStacks(@NotNull UndoableGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "removeFromStacks"));
        }
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(group)) {
            assert (each.getLast() == group);
            each.removeLast();
        }
    }

    void clearStacks(boolean clearGlobal, @NotNull Set<DocumentReference> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "clearStacks"));
        }
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(clearGlobal, refs)) {
            while (!each.isEmpty()) {
                this.clearStacksFrom(each.getLast());
            }
        }
        THashSet stacksToDrop = new THashSet();
        for (Map.Entry<DocumentReference, LinkedList<UndoableGroup>> entry : this.myDocumentStacks.entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            stacksToDrop.add(entry.getKey());
        }
        for (DocumentReference documentReference : stacksToDrop) {
            this.myDocumentStacks.remove(documentReference);
        }
        this.cleanWeaklyTrackedEmptyStacks(this.myDocumentsWithStacks);
        this.cleanWeaklyTrackedEmptyStacks(this.myNonlocalVirtualFilesWithStacks);
    }

    private <T extends UserDataHolder> void cleanWeaklyTrackedEmptyStacks(@NotNull List<T> stackHolders) {
        if (stackHolders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackHolders", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "cleanWeaklyTrackedEmptyStacks"));
        }
        THashSet holdersToDrop = new THashSet();
        for (UserDataHolder holder : stackHolders) {
            List stack = (List)holder.getUserData(this.STACK_IN_DOCUMENT_KEY);
            if (stack == null || !stack.isEmpty()) continue;
            holder.putUserData(this.STACK_IN_DOCUMENT_KEY, null);
            holdersToDrop.add(holder);
        }
        stackHolders.removeAll((Collection<?>)holdersToDrop);
    }

    private void clearStacksFrom(@NotNull UndoableGroup from) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "clearStacksFrom"));
        }
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(from)) {
            int pos = each.indexOf(from);
            if (pos == -1) continue;
            if (pos > 0) {
                int top = each.size() - pos;
                this.clearStacksFrom(each.get(pos - 1));
                assert (each.size() == top && each.indexOf(from) == 0);
            }
            each.removeFirst();
        }
    }

    @NotNull
    private List<LinkedList<UndoableGroup>> getAffectedStacks(@NotNull UndoableGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "getAffectedStacks"));
        }
        Collection<DocumentReference> affectedDocuments = group.getAffectedDocuments();
        List<LinkedList<UndoableGroup>> affectedStacks = this.getAffectedStacks(group.isGlobal(), affectedDocuments);
        ArrayList<LinkedList<UndoableGroup>> filtered = new ArrayList<LinkedList<UndoableGroup>>();
        affectedStacks.forEach(undoableGroups -> {
            if (group == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "lambda$getAffectedStacks$0"));
            }
            if (undoableGroups == this.myGlobalStack && !group.isUndoable()) {
                if (this.hasIntersectingChanges(affectedDocuments, this.myGlobalStack)) {
                    filtered.add((LinkedList<UndoableGroup>)undoableGroups);
                }
            } else {
                filtered.add((LinkedList<UndoableGroup>)undoableGroups);
            }
        });
        ArrayList<LinkedList<UndoableGroup>> arrayList = filtered;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "getAffectedStacks"));
        }
        return arrayList;
    }

    @NotNull
    private List<LinkedList<UndoableGroup>> getAffectedStacks(boolean global, @NotNull Collection<DocumentReference> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "getAffectedStacks"));
        }
        ArrayList<LinkedList<UndoableGroup>> result2 = new ArrayList<LinkedList<UndoableGroup>>(refs.size() + 1);
        if (global) {
            result2.add(this.myGlobalStack);
        }
        for (DocumentReference each : refs) {
            result2.add(this.getStack(each));
        }
        ArrayList<LinkedList<UndoableGroup>> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "getAffectedStacks"));
        }
        return arrayList;
    }

    private boolean hasIntersectingChanges(Collection<DocumentReference> refs, LinkedList<UndoableGroup> globalStack) {
        UndoableGroup last = globalStack.peekLast();
        if (last == null) {
            return false;
        }
        Collection<DocumentReference> lastGlobalAffectedDocuments = last.getAffectedDocuments();
        return ContainerUtil.intersects(lastGlobalAffectedDocuments, refs);
    }

    void clearAllStacksInTests() {
        this.clearStacks(true, this.getAffectedDocuments());
        this.myGlobalStack.clear();
        this.myDocumentStacks.clear();
        this.myDocumentsWithStacks.clear();
        this.myNonlocalVirtualFilesWithStacks.clear();
    }

    void collectAllAffectedDocuments(@NotNull Collection<DocumentReference> result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "collectAllAffectedDocuments"));
        }
        for (UndoableGroup each : this.myGlobalStack) {
            result2.addAll(each.getAffectedDocuments());
        }
        this.collectLocalAffectedDocuments(result2);
    }

    private void collectLocalAffectedDocuments(@NotNull Collection<DocumentReference> result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "collectLocalAffectedDocuments"));
        }
        result2.addAll(this.myDocumentStacks.keySet());
        DocumentReferenceManager documentReferenceManager = DocumentReferenceManager.getInstance();
        for (Document document : this.myDocumentsWithStacks) {
            result2.add(documentReferenceManager.create(document));
        }
        for (VirtualFile virtualFile : this.myNonlocalVirtualFilesWithStacks) {
            result2.add(documentReferenceManager.create(virtualFile));
        }
    }

    @NotNull
    private Set<DocumentReference> getAffectedDocuments() {
        THashSet result2 = new THashSet();
        this.collectAllAffectedDocuments((Collection<DocumentReference>)result2);
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "getAffectedDocuments"));
        }
        return tHashSet;
    }

    int getLastCommandTimestamp(@NotNull DocumentReference r2) {
        if (r2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "getLastCommandTimestamp"));
        }
        LinkedList<UndoableGroup> stack = this.getStack(r2);
        if (stack.isEmpty()) {
            return 0;
        }
        return Math.max(stack.getFirst().getCommandTimestamp(), stack.getLast().getCommandTimestamp());
    }

    void invalidateActionsFor(@NotNull DocumentReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/openapi/command/impl/UndoRedoStacksHolder", "invalidateActionsFor"));
        }
        for (List list2 : this.getAffectedStacks(true, Collections.singleton(ref))) {
            for (UndoableGroup eachGroup : list2) {
                eachGroup.invalidateActionsFor(ref);
            }
        }
    }
}

