/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.diagnostic.Logger;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathMacroMap {
    private static final Logger LOG = Logger.getInstance(PathMacroMap.class);

    public abstract String substitute(String var1, boolean var2);

    public final String substitute(String text2, boolean caseSensitive, boolean recursively) {
        return recursively ? this.substituteRecursively(text2, caseSensitive) : this.substitute(text2, caseSensitive);
    }

    public final void substitute(@NotNull Element e2, boolean caseSensitive) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/components/PathMacroMap", "substitute"));
        }
        this.substitute(e2, caseSensitive, false);
    }

    public final void substitute(@NotNull Element e2, boolean caseSensitive, boolean recursively, @Nullable PathMacroFilter filter2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/components/PathMacroMap", "substitute"));
        }
        if (filter2 != null && filter2.skipPathMacros(e2)) {
            return;
        }
        for (Content child : e2.getContent()) {
            if (child instanceof Element) {
                this.substitute((Element)child, caseSensitive, recursively, filter2);
                continue;
            }
            if (child instanceof Text) {
                String newText;
                String oldText;
                Text t2 = (Text)child;
                if (filter2 != null && filter2.skipPathMacros(t2) || (oldText = t2.getText()) == (newText = recursively || filter2 != null && filter2.recursePathMacros(t2) ? this.substituteRecursively(oldText, caseSensitive) : this.substitute(oldText, caseSensitive))) continue;
                t2.setText(newText);
                continue;
            }
            if (child instanceof Comment) continue;
            LOG.error("Wrong content: " + child.getClass());
        }
        for (Attribute attribute : e2.getAttributes()) {
            String newValue;
            String oldValue;
            if (filter2 != null && filter2.skipPathMacros(attribute) || (oldValue = attribute.getValue()) == (newValue = recursively || filter2 != null && filter2.recursePathMacros(attribute) ? this.substituteRecursively(oldValue, caseSensitive) : this.substitute(oldValue, caseSensitive))) continue;
            attribute.setValue(newValue);
        }
    }

    public final void substitute(@NotNull Element e2, boolean caseSensitive, boolean recursively) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/components/PathMacroMap", "substitute"));
        }
        this.substitute(e2, caseSensitive, recursively, null);
    }

    @NotNull
    public String substituteRecursively(@NotNull String text2, boolean caseSensitive) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/components/PathMacroMap", "substituteRecursively"));
        }
        String string2 = this.substitute(text2, caseSensitive);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/PathMacroMap", "substituteRecursively"));
        }
        return string2;
    }

    public abstract int hashCode();
}

