/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.TrackingPathMacroSubstitutorImpl;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public class BasePathMacroManager
extends PathMacroManager {
    private PathMacrosImpl myPathMacros;

    public BasePathMacroManager(@Nullable PathMacros pathMacros) {
        this.myPathMacros = (PathMacrosImpl)pathMacros;
    }

    protected static void addFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result2, @NotNull String macroName, @Nullable String path) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/components/impl/BasePathMacroManager", "addFileHierarchyReplacements"));
        }
        if (macroName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macroName", "com/intellij/openapi/components/impl/BasePathMacroManager", "addFileHierarchyReplacements"));
        }
        if (path != null) {
            BasePathMacroManager.addFileHierarchyReplacements(result2, BasePathMacroManager.getLocalFileSystem().findFileByPath(path), '$' + macroName + '$');
        }
    }

    private static void addFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result2, @Nullable VirtualFile f2, @NotNull String macro2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/components/impl/BasePathMacroManager", "addFileHierarchyReplacements"));
        }
        if (macro2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macro", "com/intellij/openapi/components/impl/BasePathMacroManager", "addFileHierarchyReplacements"));
        }
        if (f2 == null) {
            return;
        }
        BasePathMacroManager.addFileHierarchyReplacements(result2, f2.getParent(), macro2 + "/..");
        result2.put(macro2, StringUtil.trimEnd((String)f2.getPath(), (String)"/"));
    }

    protected static void addFileHierarchyReplacements(ReplacePathToMacroMap result2, String macroName, @Nullable String path, @Nullable String stopAt) {
        if (path == null) {
            return;
        }
        String macro2 = '$' + macroName + '$';
        path = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)path), (String)"/");
        boolean overwrite = true;
        while (StringUtil.isNotEmpty((String)path) && path.contains("/")) {
            result2.addReplacement(path, macro2, overwrite);
            if (path.equals(stopAt)) break;
            macro2 = macro2 + "/..";
            overwrite = false;
            path = StringUtil.getPackageName((String)path, (char)'/');
        }
    }

    @NotNull
    private static VirtualFileSystem getLocalFileSystem() {
        VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager", "getLocalFileSystem"));
        }
        return virtualFileSystem;
    }

    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result2 = new ExpandMacroToPathMap();
        this.getPathMacros().addMacroExpands(result2);
        for (Map.Entry<String, String> entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result2.addMacroExpand(entry.getKey(), entry.getValue());
        }
        ExpandMacroToPathMap expandMacroToPathMap = result2;
        if (expandMacroToPathMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager", "getExpandMacroMap"));
        }
        return expandMacroToPathMap;
    }

    @NotNull
    protected ReplacePathToMacroMap getReplacePathMap() {
        ReplacePathToMacroMap result2 = new ReplacePathToMacroMap();
        this.getPathMacros().addMacroReplacements(result2);
        for (Map.Entry<String, String> entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result2.addMacroReplacement(entry.getValue(), entry.getKey());
        }
        ReplacePathToMacroMap replacePathToMacroMap = result2;
        if (replacePathToMacroMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager", "getReplacePathMap"));
        }
        return replacePathToMacroMap;
    }

    @Override
    @NotNull
    public TrackingPathMacroSubstitutor createTrackingSubstitutor() {
        TrackingPathMacroSubstitutorImpl trackingPathMacroSubstitutorImpl = new TrackingPathMacroSubstitutorImpl(this);
        if (trackingPathMacroSubstitutorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager", "createTrackingSubstitutor"));
        }
        return trackingPathMacroSubstitutorImpl;
    }

    @Override
    @Contract(value="null -> null; !null -> !null")
    public String expandPath(@Nullable String text2) {
        if (StringUtil.isEmpty((String)text2)) {
            return text2;
        }
        return this.getExpandMacroMap().substitute(text2, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public String collapsePath(@Nullable String text2, boolean recursively) {
        if (StringUtil.isEmpty((String)text2)) {
            return text2;
        }
        return this.getReplacePathMap().substitute(text2, SystemInfo.isFileSystemCaseSensitive, recursively);
    }

    @Override
    public void expandPaths(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/BasePathMacroManager", "expandPaths"));
        }
        this.getExpandMacroMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void collapsePaths(@NotNull Element element, boolean recursively) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/BasePathMacroManager", "collapsePaths"));
        }
        this.getReplacePathMap().substitute(element, SystemInfo.isFileSystemCaseSensitive, recursively, Holder.FILTER);
    }

    @NotNull
    private PathMacrosImpl getPathMacros() {
        if (this.myPathMacros == null) {
            this.myPathMacros = PathMacrosImpl.getInstanceEx();
        }
        PathMacrosImpl pathMacrosImpl = this.myPathMacros;
        if (pathMacrosImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager", "getPathMacros"));
        }
        return pathMacrosImpl;
    }

    protected static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        return path1 != null && path2 != null && FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)path1), (String)FileUtil.toSystemIndependentName((String)path2));
    }

    private static class Holder {
        private static final CompositePathMacroFilter FILTER = new CompositePathMacroFilter((PathMacroFilter[])Extensions.getExtensions(PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME));

        private Holder() {
        }
    }
}

