/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public class CachingComponentAdapter
extends DecoratingComponentAdapter {
    private volatile Object cached;
    private boolean disposed = false;
    private boolean started = false;
    private final boolean delegateHasLifecylce;
    private final Object lock = new Object();

    public CachingComponentAdapter(ComponentAdapter delegate2) {
        super(delegate2);
        this.delegateHasLifecylce = delegate2 instanceof LifecycleStrategy && ((LifecycleStrategy)delegate2).hasLifecycle(delegate2.getComponentImplementation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object o2 = this.cached;
        if (o2 != null) {
            return o2;
        }
        Object object = this.lock;
        synchronized (object) {
            o2 = this.cached;
            if (o2 != null) {
                return o2;
            }
            this.cached = o2 = super.getComponentInstance(container);
        }
        return o2;
    }

    public void start(PicoContainer container) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            if (this.started) {
                throw new IllegalStateException("Already started");
            }
            this.start(this.getComponentInstance(container));
            this.started = true;
        }
    }

    public void stop(PicoContainer container) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            if (!this.started) {
                throw new IllegalStateException("Not started");
            }
            this.stop(this.getComponentInstance(container));
            this.started = false;
        }
    }

    public void dispose(PicoContainer container) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            this.dispose(this.getComponentInstance(container));
            this.disposed = true;
        }
    }

    public boolean hasLifecycle() {
        return this.delegateHasLifecylce;
    }
}

