/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

public class MergeFilesAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e2) {
        DataContext context2 = e2.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(context2);
        if (project2 == null) {
            e2.getPresentation().setEnabled(false);
            return;
        }
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context2);
        if (files2 == null || files2.length != 3) {
            e2.getPresentation().setEnabled(false);
        }
    }

    public void actionPerformed(AnActionEvent e2) {
        DataContext context2 = e2.getDataContext();
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context2);
        if (files2 == null || files2.length != 3) {
            return;
        }
        DiffRequestFactory diffRequestFactory = DiffRequestFactory.getInstance();
        try {
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(context2);
            String title = DiffBundle.message((String)"merge.files.dialog.title", (Object[])new Object[0]);
            List titles = ContainerUtil.list((Object[])new String[]{files2[0].getPresentableUrl(), files2[1].getPresentableUrl(), files2[2].getPresentableUrl()});
            VirtualFile outputFile = files2[1];
            List contents = ContainerUtil.list((Object[])new VirtualFile[]{files2[0], files2[1], files2[2]});
            MergeRequest request2 = diffRequestFactory.createMergeRequestFromFiles(project2, outputFile, contents, title, titles, null);
            request2.putUserData(DiffUserDataKeys.HELP_ID, (Object)"cvs.merge");
            DiffManager.getInstance().showMerge(project2, request2);
        }
        catch (InvalidDiffRequestException err) {
            Messages.showErrorDialog((String)err.getLocalizedMessage(), (String)DiffBundle.message((String)"merge.files.dialog.title", (Object[])new Object[0]));
        }
    }
}

