/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.ex;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class DiffStatusBar
extends JPanel {
    private final JLabel myTextLabel = new JLabel("");
    private EditorColorsScheme myColorScheme = null;

    public <T extends LegendTypeDescriptor> DiffStatusBar(List<T> types) {
        super((LayoutManager)new HorizontalLayout(10));
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        this.add("LEFT", this.myTextLabel);
        for (LegendTypeDescriptor type : types) {
            this.add("CENTER", new LegendTypeLabel(type));
        }
    }

    public void setText(String text2) {
        this.myTextLabel.setText(text2);
    }

    public void setColorScheme(EditorColorsScheme colorScheme) {
        EditorColorsScheme oldScheme = this.myColorScheme;
        this.myColorScheme = colorScheme;
        if (oldScheme != colorScheme) {
            this.repaint();
        }
    }

    private final class LegendTypeLabel
    extends JLabel
    implements Icon {
        private final LegendTypeDescriptor myType;

        public LegendTypeLabel(LegendTypeDescriptor type) {
            super(type.getDisplayName(), 2);
            this.myType = type;
            this.setIconTextGap(5);
            this.setIcon(this);
        }

        @Override
        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            GraphicsUtil.setupAntialiasing((Graphics)g2);
            g2.setColor(this.myType.getLegendColor(DiffStatusBar.this.myColorScheme != null ? DiffStatusBar.this.myColorScheme : EditorColorsManager.getInstance().getGlobalScheme()));
            g2.fill3DRect(x2, y2, this.getIconWidth(), this.getIconHeight(), true);
        }

        @Override
        public int getIconWidth() {
            return 35;
        }

        @Override
        public int getIconHeight() {
            Font font = this.getFont();
            return font != null ? font.getSize() - 2 : 10;
        }
    }

    public static interface LegendTypeDescriptor {
        public String getDisplayName();

        @Nullable
        public Color getLegendColor(EditorColorsScheme var1);
    }
}

