/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.DiffViewerType;
import com.intellij.openapi.diff.impl.ErrorDiffViewer;
import com.intellij.openapi.diff.impl.external.DiscloseMultiRequest;
import com.intellij.openapi.diff.impl.external.MultiLevelDiffTool;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.content.Content;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeDiffPanel
implements DiffViewer {
    private static final String FICTIVE_KEY = "FICTIVE_KEY";
    private static final int ourBadHackMagicContentsNumber = 101;
    private final RunnerLayoutUi myUi;
    private final DiscloseMultiRequest myRequest;
    private final Window myWindow;
    private final Disposable myParentDisposable;
    private final Map<String, Pair<DiffViewer, Content>> myMap;

    public CompositeDiffPanel(Project project2, DiscloseMultiRequest request2, Window window, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/CompositeDiffPanel", "<init>"));
        }
        this.myRequest = request2;
        this.myWindow = window;
        this.myParentDisposable = parentDisposable;
        this.myUi = RunnerLayoutUi.Factory.getInstance((Project)project2).create("Diff", "Diff", "Diff", parentDisposable);
        this.myUi.getComponent().setBorder(null);
        this.myUi.getOptions().setMinimizeActionEnabled(false);
        this.myMap = new HashMap<String, Pair<DiffViewer, Content>>();
    }

    public boolean canShowRequest(DiffRequest request2) {
        return MultiLevelDiffTool.canShowRequest(request2);
    }

    public void setDiffRequest(DiffRequest request2) {
        Map<String, DiffRequest> requestMap = this.myRequest.discloseRequest(request2);
        HashMap<String, Pair<DiffViewer, Content>> mapCopy = new HashMap<String, Pair<DiffViewer, Content>>(this.myMap);
        this.myMap.clear();
        for (Map.Entry<String, DiffRequest> entry : requestMap.entrySet()) {
            DiffViewer viewer;
            String key = entry.getKey();
            DiffRequest diffRequest = entry.getValue();
            diffRequest.getGenericData().put(PlatformDataKeys.COMPOSITE_DIFF_VIEWER.getName(), this);
            Pair<DiffViewer, Content> pair = mapCopy.get(key);
            DiffViewer diffViewer = viewer = pair != null ? (DiffViewer)pair.first : null;
            if (viewer != null && viewer.acceptsType(diffRequest.getType()) && viewer.canShowRequest(diffRequest)) {
                viewer.setDiffRequest(diffRequest);
                this.myMap.put(key, pair);
                mapCopy.remove(key);
                continue;
            }
            DiffViewer newViewer = this.myRequest.viewerForRequest(this.myWindow, this.myParentDisposable, key, diffRequest);
            if (newViewer == null) continue;
            Content content2 = this.myUi.createContent(key, newViewer.getComponent(), key, null, newViewer.getPreferredFocusedComponent());
            content2.setCloseable(false);
            content2.setPinned(true);
            content2.setDisposer(this.myParentDisposable);
            this.myUi.addContent(content2);
            this.myMap.put(key, (Pair<DiffViewer, Content>)Pair.create((Object)newViewer, (Object)content2));
            if (pair == null) continue;
            this.myUi.removeContent((Content)pair.second, false);
        }
        if (this.myMap.isEmpty()) {
            ErrorDiffViewer errorDiffViewer = new ErrorDiffViewer(this.myWindow, request2);
            Content content2 = this.myUi.createContent(FICTIVE_KEY, errorDiffViewer.getComponent(), FICTIVE_KEY, null, errorDiffViewer.getPreferredFocusedComponent());
            content2.setCloseable(false);
            content2.setPinned(true);
            content2.setDisposer(this.myParentDisposable);
            this.myUi.addContent(content2);
            this.myMap.put(FICTIVE_KEY, (Pair<DiffViewer, Content>)Pair.create((Object)errorDiffViewer, (Object)content2));
        }
        for (Pair pair : mapCopy.values()) {
            this.myUi.removeContent((Content)pair.second, false);
            if (!(pair.first instanceof Disposable)) continue;
            Disposer.dispose((Disposable)((Disposable)pair.first));
        }
    }

    public JComponent getComponent() {
        return this.myUi.getComponent();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        Content[] contents = this.myUi.getContents();
        if (contents == null || contents.length == 0) {
            return null;
        }
        return contents[0].getPreferredFocusableComponent();
    }

    public int getContentsNumber() {
        return 101;
    }

    public boolean acceptsType(DiffViewerType type) {
        return DiffViewerType.multiLayer.equals((Object)type) || DiffViewerType.contents.equals((Object)type) || DiffViewerType.merge.equals((Object)type);
    }
}

