/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class DiffLineMarkerRenderer
implements LineMarkerRendererEx {
    @NotNull
    private final TextDiffType myDiffType;

    @NotNull
    public static DiffLineMarkerRenderer createInstance(@NotNull TextDiffType diffType) {
        if (diffType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffType", "com/intellij/openapi/diff/impl/DiffLineMarkerRenderer", "createInstance"));
        }
        DiffLineMarkerRenderer diffLineMarkerRenderer = new DiffLineMarkerRenderer(diffType);
        if (diffLineMarkerRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/DiffLineMarkerRenderer", "createInstance"));
        }
        return diffLineMarkerRenderer;
    }

    private DiffLineMarkerRenderer(@NotNull TextDiffType diffType) {
        if (diffType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffType", "com/intellij/openapi/diff/impl/DiffLineMarkerRenderer", "<init>"));
        }
        this.myDiffType = diffType;
    }

    public void paint(Editor editor, Graphics g2, Rectangle range) {
        Color color = this.myDiffType.getPolygonColor(editor);
        if (color == null) {
            return;
        }
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        Graphics2D g22 = (Graphics2D)g2;
        int x2 = 0;
        int y2 = range.y;
        int width = gutter.getWidth();
        int height = range.height;
        if (!this.myDiffType.isApplied()) {
            if (height > 2) {
                g2.setColor(color);
                g2.fillRect(x2, y2, width, height);
                DiffUtil.drawDoubleShadowedLine(g22, x2, x2 + width, y2 - 1, color);
                DiffUtil.drawDoubleShadowedLine(g22, x2, x2 + width, y2 + height - 1, color);
            } else {
                DiffUtil.drawDoubleShadowedLine(g22, x2, x2 + width, y2 - 1, color);
            }
        } else {
            DiffUtil.drawBoldDottedFramingLines(g22, x2, x2 + width, y2 - 1, y2 + height - 1, color);
        }
    }

    @Override
    public LineMarkerRendererEx.Position getPosition() {
        return LineMarkerRendererEx.Position.CUSTOM;
    }
}

