/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.impl.CurrentLineMarker;
import com.intellij.openapi.diff.impl.DiffHighlighterFactory;
import com.intellij.openapi.diff.impl.DiffHighlighterFactoryImpl;
import com.intellij.openapi.diff.impl.DiffSidesContainer;
import com.intellij.openapi.diff.impl.EditorSource;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.util.LabeledEditor;
import com.intellij.openapi.diff.impl.util.SyncScrollSupport;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionAdapter;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.ScrollUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffSideView {
    private final JComponent MOCK_COMPONENT = new JPanel();
    private static final DiffHighlighterFactory DUMMY_HIGHLIGHTER_FACTORY = new DiffHighlighterFactoryImpl(null, null, null);
    private final LabeledEditor myPanel;
    private final DiffSidesContainer myContainer;
    private final CurrentLineMarker myLineMarker;
    private DiffHighlighterFactory myHighlighterFactory;
    private EditorSource myEditorSource;
    private boolean myIsMaster;
    private JComponent myTitle;

    public DiffSideView(DiffSidesContainer container, @Nullable Border editorBorder) {
        this.MOCK_COMPONENT.setFocusable(true);
        this.myLineMarker = new CurrentLineMarker();
        this.myHighlighterFactory = DUMMY_HIGHLIGHTER_FACTORY;
        this.myEditorSource = EditorSource.NULL;
        this.myIsMaster = false;
        this.myTitle = new JLabel();
        this.myContainer = container;
        this.myPanel = new LabeledEditor(editorBorder);
        this.insertComponent(this.MOCK_COMPONENT);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void setEditorSource(final Project project2, EditorSource source) {
        MyState state = new MyState();
        this.myEditorSource = source;
        this.myLineMarker.attach(this.myEditorSource);
        EditorEx editor = this.myEditorSource.getEditor();
        final FileEditor fileEditor = this.myEditorSource.getFileEditor();
        if (editor == null) {
            this.insertComponent(fileEditor == null ? this.MOCK_COMPONENT : fileEditor.getComponent());
            DataManager.registerDataProvider((JComponent)this.myPanel, (DataProvider)new DataProvider(){

                public Object getData(@NonNls String dataId) {
                    if (CommonDataKeys.PROJECT.is(dataId)) {
                        return project2;
                    }
                    if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                        return fileEditor;
                    }
                    return null;
                }
            });
            if (fileEditor != null) {
                ScrollUtil.scrollVertically((JComponent)fileEditor.getComponent(), (int)0);
                ScrollUtil.scrollHorizontally((JComponent)fileEditor.getComponent(), (int)0);
                UIUtil.removeScrollBorder((Component)fileEditor.getComponent());
            }
        } else {
            DataManager.removeDataProvider((JComponent)this.myPanel);
            editor.getScrollingModel().scrollHorizontally(0);
            this.insertComponent(editor.getComponent());
            this.applyHighlighter();
            this.setMouseListeners(source);
            MyEditorFocusListener.install(this);
            UIUtil.removeScrollBorder((Component)editor.getComponent());
            state.restore();
        }
    }

    private void insertComponent(JComponent component) {
        this.myPanel.setComponent(component, this.myTitle);
    }

    public void setHighlighterFactory(DiffHighlighterFactory highlighterFactory) {
        this.myHighlighterFactory = highlighterFactory;
        this.applyHighlighter();
    }

    private void applyHighlighter() {
        EditorEx editor = this.myEditorSource.getEditor();
        if (editor == null) {
            return;
        }
        EditorHighlighter highlighter2 = this.myHighlighterFactory.createHighlighter();
        if (highlighter2 != null) {
            editor.setHighlighter(highlighter2);
        }
        editor.getSettings().setCaretRowShown(false);
    }

    public void setTitle(@NotNull JComponent title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/diff/impl/DiffSideView", "setTitle"));
        }
        this.myTitle = title;
        this.myPanel.updateTitle(this.myTitle);
    }

    private void setMouseListeners(EditorSource source) {
        DiffContent content2 = source.getContent();
        MouseLineNumberListener.install(content2, source, this.myContainer);
    }

    public void beSlave() {
        this.myIsMaster = false;
        this.myLineMarker.hide();
    }

    @Nullable
    public OpenFileDescriptor getCurrentOpenFileDescriptor() {
        EditorEx editor = this.myEditorSource.getEditor();
        DiffContent content2 = this.myEditorSource.getContent();
        if (content2 == null || editor == null) {
            return null;
        }
        return content2.getOpenFileDescriptor(editor.getCaretModel().getOffset());
    }

    public JComponent getFocusableComponent() {
        Editor editor = this.getEditor();
        if (editor != null) {
            return editor.getContentComponent();
        }
        FileEditor fileEditor = this.myEditorSource.getFileEditor();
        if (fileEditor != null) {
            return fileEditor.getComponent();
        }
        return this.MOCK_COMPONENT;
    }

    public void becomeMaster() {
        if (this.myIsMaster) {
            return;
        }
        this.myIsMaster = true;
        this.myContainer.setCurrentSide(this);
        this.beMaster();
    }

    private void beMaster() {
        this.myLineMarker.set();
    }

    public void scrollToFirstDiff(int logicalLine) {
        EditorEx editor = this.myEditorSource.getEditor();
        SyncScrollSupport.scrollEditor(editor, logicalLine);
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditorSource.getEditor();
    }

    @Nullable
    public FragmentSide getSide() {
        return this.myEditorSource.getSide();
    }

    private class MyState {
        private final boolean isFocused;

        public MyState() {
            this.isFocused = IJSwingUtilities.hasFocus(DiffSideView.this.getFocusableComponent());
        }

        public void restore() {
            if (this.isFocused) {
                DiffSideView.this.getFocusableComponent().requestFocus();
            }
            if (DiffSideView.this.myIsMaster) {
                DiffSideView.this.beMaster();
            }
        }
    }

    private static class MyEditorFocusListener
    extends FocusAdapter {
        private final DiffSideView mySideView;

        private MyEditorFocusListener(DiffSideView sideView) {
            this.mySideView = sideView;
        }

        @Override
        public void focusGained(FocusEvent e2) {
            this.mySideView.becomeMaster();
        }

        public static MyEditorFocusListener install(DiffSideView sideView) {
            final MyEditorFocusListener listener2 = new MyEditorFocusListener(sideView);
            final JComponent focusableComponent = sideView.getFocusableComponent();
            focusableComponent.addFocusListener(listener2);
            sideView.myEditorSource.addDisposable(new Disposable(){

                public void dispose() {
                    focusableComponent.removeFocusListener(listener2);
                }
            });
            return listener2;
        }
    }

    private static class MouseLineNumberListener {
        private static final Cursor HAND__CURSOR = Cursor.getPredefinedCursor(12);
        private final Editor myEditor;
        private final DiffSidesContainer myContainer;
        private final DiffContent myContent;
        private final Project myProject;
        private final EditorMouseAdapter myMouseListener = new EditorMouseAdapter(){

            public void mouseReleased(EditorMouseEvent e2) {
                if (!MouseLineNumberListener.isEventHandled(e2.getMouseEvent()) || !MouseLineNumberListener.isInMyArea(e2)) {
                    return;
                }
                OpenFileDescriptor descriptor2 = this.getOpenFileDescriptor(e2);
                if (descriptor2 == null) {
                    return;
                }
                myContainer.showSource(descriptor2);
            }
        };
        private final EditorMouseMotionAdapter myMouseMotionListener = new EditorMouseMotionAdapter(){

            public void mouseMoved(EditorMouseEvent e2) {
                Editor editor = e2.getEditor();
                if (editor.getProject() != null && editor.getProject() != myProject && myProject != null) {
                    return;
                }
                if (!MouseLineNumberListener.isInMyArea(e2)) {
                    return;
                }
                Cursor cursor = this.getOpenFileDescriptor(e2) != null ? HAND__CURSOR : Cursor.getDefaultCursor();
                e2.getMouseEvent().getComponent().setCursor(cursor);
                myEditor.getContentComponent().setCursor(cursor);
            }
        };

        private static boolean isEventHandled(MouseEvent e2) {
            Shortcut[] shortcuts;
            Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
            for (Shortcut shortcut : shortcuts = activeKeymap.getShortcuts("GotoDeclaration")) {
                if (!(shortcut instanceof MouseShortcut)) continue;
                return ((MouseShortcut)shortcut).getButton() == e2.getButton() && ((MouseShortcut)shortcut).getModifiers() == e2.getModifiersEx();
            }
            return false;
        }

        private OpenFileDescriptor getOpenFileDescriptor(EditorMouseEvent e2) {
            int offset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(e2.getMouseEvent().getPoint()));
            return this.myContent.getOpenFileDescriptor(offset);
        }

        private static boolean isInMyArea(EditorMouseEvent e2) {
            return e2.getArea() == EditorMouseEventArea.LINE_NUMBERS_AREA;
        }

        public MouseLineNumberListener(DiffContent content2, Editor editor, DiffSidesContainer container, Project project2) {
            this.myEditor = editor;
            this.myContainer = container;
            this.myContent = content2;
            this.myProject = project2;
        }

        public static void install(DiffContent content2, EditorSource source, DiffSidesContainer container) {
            final EditorEx editor = source.getEditor();
            Project project2 = container.getProject();
            if (project2 == null || editor == null) {
                return;
            }
            final MouseLineNumberListener listener2 = new MouseLineNumberListener(content2, editor, container, project2);
            editor.addEditorMouseListener((EditorMouseListener)listener2.myMouseListener);
            editor.addEditorMouseMotionListener((EditorMouseMotionListener)listener2.myMouseMotionListener);
            source.addDisposable(new Disposable(){

                public void dispose() {
                    editor.removeEditorMouseListener((EditorMouseListener)listener2.myMouseListener);
                    editor.removeEditorMouseMotionListener((EditorMouseMotionListener)listener2.myMouseMotionListener);
                }
            });
        }
    }
}

