/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir.actions;

import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffModelHolder;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.actions.ChangeCompareModeGroup;
import com.intellij.openapi.diff.impl.dir.actions.EnableEqual;
import com.intellij.openapi.diff.impl.dir.actions.EnableLeft;
import com.intellij.openapi.diff.impl.dir.actions.EnableNotEqual;
import com.intellij.openapi.diff.impl.dir.actions.EnableRight;
import com.intellij.openapi.diff.impl.dir.actions.RefreshDirDiffAction;
import com.intellij.openapi.diff.impl.dir.actions.SynchronizeDiff;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirDiffToolbarActions
extends ActionGroup {
    private final AnAction[] myActions;

    public DirDiffToolbarActions(DirDiffTableModel model2, JComponent panel2) {
        super("Directory Diff Actions", false);
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>(Arrays.asList(new AnAction[]{new RefreshDirDiffAction(model2), Separator.getInstance(), new EnableLeft(model2), new EnableNotEqual(model2), new EnableEqual(model2), new EnableRight(model2), Separator.getInstance(), new ChangeCompareModeGroup(model2), Separator.getInstance()}));
        if (model2.isOperationsEnabled()) {
            actions2.add((AnAction)new SynchronizeDiff(model2, true));
            actions2.add((AnAction)new SynchronizeDiff(model2, false));
        }
        for (AnAction action2 : model2.getSettings().getExtraActions()) {
            actions2.add(action2);
        }
        for (AnAction action2 : actions2) {
            ShortcutSet shortcut;
            if (action2 instanceof ShortcutProvider && (shortcut = ((ShortcutProvider)action2).getShortcut()) != null) {
                action2.registerCustomShortcutSet(shortcut, panel2);
            }
            if (!(action2 instanceof DirDiffModelHolder)) continue;
            ((DirDiffModelHolder)action2).setModel((DirDiffModel)model2);
        }
        this.myActions = actions2.toArray(new AnAction[actions2.size()]);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e2) {
        if (this.myActions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/dir/actions/DirDiffToolbarActions", "getChildren"));
        }
        return this.myActions;
    }
}

