/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.diff.BackgroundOperatingDiffElement;
import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.actions.DirDiffAction;
import com.intellij.openapi.util.SystemInfo;
import java.util.List;

public class SynchronizeDiff
extends DirDiffAction {
    private final boolean mySelectedOnly;

    public SynchronizeDiff(DirDiffTableModel model2, boolean selectedOnly) {
        super(model2);
        this.getTemplatePresentation().setText(selectedOnly ? "Synchronize Selected" : "Synchronize All");
        this.getTemplatePresentation().setIcon(selectedOnly ? AllIcons.Actions.Resume : AllIcons.Actions.Rerun);
        this.mySelectedOnly = selectedOnly;
    }

    @Override
    public void update(AnActionEvent e2) {
        super.update(e2);
        if (e2.getPresentation().isEnabled() && (this.getModel().getSourceDir() instanceof BackgroundOperatingDiffElement || this.getModel().getTargetDir() instanceof BackgroundOperatingDiffElement)) {
            List<DirDiffElementImpl> elements = this.mySelectedOnly ? this.getModel().getSelectedElements() : this.getModel().getElements();
            for (DirDiffElementImpl dirDiffElement : elements) {
                if (dirDiffElement.getSource() != null && !dirDiffElement.getSource().isOperationsEnabled() || dirDiffElement.getTarget() != null && !dirDiffElement.getTarget().isOperationsEnabled() || dirDiffElement.getOperation() != DirDiffOperation.COPY_FROM && dirDiffElement.getOperation() != DirDiffOperation.COPY_TO && dirDiffElement.getOperation() != DirDiffOperation.DELETE) continue;
                e2.getPresentation().setEnabled(true);
                return;
            }
            e2.getPresentation().setEnabled(false);
        }
    }

    @Override
    protected void updateState(boolean state) {
        if (this.mySelectedOnly) {
            this.getModel().synchronizeSelected();
        } else {
            this.getModel().synchronizeAll();
        }
    }

    @Override
    public ShortcutSet getShortcut() {
        return CustomShortcutSet.fromString((String[])new String[]{this.mySelectedOnly ? "ENTER" : (SystemInfo.isMac ? "meta ENTER" : "control ENTER")});
    }

    public boolean isSelected(AnActionEvent e2) {
        return false;
    }

    @Override
    protected boolean isFullReload() {
        return false;
    }

    @Override
    protected boolean isReloadNeeded() {
        return false;
    }
}

