/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.external.BaseExternalTool;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.diff.impl.external.LocalFileExternalizer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

class ExtCompareFiles
extends BaseExternalTool {
    public static final BaseExternalTool INSTANCE = new ExtCompareFiles();

    private ExtCompareFiles() {
        super(DiffManagerImpl.ENABLE_FILES, DiffManagerImpl.FILES_TOOL);
    }

    @Override
    public boolean isAvailable(@NotNull DiffRequest request2) {
        DiffContent[] contents;
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/diff/impl/external/ExtCompareFiles", "isAvailable"));
        }
        for (DiffContent content2 : contents = request2.getContents()) {
            VirtualFile file2 = ExtCompareFiles.getLocalFile(content2.getFile());
            if (file2 != null && file2.isDirectory()) {
                return false;
            }
            if (LocalFileExternalizer.canExternalizeAsFile(file2) || !DiffUtil.isWritable(content2)) continue;
            return false;
        }
        if (contents.length != 2) {
            return false;
        }
        if (this.externalize(request2, 0) == null) {
            return false;
        }
        return this.externalize(request2, 1) != null;
    }
}

