/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffPanel;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameDiffTool
implements DiffTool {
    public void show(DiffRequest request2) {
        Collection hints = request2.getHints();
        boolean shouldOpenDialog = FrameDiffTool.shouldOpenDialog(hints);
        if (shouldOpenDialog) {
            final DialogBuilder builder = new DialogBuilder(request2.getProject());
            DiffPanelImpl diffPanel = this.createDiffPanelIfShouldShow(request2, builder.getWindow(), (Disposable)builder, true);
            if (diffPanel == null) {
                Disposer.dispose((Disposable)builder);
                return;
            }
            Runnable onOkRunnable = request2.getOnOkRunnable();
            if (onOkRunnable != null) {
                builder.setOkOperation(() -> {
                    builder.getDialogWrapper().close(0);
                    onOkRunnable.run();
                });
            } else {
                builder.removeAllActions();
            }
            builder.setCenterPanel(diffPanel.getComponent());
            builder.setPreferredFocusComponent(diffPanel.getPreferredFocusedComponent());
            builder.setTitle(request2.getWindowTitle());
            builder.setDimensionServiceKey(request2.getGroupKey());
            new AnAction(){

                public void actionPerformed(AnActionEvent e2) {
                    builder.getDialogWrapper().close(0);
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("CloseContent")), diffPanel.getComponent());
            FrameDiffTool.showDiffDialog(builder, hints);
        } else {
            final FrameWrapper frameWrapper = new FrameWrapper(request2.getProject(), request2.getGroupKey());
            DiffPanelImpl diffPanel = this.createDiffPanelIfShouldShow(request2, frameWrapper.getFrame(), frameWrapper, true);
            if (diffPanel == null) {
                Disposer.dispose((Disposable)frameWrapper);
                return;
            }
            frameWrapper.setTitle(request2.getWindowTitle());
            DiffUtil.initDiffFrame(diffPanel.getProject(), frameWrapper, (DiffViewer)diffPanel, diffPanel.getComponent());
            new AnAction(){

                public void actionPerformed(AnActionEvent e2) {
                    frameWrapper.getFrame().dispose();
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("CloseContent")), diffPanel.getComponent());
            frameWrapper.show();
        }
    }

    @Nullable
    private DiffPanelImpl createDiffPanelIfShouldShow(DiffRequest request2, Window window, @NotNull Disposable parentDisposable, boolean showMessage) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/external/FrameDiffTool", "createDiffPanelIfShouldShow"));
        }
        DiffPanelImpl diffPanel = this.createDiffPanelImpl(request2, window, parentDisposable);
        if (this.checkNoDifferenceAndNotify(diffPanel, request2, window, showMessage)) {
            Disposer.dispose((Disposable)diffPanel);
            diffPanel = null;
        }
        return diffPanel;
    }

    protected DiffPanelImpl createDiffPanelImpl(@NotNull DiffRequest request2, @Nullable Window window, @NotNull Disposable parentDisposable) {
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/diff/impl/external/FrameDiffTool", "createDiffPanelImpl"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/external/FrameDiffTool", "createDiffPanelImpl"));
        }
        DiffPanelImpl panel2 = (DiffPanelImpl)DiffManagerImpl.createDiffPanel(request2, window, parentDisposable, this);
        if (request2.getHints().contains(DiffTool.HINT_DIFF_IS_APPROXIMATE)) {
            panel2.setPatchAppliedApproximately();
        }
        return panel2;
    }

    static void showDiffDialog(DialogBuilder builder, Collection hints) {
        builder.showModal(!hints.contains(DiffTool.HINT_SHOW_NOT_MODAL_DIALOG));
    }

    public static boolean shouldOpenDialog(Collection hints) {
        if (hints.contains(DiffTool.HINT_SHOW_MODAL_DIALOG)) {
            return true;
        }
        if (hints.contains(DiffTool.HINT_SHOW_NOT_MODAL_DIALOG)) {
            return true;
        }
        if (hints.contains(DiffTool.HINT_SHOW_FRAME)) {
            return false;
        }
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() instanceof JDialog;
    }

    private boolean checkNoDifferenceAndNotify(DiffPanel diffPanel, DiffRequest data, Window window, boolean showMessage) {
        if (diffPanel.hasDifferences() || data.getHints().contains(HINT_ALLOW_NO_DIFFERENCES)) {
            return false;
        }
        DiffManagerImpl manager = (DiffManagerImpl)DiffManager.getInstance();
        ComparisonPolicy oldPolicy = manager.getComparisonPolicy();
        if (oldPolicy != ComparisonPolicy.DEFAULT) {
            manager.setComparisonPolicy(ComparisonPolicy.DEFAULT);
            Disposable parentDisposable = Disposer.newDisposable();
            DiffPanel maybeDiffPanel = DiffManagerImpl.createDiffPanel(data, window, parentDisposable, this);
            manager.setComparisonPolicy(oldPolicy);
            boolean hasDiffs = maybeDiffPanel.hasDifferences();
            Disposer.dispose((Disposable)parentDisposable);
            if (hasDiffs) {
                return false;
            }
        }
        return !showMessage || !FrameDiffTool.askForceOpenDiff(data);
    }

    private static boolean askForceOpenDiff(DiffRequest data) {
        byte[] bytes2;
        byte[] bytes1;
        try {
            bytes1 = data.getContents()[0].getBytes();
            bytes2 = data.getContents()[1].getBytes();
        }
        catch (IOException e2) {
            MessagesEx.error(data.getProject(), e2.getMessage()).showNow();
            return false;
        }
        String message2 = Arrays.equals(bytes1, bytes2) ? DiffBundle.message((String)"diff.contents.are.identical.message.text", (Object[])new Object[0]) : DiffBundle.message((String)"diff.contents.have.differences.only.in.line.separators.message.text", (Object[])new Object[0]);
        return Messages.showYesNoDialog((Project)data.getProject(), (String)(message2 + "\n" + DiffBundle.message((String)"show.diff.anyway.dialog.message", (Object[])new Object[0])), (String)DiffBundle.message((String)"no.differences.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    public boolean canShow(DiffRequest data) {
        return FrameDiffTool.canShowDiff(data);
    }

    public static boolean canShowDiff(DiffRequest data) {
        DiffContent[] contents = data.getContents();
        if (contents.length != 2) {
            return false;
        }
        for (DiffContent content2 : contents) {
            if (content2.isBinary()) {
                return false;
            }
            VirtualFile file2 = content2.getFile();
            if (file2 == null || !file2.isDirectory()) continue;
            return false;
        }
        return true;
    }

    public DiffViewer createComponent(String title, DiffRequest request2, Window window, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/external/FrameDiffTool", "createComponent"));
        }
        return this.createDiffPanelImpl(request2, window, parentDisposable);
    }
}

