/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.DiffViewerType;
import com.intellij.openapi.diff.impl.CompositeDiffPanel;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.diff.impl.external.DiscloseMultiRequest;
import com.intellij.openapi.diff.impl.external.FrameDiffTool;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.config.AbstractProperty;
import java.awt.Window;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class MultiLevelDiffTool
implements DiffTool,
DiscloseMultiRequest {
    public static final String ourDefaultTab = "Contents";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.external.MultiLevelDiffTool");
    private final List<DiffTool> myTools;

    public MultiLevelDiffTool(List<DiffTool> tools) {
        this.myTools = tools;
    }

    public void show(DiffRequest request2) {
        Collection hints = request2.getHints();
        boolean shouldOpenDialog = FrameDiffTool.shouldOpenDialog(hints);
        if (shouldOpenDialog) {
            final DialogBuilder builder = new DialogBuilder(request2.getProject());
            CompositeDiffPanel diffPanel = this.createPanel(request2, builder.getWindow(), (Disposable)builder);
            if (diffPanel == null) {
                Disposer.dispose((Disposable)builder);
                return;
            }
            Runnable onOkRunnable = request2.getOnOkRunnable();
            if (onOkRunnable != null) {
                builder.setOkOperation(() -> {
                    builder.getDialogWrapper().close(0);
                    onOkRunnable.run();
                });
            } else {
                builder.removeAllActions();
            }
            builder.setCenterPanel(diffPanel.getComponent());
            builder.setPreferredFocusComponent(diffPanel.getPreferredFocusedComponent());
            builder.setTitle(request2.getWindowTitle());
            builder.setDimensionServiceKey(request2.getGroupKey());
            new AnAction(){

                public void actionPerformed(AnActionEvent e2) {
                    builder.getDialogWrapper().close(0);
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("CloseContent")), diffPanel.getComponent());
            diffPanel.setDiffRequest(request2);
            FrameDiffTool.showDiffDialog(builder, hints);
        } else {
            final FrameWrapper frameWrapper = new FrameWrapper(request2.getProject(), request2.getGroupKey());
            CompositeDiffPanel diffPanel = this.createPanel(request2, frameWrapper.getFrame(), frameWrapper);
            if (diffPanel == null) {
                Disposer.dispose((Disposable)frameWrapper);
                return;
            }
            frameWrapper.setTitle(request2.getWindowTitle());
            diffPanel.setDiffRequest(request2);
            DiffUtil.initDiffFrame(request2.getProject(), frameWrapper, diffPanel, diffPanel.getComponent());
            new AnAction(){

                public void actionPerformed(AnActionEvent e2) {
                    Disposer.dispose((Disposable)frameWrapper);
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("CloseContent")), diffPanel.getComponent());
            frameWrapper.show();
        }
    }

    private CompositeDiffPanel createPanel(final DiffRequest request2, Window window, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/external/MultiLevelDiffTool", "createPanel"));
        }
        CompositeDiffPanel panel2 = new CompositeDiffPanel(request2.getProject(), this, window, parentDisposable);
        request2.getGenericData().put(PlatformDataKeys.COMPOSITE_DIFF_VIEWER.getName(), panel2);
        final List layers = request2.getOtherLayers();
        if (layers != null) {
            for (Pair layer : layers) {
                ((DiffRequest)layer.getSecond()).getGenericData().put(PlatformDataKeys.COMPOSITE_DIFF_VIEWER.getName(), panel2);
            }
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                String name = PlatformDataKeys.COMPOSITE_DIFF_VIEWER.getName();
                request2.getGenericData().remove(name);
                if (layers != null) {
                    for (Pair layer : layers) {
                        ((DiffRequest)layer.getSecond()).getGenericData().remove(name);
                    }
                }
            }
        });
        return panel2;
    }

    @Override
    public DiffViewer viewerForRequest(Window window, @NotNull Disposable parentDisposable, String name, DiffRequest current) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/external/MultiLevelDiffTool", "viewerForRequest"));
        }
        DiffViewer viewer = null;
        for (DiffTool tool : this.myTools) {
            if (tool.canShow(current) && (viewer = tool.createComponent(name, current, window, parentDisposable)) != null) break;
        }
        return viewer;
    }

    @Override
    public Map<String, DiffRequest> discloseRequest(DiffRequest request2) {
        TreeMap<String, DiffRequest> pairs = new TreeMap<String, DiffRequest>((o1, o2) -> {
            if (ourDefaultTab.equals(o1)) {
                return -1;
            }
            if (ourDefaultTab.equals(o2)) {
                return 1;
            }
            return Comparing.compare((Comparable)((Object)o1), (Comparable)((Object)o2));
        });
        List layers = request2.getOtherLayers();
        for (Pair layer : layers) {
            pairs.put((String)layer.getFirst(), (DiffRequest)layer.getSecond());
        }
        pairs.put(ourDefaultTab, request2);
        return pairs;
    }

    public boolean canShow(DiffRequest request2) {
        return MultiLevelDiffTool.canShowRequest(request2);
    }

    public static boolean canShowRequest(DiffRequest request2) {
        boolean isFile = false;
        DiffContent[] contents = request2.getContents();
        for (int i2 = 0; i2 < contents.length; ++i2) {
            DiffContent content2 = contents[i2];
            VirtualFile file2 = content2.getFile();
            if (file2 == null || !file2.isInLocalFileSystem() || file2.isDirectory()) continue;
            isFile = true;
            break;
        }
        AbstractProperty.AbstractPropertyContainer config = DiffManagerImpl.getInstanceEx().getProperties();
        if (isFile && DiffManagerImpl.ENABLE_FILES.value(config)) {
            return false;
        }
        if (!isFile && DiffManagerImpl.ENABLE_FOLDERS.value(config)) {
            return false;
        }
        return !DiffViewerType.merge.equals((Object)request2.getType()) || !MultiLevelDiffTool.contentsWriteable(request2);
    }

    private static boolean contentsWriteable(DiffRequest request2) {
        DiffContent[] contents;
        for (DiffContent content2 : contents = request2.getContents()) {
            if (content2 == null || !content2.getDocument().isWritable()) continue;
            return true;
        }
        return false;
    }

    public DiffViewer createComponent(String title, DiffRequest request2, Window window, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/external/MultiLevelDiffTool", "createComponent"));
        }
        throw new IllegalStateException();
    }
}

