/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeHighlighterHolder;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeSide;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeType {
    private static final int LAYER = 5999;
    private static final ChangeType INSERT = new ChangeType(TextDiffType.INSERT, false);
    private static final ChangeType DELETED = new ChangeType(TextDiffType.DELETED, false);
    private static final ChangeType CHANGE = new ChangeType(TextDiffType.CHANGED, false);
    static final ChangeType CONFLICT = new ChangeType(TextDiffType.CONFLICT, false);
    private final TextDiffType myDiffType;
    private final boolean myApplied;

    private ChangeType(TextDiffType diffType, boolean applied) {
        this.myApplied = applied;
        this.myDiffType = applied ? TextDiffType.deriveApplied(diffType) : diffType;
    }

    public boolean isApplied() {
        return this.myApplied;
    }

    @NotNull
    public static ChangeType deriveApplied(ChangeType type) {
        ChangeType changeType = new ChangeType(type.myDiffType, true);
        if (changeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ChangeType", "deriveApplied"));
        }
        return changeType;
    }

    @Nullable
    public RangeHighlighter addMarker(ChangeSide changeSide, ChangeHighlighterHolder markup) {
        CharSequence text2 = changeSide.getText();
        if (text2 != null && text2.length() > 0) {
            return this.addBlock(text2, changeSide, markup, this.myDiffType);
        }
        return this.addLine(markup, changeSide.getStartLine(), this.myDiffType, SeparatorPlacement.TOP);
    }

    @NotNull
    public TextDiffType getTypeKey() {
        TextDiffType textDiffType = this.myDiffType;
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ChangeType", "getTypeKey"));
        }
        return textDiffType;
    }

    @NotNull
    public TextDiffType getTextDiffType() {
        TextDiffType textDiffType = this.getTypeKey();
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ChangeType", "getTextDiffType"));
        }
        return textDiffType;
    }

    @Nullable
    private RangeHighlighter addBlock(CharSequence text2, ChangeSide changeSide, final ChangeHighlighterHolder markup, TextDiffType diffType) {
        EditorColorsScheme colorScheme = markup.getEditor().getColorsScheme();
        Color separatorColor = this.getSeparatorColor(diffType.getLegendColor(colorScheme));
        int length = text2.length();
        int start2 = changeSide.getStart();
        int end = start2 + length;
        RangeHighlighter highlighter2 = markup.addRangeHighlighter(start2, end, 5999, diffType, HighlighterTargetArea.EXACT_RANGE, this.myApplied);
        LineSeparatorRenderer lineSeparatorRenderer = new LineSeparatorRenderer(){

            public void drawLine(Graphics g2, int x1, int x2, int y2) {
                Graphics2D g22 = (Graphics2D)g2;
                Color color = ChangeType.this.myDiffType.getPolygonColor(markup.getEditor());
                if (color != null) {
                    if (ChangeType.this.myApplied) {
                        Rectangle bounds = g2.getClipBounds();
                        if ((x1 = Math.max(x1, bounds.x)) >= x2) {
                            return;
                        }
                        UIUtil.drawBoldDottedLine((Graphics2D)g22, (int)x1, (int)x2, (int)y2, null, (Color)color, (boolean)false);
                    } else {
                        UIUtil.drawLine((Graphics2D)g22, (int)x1, (int)y2, (int)x2, (int)y2, null, (Color)DiffUtil.getFramingColor(color));
                    }
                }
            }
        };
        if (highlighter2 != null) {
            highlighter2.setLineSeparatorPlacement(SeparatorPlacement.TOP);
            highlighter2.setLineSeparatorColor(separatorColor);
            highlighter2.setLineSeparatorRenderer(lineSeparatorRenderer);
        }
        if (text2.charAt(length - 1) == '\n') {
            --end;
        }
        if ((highlighter2 = markup.addRangeHighlighter(start2, end, 5999, TextDiffType.NONE, HighlighterTargetArea.EXACT_RANGE, this.myApplied)) != null) {
            highlighter2.setLineSeparatorPlacement(SeparatorPlacement.BOTTOM);
            highlighter2.setLineSeparatorColor(separatorColor);
            highlighter2.setLineSeparatorRenderer(lineSeparatorRenderer);
        }
        return highlighter2;
    }

    @Nullable
    private RangeHighlighter addLine(final ChangeHighlighterHolder markup, int line, final TextDiffType type, SeparatorPlacement placement) {
        RangeHighlighter highlighter2 = markup.addLineHighlighter(line, 5999, type, this.myApplied);
        if (highlighter2 == null) {
            return null;
        }
        highlighter2.setLineSeparatorPlacement(placement);
        highlighter2.setLineSeparatorRenderer(new LineSeparatorRenderer(){

            public void drawLine(Graphics g2, int x1, int x2, int y2) {
                Graphics2D g22 = (Graphics2D)g2;
                Color color = ChangeType.this.myDiffType.getPolygonColor(markup.getEditor());
                if (color != null) {
                    if (type.isApplied()) {
                        Rectangle bounds = g2.getClipBounds();
                        if ((x1 = Math.max(x1, bounds.x)) >= x2) {
                            return;
                        }
                        UIUtil.drawBoldDottedLine((Graphics2D)g22, (int)x1, (int)x2, (int)y2, null, (Color)color, (boolean)false);
                    } else {
                        DiffUtil.drawDoubleShadowedLine(g22, x1, x2, y2, color);
                    }
                }
            }
        });
        return highlighter2;
    }

    @NotNull
    static ChangeType fromDiffFragment(DiffFragment fragment) {
        if (fragment.getText1() == null) {
            ChangeType changeType = INSERT;
            if (changeType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ChangeType", "fromDiffFragment"));
            }
            return changeType;
        }
        if (fragment.getText2() == null) {
            ChangeType changeType = DELETED;
            if (changeType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ChangeType", "fromDiffFragment"));
            }
            return changeType;
        }
        ChangeType changeType = CHANGE;
        if (changeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ChangeType", "fromDiffFragment"));
        }
        return changeType;
    }

    @NotNull
    static ChangeType fromRanges(@NotNull TextRange left, @NotNull TextRange right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/openapi/diff/impl/incrementalMerge/ChangeType", "fromRanges"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/openapi/diff/impl/incrementalMerge/ChangeType", "fromRanges"));
        }
        if (left.getLength() == 0) {
            ChangeType changeType = INSERT;
            if (changeType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ChangeType", "fromRanges"));
            }
            return changeType;
        }
        if (right.getLength() == 0) {
            ChangeType changeType = DELETED;
            if (changeType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ChangeType", "fromRanges"));
            }
            return changeType;
        }
        ChangeType changeType = CHANGE;
        if (changeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ChangeType", "fromRanges"));
        }
        return changeType;
    }

    public String toString() {
        return this.myDiffType.getDisplayName();
    }

    @NotNull
    public Color getSeparatorColor(@Nullable Color highlightColor) {
        if (this.myApplied) {
            Color color = highlightColor == null ? Color.DARK_GRAY : highlightColor.darker();
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ChangeType", "getSeparatorColor"));
            }
            return color;
        }
        Color color = Color.GRAY;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ChangeType", "getSeparatorColor"));
        }
        return color;
    }
}

