/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeList;
import com.intellij.openapi.diff.impl.util.DiffPanelOuterComponent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ApplyNonConflicts
extends AnAction
implements DumbAware {
    @Nullable
    private final DiffPanelOuterComponent myDiffPanel;

    public ApplyNonConflicts(@Nullable DiffPanelOuterComponent diffPanel) {
        ActionUtil.copyFrom((AnAction)this, (String)"Diff.ApplyNonConflicts");
        this.myDiffPanel = diffPanel;
    }

    public void actionPerformed(AnActionEvent e2) {
        MergeList mergeList = MergeList.fromDataContext(e2.getDataContext());
        assert (mergeList != null);
        List notConflicts = ContainerUtil.collect(ApplyNonConflicts.getNotConflicts(mergeList));
        Project project2 = mergeList.getLeftChangeList().getProject();
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(project2, () -> {
            mergeList.startBulkUpdate();
            try {
                for (Change change : notConflicts) {
                    Change.doApply(change, MergeList.BRANCH_SIDE);
                }
            }
            finally {
                mergeList.finishBulkUpdate();
            }
        }, null, (Object)DiffBundle.message((String)"save.merge.result.command.name", (Object[])new Object[0])));
        if (this.myDiffPanel != null) {
            this.myDiffPanel.requestScrollEditors();
        }
    }

    public void update(AnActionEvent e2) {
        MergeList mergeList = MergeList.fromDataContext(e2.getDataContext());
        e2.getPresentation().setEnabled(ApplyNonConflicts.getNotConflicts(mergeList).hasNext());
    }

    private static Iterator<Change> getNotConflicts(MergeList mergeList) {
        if (mergeList == null) {
            return new ArrayList(1).iterator();
        }
        return FilteringIterator.create(mergeList.getAllChanges(), MergeList.NOT_CONFLICTS);
    }
}

