/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge.ui;

import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffToolbar;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.DiffViewerType;
import com.intellij.openapi.diff.actions.NextDiffAction;
import com.intellij.openapi.diff.actions.PreviousDiffAction;
import com.intellij.openapi.diff.actions.ToggleAutoScrollAction;
import com.intellij.openapi.diff.impl.DiffHighlighterFactory;
import com.intellij.openapi.diff.impl.DiffHighlighterFactoryImpl;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.EditingSides;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeCounter;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.ApplyNonConflicts;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.EditorPlace;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanelColumn;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.OpenPartialDiffAction;
import com.intellij.openapi.diff.impl.mergeTool.MergeRequestImpl;
import com.intellij.openapi.diff.impl.mergeTool.MergeTool;
import com.intellij.openapi.diff.impl.settings.DiffMergeEditorSetting;
import com.intellij.openapi.diff.impl.settings.DiffMergeSettings;
import com.intellij.openapi.diff.impl.settings.DiffMergeSettingsAction;
import com.intellij.openapi.diff.impl.settings.MergeToolSettings;
import com.intellij.openapi.diff.impl.splitter.DiffDividerPaint;
import com.intellij.openapi.diff.impl.splitter.LineBlocks;
import com.intellij.openapi.diff.impl.util.DiffDivider;
import com.intellij.openapi.diff.impl.util.DiffPanelOuterComponent;
import com.intellij.openapi.diff.impl.util.FocusDiffSide;
import com.intellij.openapi.diff.impl.util.FontSizeSynchronizer;
import com.intellij.openapi.diff.impl.util.SyncScrollSupport;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.diff.impl.util.ThreePanels;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.containers.Convertor;
import gnu.trove.TIntHashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergePanel2
implements DiffViewer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanel2");
    private final DiffPanelOuterComponent myPanel;
    private DiffRequest myData;
    private MergeList myMergeList;
    private boolean myDuringCreation;
    private final SyncScrollSupport myScrollSupport;
    private final DiffDivider[] myDividers;
    private boolean myScrollToFirstDiff;
    private final LabeledComponent[] myEditorsPanels;
    public static final int EDITORS_COUNT = 3;
    private final DividersRepainter myDividersRepainter;
    private StatusUpdater myStatusUpdater;
    private final DialogBuilder myBuilder;
    private final MyDataProvider myProvider;

    public MergePanel2(DialogBuilder builder, @NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/diff/impl/incrementalMerge/ui/MergePanel2", "<init>"));
        }
        this.myDuringCreation = false;
        this.myScrollSupport = new SyncScrollSupport();
        this.myDividers = new DiffDivider[]{new DiffDivider(FragmentSide.SIDE2), new DiffDivider(FragmentSide.SIDE1)};
        this.myScrollToFirstDiff = true;
        this.myEditorsPanels = new LabeledComponent[3];
        this.myDividersRepainter = new DividersRepainter();
        UsageTrigger.trigger("diff.MergePanel2");
        ArrayList<EditorPlace> editorPlaces = new ArrayList<EditorPlace>();
        EditorPlace.EditorListener placeListener = new EditorPlace.EditorListener(){

            @Override
            public void onEditorCreated(EditorPlace place) {
                if (MergePanel2.this.myDuringCreation) {
                    return;
                }
                MergePanel2.this.disposeMergeList();
                MergePanel2.this.myDuringCreation = true;
                try {
                    MergePanel2.this.tryInitView();
                }
                finally {
                    MergePanel2.this.myDuringCreation = false;
                }
            }

            @Override
            public void onEditorReleased(Editor releasedEditor) {
                LOG.assertTrue(!MergePanel2.this.myDuringCreation);
                MergePanel2.this.disposeMergeList();
            }
        };
        for (int i2 = 0; i2 < 3; ++i2) {
            EditorPlace editorPlace = new EditorPlace(new DiffEditorState(i2), MergePanel2.indexToColumn(i2), this);
            Disposer.register((Disposable)parent, (Disposable)editorPlace);
            editorPlaces.add(editorPlace);
            editorPlace.addListener(placeListener);
            this.myEditorsPanels[i2] = new LabeledComponent();
            this.myEditorsPanels[i2].setLabelLocation("North");
            this.myEditorsPanels[i2].setComponent((JComponent)editorPlace);
        }
        FontSizeSynchronizer.attachTo(editorPlaces);
        this.myPanel = new DiffPanelOuterComponent(TextDiffType.MERGE_TYPES, this.createToolbar());
        this.myPanel.insertDiffComponent(new ThreePanels((JComponent[])this.myEditorsPanels, this.myDividers), new MyScrollingPanel());
        this.myProvider = new MyDataProvider();
        this.myPanel.setDataProvider(this.myProvider);
        this.myBuilder = builder;
    }

    private static MergePanelColumn indexToColumn(int i2) {
        switch (i2) {
            case 0: {
                return MergePanelColumn.LEFT;
            }
            case 1: {
                return MergePanelColumn.BASE;
            }
            case 2: {
                return MergePanelColumn.RIGHT;
            }
        }
        throw new IllegalStateException("Incorrect value for a merge column: " + i2);
    }

    @NotNull
    private DiffRequest.ToolbarAddons createToolbar() {
        DiffRequest.ToolbarAddons toolbarAddons = new DiffRequest.ToolbarAddons(){

            public void customize(DiffToolbar toolbar) {
                toolbar.addAction(PreviousDiffAction.find());
                toolbar.addAction(NextDiffAction.find());
                toolbar.addSeparator();
                toolbar.addAction((AnAction)new OpenPartialDiffAction(0, 1, AllIcons.Diff.LeftDiff));
                toolbar.addAction((AnAction)new OpenPartialDiffAction(1, 2, AllIcons.Diff.RightDiff));
                toolbar.addAction((AnAction)new OpenPartialDiffAction(0, 2, AllIcons.Diff.BranchDiff));
                toolbar.addSeparator();
                toolbar.addAction((AnAction)new ApplyNonConflicts(MergePanel2.this.myPanel));
                toolbar.addSeparator();
                toolbar.addAction((AnAction)new ToggleAutoScrollAction());
                Project project2 = MergePanel2.this.myData.getProject();
                if (project2 != null) {
                    toolbar.addSeparator();
                    toolbar.addAction((AnAction)new DiffMergeSettingsAction(MergePanel2.this.getEditors(), (DiffMergeSettings)ServiceManager.getService((Project)project2, MergeToolSettings.class)));
                }
            }
        };
        if (toolbarAddons == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ui/MergePanel2", "createToolbar"));
        }
        return toolbarAddons;
    }

    @NotNull
    private Collection<Editor> getEditors() {
        ArrayList<Editor> editors = new ArrayList<Editor>(3);
        for (EditorPlace place : this.getEditorPlaces()) {
            editors.add(place.getEditor());
        }
        ArrayList<Editor> arrayList = editors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ui/MergePanel2", "getEditors"));
        }
        return arrayList;
    }

    @NotNull
    private Collection<EditorPlace> getEditorPlaces() {
        ArrayList<EditorPlace> editorPlaces = new ArrayList<EditorPlace>(3);
        for (LabeledComponent editorsPanel : this.myEditorsPanels) {
            editorPlaces.add((EditorPlace)editorsPanel.getComponent());
        }
        ArrayList<EditorPlace> arrayList = editorPlaces;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ui/MergePanel2", "getEditorPlaces"));
        }
        return arrayList;
    }

    public void setScrollToFirstDiff(boolean scrollToFirstDiff) {
        this.myScrollToFirstDiff = scrollToFirstDiff;
    }

    @Deprecated
    @Nullable
    public Editor getEditor(int index) {
        return this.getEditorPlace(index).getEditor();
    }

    public FileType getContentType() {
        return this.myData == null ? FileTypes.PLAIN_TEXT : MergePanel2.getContentType(this.myData);
    }

    @Deprecated
    public String getVersionTitle(int index) {
        return this.myEditorsPanels[index].getRawText();
    }

    @Deprecated
    public EditorPlace getEditorPlace(int index) {
        return (EditorPlace)this.myEditorsPanels[index].getComponent();
    }

    private void createMergeList() {
        if (this.myData == null) {
            return;
        }
        DiffContent[] contents = this.myData.getContents();
        for (int i2 = 0; i2 < 3; ++i2) {
            EditorPlace editorPlace = this.getEditorPlace(i2);
            editorPlace.setDocument(contents[i2].getDocument());
            this.setHighlighterSettings(null, editorPlace);
        }
        this.tryInitView();
    }

    private void tryInitView() {
        if (!this.hasAllEditors()) {
            return;
        }
        if (this.myMergeList != null) {
            return;
        }
        this.myMergeList = MergeList.create(this.myData);
        this.myMergeList.addListener(this.myDividersRepainter);
        this.myStatusUpdater = StatusUpdater.install(this.myMergeList, this.myPanel);
        Editor left = this.getEditor(0);
        Editor base = this.getEditor(1);
        Editor right = this.getEditor(2);
        this.setupHighlighterSettings(left, base, right);
        this.myMergeList.setMarkups(left, base, right);
        EditingSides[] sides = new EditingSides[]{this.getFirstEditingSide(), this.getSecondEditingSide()};
        this.myScrollSupport.install(sides);
        for (int i2 = 0; i2 < this.myDividers.length; ++i2) {
            this.myDividers[i2].listenEditors(sides[i2]);
        }
        if (this.myScrollToFirstDiff) {
            this.myPanel.requestScrollEditors();
        }
        if (this.myMergeList.getErrorMessage() != null) {
            this.myPanel.insertTopComponent((JComponent)new EditorNotificationPanel(){
                {
                    this.myLabel.setText(MergePanel2.this.myMergeList.getErrorMessage());
                }
            });
        }
    }

    @NotNull
    EditingSides getFirstEditingSide() {
        MyEditingSides myEditingSides = new MyEditingSides(FragmentSide.SIDE1);
        if (myEditingSides == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ui/MergePanel2", "getFirstEditingSide"));
        }
        return myEditingSides;
    }

    @NotNull
    EditingSides getSecondEditingSide() {
        MyEditingSides myEditingSides = new MyEditingSides(FragmentSide.SIDE2);
        if (myEditingSides == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ui/MergePanel2", "getSecondEditingSide"));
        }
        return myEditingSides;
    }

    public void setAutoScrollEnabled(boolean enabled) {
        this.myScrollSupport.setEnabled(enabled);
    }

    public boolean isAutoScrollEnabled() {
        return this.myScrollSupport.isEnabled();
    }

    private void setupHighlighterSettings(Editor left, Editor base, Editor right) {
        Editor[] editors = new Editor[]{left, base, right};
        DiffContent[] contents = this.myData.getContents();
        FileType[] types = DiffUtil.chooseContentTypes(contents);
        VirtualFile fallbackFile = contents[1].getFile();
        FileType fallbackType = contents[1].getContentType();
        for (int i2 = 0; i2 < 3; ++i2) {
            Editor editor = editors[i2];
            DiffContent content2 = contents[i2];
            EditorHighlighter highlighter2 = MergePanel2.createHighlighter(types[i2], content2.getFile(), fallbackFile, fallbackType, this.myData.getProject()).createHighlighter();
            if (highlighter2 == null) continue;
            ((EditorEx)editor).setHighlighter(highlighter2);
        }
    }

    private static DiffHighlighterFactory createHighlighter(FileType contentType, VirtualFile file2, VirtualFile otherFile, FileType otherType, Project project2) {
        if (file2 == null) {
            file2 = otherFile;
        }
        if (contentType == null) {
            contentType = otherType;
        }
        return new DiffHighlighterFactoryImpl(contentType, file2, project2);
    }

    public void setHighlighterSettings(@Nullable EditorColorsScheme settings) {
        for (EditorPlace place : this.getEditorPlaces()) {
            this.setHighlighterSettings(settings, place);
        }
    }

    private void setHighlighterSettings(@Nullable EditorColorsScheme settings, @NotNull EditorPlace place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/diff/impl/incrementalMerge/ui/MergePanel2", "setHighlighterSettings"));
        }
        if (settings == null) {
            settings = EditorColorsManager.getInstance().getGlobalScheme();
        }
        Editor editor = place.getEditor();
        DiffEditorState editorState = place.getState();
        if (editor != null) {
            ((EditorEx)editor).setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(editorState.getFileType(), settings, editorState.getProject()));
        }
    }

    private static void initEditorSettings(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/diff/impl/incrementalMerge/ui/MergePanel2", "initEditorSettings"));
        }
        Project project2 = editor.getProject();
        DiffMergeSettings settings = project2 == null ? null : (DiffMergeSettings)ServiceManager.getService((Project)project2, MergeToolSettings.class);
        for (DiffMergeEditorSetting property : DiffMergeEditorSetting.values()) {
            property.apply(editor, settings == null ? property.getDefault() : settings.getPreference(property));
        }
        editor.getSettings().setLineMarkerAreaShown(true);
    }

    private void disposeMergeList() {
        if (this.myMergeList == null) {
            return;
        }
        if (this.myStatusUpdater != null) {
            this.myStatusUpdater.dispose(this.myMergeList);
            this.myStatusUpdater = null;
        }
        this.myMergeList.removeListener(this.myDividersRepainter);
        this.myMergeList = null;
        for (DiffDivider myDivider : this.myDividers) {
            myDivider.stopListenEditors();
        }
    }

    public boolean canShowRequest(DiffRequest request2) {
        return MergeTool.canShowRequest(request2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiffRequest(DiffRequest data) {
        this.setTitle(data.getWindowTitle());
        this.disposeMergeList();
        for (int i2 = 0; i2 < 3; ++i2) {
            this.getEditorPlace(i2).setDocument(null);
        }
        LOG.assertTrue(!this.myDuringCreation);
        this.myDuringCreation = true;
        this.myProvider.putData(data.getGenericData());
        try {
            this.myData = data;
            String[] titles = this.myData.getContentTitles();
            for (int i3 = 0; i3 < this.myEditorsPanels.length; ++i3) {
                LabeledComponent editorsPanel = this.myEditorsPanels[i3];
                editorsPanel.getLabel().setText(titles[i3].isEmpty() ? " " : titles[i3]);
            }
            this.createMergeList();
            data.customizeToolbar(this.myPanel.resetToolbar());
            this.myPanel.registerToolbarActions();
            if (data instanceof MergeRequestImpl && this.myBuilder != null) {
                Convertor<DialogWrapper, Boolean> preOkHook = new Convertor<DialogWrapper, Boolean>(){

                    public Boolean convert(DialogWrapper dialog2) {
                        ChangeCounter counter = ChangeCounter.getOrCreate(MergePanel2.this.myMergeList);
                        int changes = counter.getChangeCounter();
                        int conflicts = counter.getConflictCounter();
                        if (changes == 0 && conflicts == 0) {
                            return true;
                        }
                        return Messages.showYesNoDialog((Component)dialog2.getRootPane(), (String)DiffBundle.message((String)"merge.dialog.apply.partially.resolved.changes.confirmation.message", (Object[])new Object[]{changes, conflicts}), (String)DiffBundle.message((String)"apply.partially.resolved.merge.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
                    }
                };
                ((MergeRequestImpl)data).setActions(this.myBuilder, this, preOkHook);
            }
        }
        finally {
            this.myDuringCreation = false;
        }
    }

    private void setTitle(String windowTitle) {
        JDialog parent = this.getDialogWrapperParent();
        if (parent == null) {
            return;
        }
        parent.setTitle(windowTitle);
    }

    @Nullable
    private JDialog getDialogWrapperParent() {
        for (Container panel2 = this.myPanel; panel2 != null; panel2 = panel2.getParent()) {
            if (!(panel2 instanceof JDialog)) continue;
            return (JDialog)panel2;
        }
        return null;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.getEditorPlace(1).getContentComponent();
    }

    public int getContentsNumber() {
        return 3;
    }

    public boolean acceptsType(DiffViewerType type) {
        return DiffViewerType.merge.equals((Object)type);
    }

    private boolean hasAllEditors() {
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.getEditor(i2) != null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public MergeRequestImpl getMergeRequest() {
        return (MergeRequestImpl)(this.myData instanceof MergeRequestImpl ? this.myData : null);
    }

    private static FileType getContentType(DiffRequest diffData) {
        FileType contentType = diffData.getContents()[1].getContentType();
        if (contentType == null) {
            contentType = FileTypes.PLAIN_TEXT;
        }
        return contentType;
    }

    @Nullable
    public static MergePanel2 fromDataContext(DataContext dataContext) {
        DiffViewer diffComponent = (DiffViewer)PlatformDataKeys.DIFF_VIEWER.getData(dataContext);
        return diffComponent instanceof MergePanel2 ? (MergePanel2)diffComponent : null;
    }

    public MergeList getMergeList() {
        return this.myMergeList;
    }

    public void setColorScheme(EditorColorsScheme scheme2) {
        for (Editor editor : this.getEditors()) {
            if (editor == null) continue;
            ((EditorEx)editor).setColorsScheme(scheme2);
        }
        this.myPanel.setColorScheme(scheme2);
    }

    public static class AsComponent
    extends JPanel {
        private final MergePanel2 myMergePanel;

        public AsComponent(@NotNull Disposable parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/diff/impl/incrementalMerge/ui/MergePanel2$AsComponent", "<init>"));
            }
            super(new BorderLayout());
            this.myMergePanel = new MergePanel2(null, parent);
            this.add((Component)this.myMergePanel.getComponent(), "Center");
        }

        public MergePanel2 getMergePanel() {
            return this.myMergePanel;
        }

        public boolean isToolbarEnabled() {
            return this.myMergePanel.myPanel.isToolbarEnabled();
        }

        public void setToolbarEnabled(boolean enabled) {
            this.myMergePanel.myPanel.disableToolbar(!enabled);
        }
    }

    private static class StatusUpdater
    implements ChangeCounter.Listener {
        private final DiffPanelOuterComponent myPanel;

        private StatusUpdater(DiffPanelOuterComponent panel2) {
            this.myPanel = panel2;
        }

        @Override
        public void onCountersChanged(ChangeCounter counter) {
            int changes = counter.getChangeCounter();
            int conflicts = counter.getConflictCounter();
            String text2 = changes == 0 && conflicts == 0 ? DiffBundle.message((String)"merge.dialog.all.conflicts.resolved.message.text", (Object[])new Object[0]) : StatusUpdater.makeCountersText(changes, conflicts);
            this.myPanel.setStatusBarText(text2);
        }

        @NotNull
        private static String makeCountersText(int changes, int conflicts) {
            String string2 = StatusUpdater.makeCounterWord(changes, "change") + ". " + StatusUpdater.makeCounterWord(conflicts, "conflict");
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ui/MergePanel2$StatusUpdater", "makeCountersText"));
            }
            return string2;
        }

        @NotNull
        private static String makeCounterWord(int number, @NotNull String word) {
            if (word == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/openapi/diff/impl/incrementalMerge/ui/MergePanel2$StatusUpdater", "makeCounterWord"));
            }
            if (number == 0) {
                String string2 = "No " + StringUtil.pluralize((String)word);
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ui/MergePanel2$StatusUpdater", "makeCounterWord"));
                }
                return string2;
            }
            String string3 = number + " " + StringUtil.pluralize((String)word, (int)number);
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ui/MergePanel2$StatusUpdater", "makeCounterWord"));
            }
            return string3;
        }

        public void dispose(@NotNull MergeList mergeList) {
            if (mergeList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeList", "com/intellij/openapi/diff/impl/incrementalMerge/ui/MergePanel2$StatusUpdater", "dispose"));
            }
            ChangeCounter.getOrCreate(mergeList).removeListener(this);
        }

        public static StatusUpdater install(MergeList mergeList, DiffPanelOuterComponent panel2) {
            ChangeCounter counters = ChangeCounter.getOrCreate(mergeList);
            StatusUpdater updater = new StatusUpdater(panel2);
            counters.addListener(updater);
            updater.onCountersChanged(counters);
            return updater;
        }
    }

    private class DividersRepainter
    implements ChangeList.Listener {
        private DividersRepainter() {
        }

        @Override
        public void onChangeApplied(ChangeList source) {
            FragmentSide side = MergePanel2.this.myMergeList.getSideOf(source);
            MergePanel2.this.myDividers[side.getIndex()].repaint();
        }

        @Override
        public void onChangeRemoved(ChangeList source) {
            FragmentSide side = MergePanel2.this.myMergeList.getSideOf(source);
            MergePanel2.this.myDividers[side.getIndex()].repaint();
        }
    }

    private class MergeFocusedSide
    implements FocusDiffSide {
        private MergeFocusedSide() {
        }

        @Override
        public Editor getEditor() {
            return MergePanel2.this.getEditor(1);
        }

        @Override
        public int[] getFragmentStartingLines() {
            TIntHashSet beginnings = new TIntHashSet();
            if (MergePanel2.this.myMergeList != null) {
                for (int i2 = 0; i2 < 2; ++i2) {
                    FragmentSide branchSide = FragmentSide.fromIndex((int)i2);
                    beginnings.addAll(MergePanel2.this.myMergeList.getChanges(branchSide).getNonAppliedLineBlocks().getBeginnings(MergeList.BASE_SIDE));
                }
            }
            int[] result2 = beginnings.toArray();
            Arrays.sort(result2);
            return result2;
        }
    }

    private class BranchFocusedSide
    implements FocusDiffSide {
        private final FragmentSide mySide;

        private BranchFocusedSide(FragmentSide side) {
            this.mySide = side;
        }

        @Override
        @Nullable
        public Editor getEditor() {
            return MergePanel2.this.getEditor(this.mySide.getMergeIndex());
        }

        @Override
        public int[] getFragmentStartingLines() {
            return MergePanel2.this.myMergeList.getChanges(this.mySide).getNonAppliedLineBlocks().getBeginnings(MergeList.BRANCH_SIDE);
        }
    }

    private class MyDataProvider
    extends GenericDataProvider {
        private MyDataProvider() {
        }

        @Override
        public Object getData(String dataId) {
            if (FocusDiffSide.DATA_KEY.is(dataId)) {
                int index = this.getFocusedEditorIndex();
                if (index < 0) {
                    return null;
                }
                switch (index) {
                    case 0: {
                        return new BranchFocusedSide(FragmentSide.SIDE1);
                    }
                    case 1: {
                        return new MergeFocusedSide();
                    }
                    case 2: {
                        return new BranchFocusedSide(FragmentSide.SIDE2);
                    }
                }
            } else if (PlatformDataKeys.DIFF_VIEWER.is(dataId)) {
                return MergePanel2.this;
            }
            return super.getData(dataId);
        }

        private int getFocusedEditorIndex() {
            for (int i2 = 0; i2 < 3; ++i2) {
                Editor editor = MergePanel2.this.getEditor(i2);
                if (editor == null || !editor.getContentComponent().isFocusOwner()) continue;
                return i2;
            }
            return -1;
        }
    }

    class DiffEditorState {
        private final int myIndex;
        private Document myDocument;

        private DiffEditorState(int index) {
            this.myIndex = index;
        }

        public void setDocument(Document document) {
            this.myDocument = document;
        }

        public Document getDocument() {
            return this.myDocument;
        }

        @Nullable
        public EditorEx createEditor() {
            Document document = this.getDocument();
            if (document == null) {
                return null;
            }
            Project project2 = MergePanel2.this.myData.getProject();
            EditorEx editor = DiffUtil.createEditor(document, project2, this.myIndex != 1);
            if (editor == null) {
                return editor;
            }
            if (this.myIndex == 0) {
                editor.setVerticalScrollbarOrientation(0);
            }
            if (this.myIndex != 1) {
                ((EditorMarkupModel)((Object)editor.getMarkupModel())).setErrorStripeVisible(true);
            }
            editor.getSettings().setFoldingOutlineShown(false);
            editor.getFoldingModel().setFoldingEnabled(false);
            editor.getSettings().setLineMarkerAreaShown(false);
            editor.getSettings().setFoldingOutlineShown(false);
            editor.getGutterComponentEx().setShowDefaultGutterPopup(false);
            MergePanel2.initEditorSettings(editor);
            return editor;
        }

        public FileType getFileType() {
            return MergePanel2.this.getContentType();
        }

        @Nullable
        public Project getProject() {
            return MergePanel2.this.myData == null ? null : MergePanel2.this.myData.getProject();
        }
    }

    private class MyScrollingPanel
    implements DiffPanelOuterComponent.ScrollingPanel {
        private MyScrollingPanel() {
        }

        @Override
        public void scrollEditors() {
            int line;
            Editor centerEditor = MergePanel2.this.getEditor(1);
            JComponent centerComponent = centerEditor.getContentComponent();
            if (centerComponent.isShowing()) {
                centerComponent.requestFocus();
            }
            int[] toLeft = this.getPrimaryBeginnings(MergePanel2.this.myDividers[0].getPaint());
            int[] toRight = this.getPrimaryBeginnings(MergePanel2.this.myDividers[1].getPaint());
            if (toLeft.length > 0 && toRight.length > 0) {
                line = Math.min(toLeft[0], toRight[0]);
            } else if (toLeft.length > 0) {
                line = toLeft[0];
            } else if (toRight.length > 0) {
                line = toRight[0];
            } else {
                return;
            }
            SyncScrollSupport.scrollEditor(centerEditor, line);
        }

        private int[] getPrimaryBeginnings(DiffDividerPaint paint) {
            FragmentSide primarySide = paint.getLeftSide();
            LOG.assertTrue(MergePanel2.this.getEditor(1) == paint.getSides().getEditor(primarySide));
            return paint.getSides().getLineBlocks().getBeginnings(primarySide, true);
        }
    }

    private class MyEditingSides
    implements EditingSides {
        private final FragmentSide mySide;

        private MyEditingSides(FragmentSide side) {
            this.mySide = side;
        }

        @Override
        @Nullable
        public Editor getEditor(FragmentSide side) {
            return MergePanel2.this.getEditor(this.mySide.getIndex() + side.getIndex());
        }

        @Override
        public LineBlocks getLineBlocks() {
            return MergePanel2.this.myMergeList.getChanges(this.mySide).getLineBlocks();
        }
    }
}

