/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.ApplyTextFilePatch;
import com.intellij.openapi.diff.impl.patch.formove.CustomBinaryPatchApplier;
import com.intellij.openapi.diff.impl.patch.formove.PathMerger;
import com.intellij.openapi.diff.impl.patch.formove.PathsVerifier;
import com.intellij.openapi.diff.impl.patch.formove.TriggerAdditionOrDeletion;
import com.intellij.openapi.diff.impl.patch.formove.UndoApplyPatchDialog;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsFileListenerContextHelper;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchAction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchApplier<BinaryType extends FilePatch> {
    private final Project myProject;
    private final VirtualFile myBaseDirectory;
    @NotNull
    private final List<FilePatch> myPatches;
    private final CustomBinaryPatchApplier<BinaryType> myCustomForBinaries;
    private final CommitContext myCommitContext;
    private final Consumer<Collection<FilePath>> myToTargetListsMover;
    @NotNull
    private final List<FilePatch> myRemainingPatches;
    @NotNull
    private final List<FilePatch> myFailedPatches;
    private final PathsVerifier<BinaryType> myVerifier;
    private boolean mySystemOperation;
    private final boolean myReverseConflict;
    @Nullable
    private final String myLeftConflictPanelTitle;
    @Nullable
    private final String myRightConflictPanelTitle;

    public PatchApplier(@NotNull Project project2, VirtualFile baseDirectory, @NotNull List<FilePatch> patches, @Nullable Consumer<Collection<FilePath>> toTargetListsMover, CustomBinaryPatchApplier<BinaryType> customForBinaries, CommitContext commitContext, boolean reverseConflict, @Nullable String leftConflictPanelTitle, @Nullable String rightConflictPanelTitle) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "<init>"));
        }
        if (patches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patches", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "<init>"));
        }
        this.myProject = project2;
        this.myBaseDirectory = baseDirectory;
        this.myPatches = patches;
        this.myToTargetListsMover = toTargetListsMover;
        this.myCustomForBinaries = customForBinaries;
        this.myCommitContext = commitContext;
        this.myReverseConflict = reverseConflict;
        this.myLeftConflictPanelTitle = leftConflictPanelTitle;
        this.myRightConflictPanelTitle = rightConflictPanelTitle;
        this.myRemainingPatches = new ArrayList<FilePatch>();
        this.myFailedPatches = new ArrayList<FilePatch>();
        this.myVerifier = new PathsVerifier(this.myProject, this.myBaseDirectory, this.myPatches, new PathsVerifier.BaseMapper(){

            @Override
            @Nullable
            public VirtualFile getFile(FilePatch patch, String path) {
                return PathMerger.getFile(PatchApplier.this.myBaseDirectory, path);
            }

            @Override
            public FilePath getPath(FilePatch patch, String path) {
                return PathMerger.getFile(VcsUtil.getFilePath((VirtualFile)PatchApplier.this.myBaseDirectory), path);
            }
        });
    }

    public PatchApplier(Project project2, VirtualFile baseDirectory, @NotNull List<FilePatch> patches, LocalChangeList targetChangeList, CustomBinaryPatchApplier<BinaryType> customForBinaries, CommitContext commitContext, boolean reverseConflict, @Nullable String leftConflictPanelTitle, @Nullable String rightConflictPanelTitle) {
        if (patches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patches", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "<init>"));
        }
        this(project2, baseDirectory, patches, PatchApplier.createMover(project2, targetChangeList), customForBinaries, commitContext, reverseConflict, leftConflictPanelTitle, rightConflictPanelTitle);
    }

    public void setIgnoreContentRootsCheck() {
        this.myVerifier.setIgnoreContentRootsCheck(true);
    }

    public PatchApplier(Project project2, VirtualFile baseDirectory, @NotNull List<FilePatch> patches, LocalChangeList targetChangeList, CustomBinaryPatchApplier<BinaryType> customForBinaries, CommitContext commitContext) {
        if (patches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patches", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "<init>"));
        }
        this(project2, baseDirectory, patches, targetChangeList, customForBinaries, commitContext, false, null, null);
    }

    public void setIsSystemOperation(boolean systemOperation) {
        this.mySystemOperation = systemOperation;
    }

    @Nullable
    private static Consumer<Collection<FilePath>> createMover(Project project2, LocalChangeList targetChangeList) {
        ChangeListManager clm = ChangeListManager.getInstance((Project)project2);
        if (targetChangeList == null || clm.getDefaultListName().equals(targetChangeList.getName())) {
            return null;
        }
        return new FilesMover(clm, targetChangeList);
    }

    @NotNull
    public List<FilePatch> getPatches() {
        List<FilePatch> list2 = this.myPatches;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "getPatches"));
        }
        return list2;
    }

    @NotNull
    private Collection<FilePatch> getFailedPatches() {
        List<FilePatch> list2 = this.myFailedPatches;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "getFailedPatches"));
        }
        return list2;
    }

    @NotNull
    public List<BinaryType> getBinaryPatches() {
        List list2 = ContainerUtil.mapNotNull(this.myVerifier.getBinaryPatches(), (Function)new Function<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>, BinaryType>(){

            public BinaryType fun(Pair<VirtualFile, ApplyFilePatchBase<BinaryType>> patchInfo) {
                return ((ApplyFilePatchBase)patchInfo.getSecond()).getPatch();
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "getBinaryPatches"));
        }
        return list2;
    }

    public void execute() {
        this.execute(true, false);
    }

    public ApplyPatchTask createApplyPart(boolean showSuccessNotification, boolean silentAddDelete) {
        return new ApplyPatchTask(showSuccessNotification, silentAddDelete);
    }

    public void execute(boolean showSuccessNotification, boolean silentAddDelete) {
        this.createApplyPart(showSuccessNotification, silentAddDelete).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplyPatchStatus executePatchGroup(final Collection<PatchApplier> group, LocalChangeList localChangeList) {
        if (group.isEmpty()) {
            return ApplyPatchStatus.SUCCESS;
        }
        Project project2 = group.iterator().next().myProject;
        ApplyPatchStatus result2 = ApplyPatchStatus.SUCCESS;
        for (PatchApplier patchApplier : group) {
            result2 = ApplyPatchStatus.and(result2, patchApplier.nonWriteActionPreCheck());
        }
        Label beforeLabel = LocalHistory.getInstance().putSystemLabel(project2, "Before patch");
        final TriggerAdditionOrDeletion trigger = new TriggerAdditionOrDeletion(project2);
        final Ref refStatus = new Ref((Object)result2);
        try {
            CommandProcessor.getInstance().executeCommand(project2, new Runnable(){

                @Override
                public void run() {
                    for (PatchApplier applier : group) {
                        refStatus.set((Object)ApplyPatchStatus.and((ApplyPatchStatus)((Object)refStatus.get()), applier.createFiles()));
                        applier.addSkippedItems(trigger);
                    }
                    trigger.prepare();
                    if (refStatus.get() == ApplyPatchStatus.SUCCESS) {
                        refStatus.set(null);
                    }
                    for (PatchApplier applier : group) {
                        refStatus.set((Object)ApplyPatchStatus.and((ApplyPatchStatus)((Object)refStatus.get()), applier.executeWritable()));
                        if (refStatus.get() != ApplyPatchStatus.ABORT) continue;
                        break;
                    }
                }
            }, VcsBundle.message((String)"patch.apply.command", (Object[])new Object[0]), null);
        }
        finally {
            VcsFileListenerContextHelper.getInstance((Project)project2).clearContext();
            LocalHistory.getInstance().putSystemLabel(project2, "After patch");
        }
        result2 = (ApplyPatchStatus)((Object)refStatus.get());
        result2 = result2 == null ? ApplyPatchStatus.FAILURE : result2;
        trigger.processIt();
        HashSet<FilePath> directlyAffected = new HashSet<FilePath>();
        HashSet<VirtualFile> indirectlyAffected = new HashSet<VirtualFile>();
        for (PatchApplier applier : group) {
            directlyAffected.addAll(applier.getDirectlyAffected());
            indirectlyAffected.addAll(applier.getIndirectlyAffected());
        }
        directlyAffected.addAll(trigger.getAffected());
        Consumer<Collection<FilePath>> mover = localChangeList == null ? null : PatchApplier.createMover(project2, localChangeList);
        PatchApplier.refreshPassedFilesAndMoveToChangelist(project2, directlyAffected, indirectlyAffected, mover);
        if (result2 == ApplyPatchStatus.FAILURE) {
            PatchApplier.suggestRollback(project2, group, beforeLabel);
        } else if (result2 == ApplyPatchStatus.ABORT) {
            PatchApplier.rollbackUnderProgress(project2, project2.getBaseDir(), beforeLabel);
        }
        PatchApplier.showApplyStatus(project2, result2);
        return result2;
    }

    private static void suggestRollback(@NotNull Project project2, @NotNull Collection<PatchApplier> group, @NotNull Label beforeLabel) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "suggestRollback"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "suggestRollback"));
        }
        if (beforeLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeLabel", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "suggestRollback"));
        }
        List allFailed = ContainerUtil.concat(group, (Function)new Function<PatchApplier, Collection<? extends FilePatch>>(){

            public Collection<FilePatch> fun(PatchApplier applier) {
                return applier.getFailedPatches();
            }
        });
        boolean shouldInformAboutBinaries = ContainerUtil.exists(group, (Condition)new Condition<PatchApplier>(){

            public boolean value(PatchApplier applier) {
                return !applier.getBinaryPatches().isEmpty();
            }
        });
        UndoApplyPatchDialog undoApplyPatchDialog = new UndoApplyPatchDialog(project2, ContainerUtil.map((Collection)allFailed, (Function)new Function<FilePatch, FilePath>(){

            public FilePath fun(FilePatch filePatch) {
                String path = filePatch.getAfterName() == null ? filePatch.getBeforeName() : filePatch.getAfterName();
                return VcsUtil.getFilePath((String)path);
            }
        }), shouldInformAboutBinaries);
        undoApplyPatchDialog.show();
        if (undoApplyPatchDialog.isOK()) {
            PatchApplier.rollbackUnderProgress(project2, project2.getBaseDir(), beforeLabel);
        }
    }

    private static void rollbackUnderProgress(@NotNull Project project2, @NotNull VirtualFile virtualFile, @NotNull Label labelToRevert) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "rollbackUnderProgress"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "rollbackUnderProgress"));
        }
        if (labelToRevert == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelToRevert", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "rollbackUnderProgress"));
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (labelToRevert == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelToRevert", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "lambda$rollbackUnderProgress$0"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "lambda$rollbackUnderProgress$0"));
            }
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "lambda$rollbackUnderProgress$0"));
            }
            try {
                labelToRevert.revert(project2, virtualFile);
                VcsNotifier.getInstance(project2).notifyImportantWarning("Apply Patch Aborted", "All files changed during apply patch action were rolled back");
            }
            catch (LocalHistoryException e2) {
                VcsNotifier.getInstance(project2).notifyImportantWarning("Rollback Failed", String.format("Try using local history dialog for %s and perform revert manually.", virtualFile.getName()));
            }
        }, "Rollback Applied Changes...", true, project2);
    }

    protected void addSkippedItems(TriggerAdditionOrDeletion trigger) {
        trigger.addExisting(this.myVerifier.getToBeAdded());
        trigger.addDeleted(this.myVerifier.getToBeDeleted());
    }

    @NotNull
    public ApplyPatchStatus nonWriteActionPreCheck() {
        List<FilePatch> failedPreCheck = this.myVerifier.nonWriteActionPreCheck();
        this.myFailedPatches.addAll(failedPreCheck);
        this.myPatches.removeAll(failedPreCheck);
        List<FilePatch> skipped = this.myVerifier.getSkipped();
        boolean applyAll = skipped.isEmpty();
        this.myPatches.removeAll(skipped);
        if (!failedPreCheck.isEmpty()) {
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.FAILURE;
            if (applyPatchStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "nonWriteActionPreCheck"));
            }
            return applyPatchStatus;
        }
        ApplyPatchStatus applyPatchStatus = applyAll ? ApplyPatchStatus.SUCCESS : (skipped.size() == this.myPatches.size() ? ApplyPatchStatus.ALREADY_APPLIED : ApplyPatchStatus.PARTIAL);
        if (applyPatchStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "nonWriteActionPreCheck"));
        }
        return applyPatchStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected ApplyPatchStatus executeWritable() {
        ReadonlyStatusHandler.OperationStatus readOnlyFilesStatus = this.getReadOnlyFilesStatus(this.myVerifier.getWritableFiles());
        if (readOnlyFilesStatus.hasReadonlyFiles()) {
            PatchApplier.showError(this.myProject, readOnlyFilesStatus.getReadonlyFilesMessage());
            return ApplyPatchStatus.ABORT;
        }
        this.myFailedPatches.addAll(this.myVerifier.filterBadFileTypePatches());
        ApplyPatchStatus result2 = this.myFailedPatches.isEmpty() ? null : ApplyPatchStatus.FAILURE;
        List<Pair<VirtualFile, ApplyTextFilePatch>> textPatches = this.myVerifier.getTextPatches();
        try {
            PatchApplier.markInternalOperation(textPatches, true);
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.and(result2, this.actualApply(textPatches, this.myVerifier.getBinaryPatches(), this.myCommitContext));
            return applyPatchStatus;
        }
        finally {
            PatchApplier.markInternalOperation(textPatches, false);
        }
    }

    @NotNull
    private ApplyPatchStatus createFiles() {
        Application application = ApplicationManager.getApplication();
        Boolean isSuccess = (Boolean)application.runWriteAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                List<FilePatch> filePatches = PatchApplier.this.myVerifier.execute();
                PatchApplier.this.myFailedPatches.addAll(filePatches);
                PatchApplier.this.myPatches.removeAll(filePatches);
                return PatchApplier.this.myFailedPatches.isEmpty();
            }
        });
        ApplyPatchStatus applyPatchStatus = isSuccess != false ? ApplyPatchStatus.SUCCESS : ApplyPatchStatus.FAILURE;
        if (applyPatchStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "createFiles"));
        }
        return applyPatchStatus;
    }

    private static void markInternalOperation(List<Pair<VirtualFile, ApplyTextFilePatch>> textPatches, boolean set2) {
        for (Pair<VirtualFile, ApplyTextFilePatch> patch : textPatches) {
            ChangesUtil.markInternalOperation((VirtualFile)((VirtualFile)patch.getFirst()), (boolean)set2);
        }
    }

    protected void refreshFiles(Collection<FilePath> additionalDirectly) {
        List<FilePath> directlyAffected = this.myVerifier.getDirectlyAffected();
        List<VirtualFile> indirectlyAffected = this.myVerifier.getAllAffected();
        directlyAffected.addAll(additionalDirectly);
        PatchApplier.refreshPassedFilesAndMoveToChangelist(this.myProject, directlyAffected, indirectlyAffected, this.myToTargetListsMover);
    }

    public List<FilePath> getDirectlyAffected() {
        return this.myVerifier.getDirectlyAffected();
    }

    public List<VirtualFile> getIndirectlyAffected() {
        return this.myVerifier.getAllAffected();
    }

    public static void refreshPassedFilesAndMoveToChangelist(@NotNull Project project2, final Collection<FilePath> directlyAffected, final Collection<VirtualFile> indirectlyAffected, final Consumer<Collection<FilePath>> targetChangelistMover) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "refreshPassedFilesAndMoveToChangelist"));
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (FilePath filePath : directlyAffected) {
            lfs.refreshAndFindFileByIoFile(filePath.getIOFile());
        }
        if (project2.isDisposed()) {
            return;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        if (!directlyAffected.isEmpty() && targetChangelistMover != null) {
            changeListManager.invokeAfterUpdate(new Runnable(){

                @Override
                public void run() {
                    targetChangelistMover.consume((Object)directlyAffected);
                }
            }, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, VcsBundle.message((String)"change.lists.manager.move.changes.to.list", (Object[])new Object[0]), (Consumer)new Consumer<VcsDirtyScopeManager>(){

                public void consume(VcsDirtyScopeManager vcsDirtyScopeManager) {
                    PatchApplier.markDirty(vcsDirtyScopeManager, directlyAffected, indirectlyAffected);
                }
            }, null);
        } else {
            PatchApplier.markDirty(VcsDirtyScopeManager.getInstance((Project)project2), directlyAffected, indirectlyAffected);
        }
    }

    private static void markDirty(@NotNull VcsDirtyScopeManager vcsDirtyScopeManager, @NotNull Collection<FilePath> directlyAffected, @NotNull Collection<VirtualFile> indirectlyAffected) {
        if (vcsDirtyScopeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsDirtyScopeManager", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "markDirty"));
        }
        if (directlyAffected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directlyAffected", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "markDirty"));
        }
        if (indirectlyAffected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indirectlyAffected", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "markDirty"));
        }
        vcsDirtyScopeManager.filePathsDirty(directlyAffected, null);
        vcsDirtyScopeManager.filesDirty(indirectlyAffected, null);
    }

    @Nullable
    private ApplyPatchStatus actualApply(List<Pair<VirtualFile, ApplyTextFilePatch>> textPatches, List<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>> binaryPatches, CommitContext commitContext) {
        ApplyPatchStatus status;
        ApplyPatchContext context2 = new ApplyPatchContext(this.myBaseDirectory, 0, true, true);
        try {
            status = this.applyList(textPatches, context2, null, commitContext);
            if (status == ApplyPatchStatus.ABORT) {
                return status;
            }
            if (this.myCustomForBinaries == null) {
                status = this.applyList(binaryPatches, context2, status, commitContext);
            } else {
                ApplyPatchStatus patchStatus = this.myCustomForBinaries.apply(binaryPatches);
                List<FilePatch> appliedPatches = this.myCustomForBinaries.getAppliedPatches();
                this.moveForCustomBinaries(binaryPatches, appliedPatches);
                status = ApplyPatchStatus.and(status, patchStatus);
                this.myRemainingPatches.removeAll(appliedPatches);
            }
        }
        catch (IOException e2) {
            PatchApplier.showError(this.myProject, e2.getMessage());
            return ApplyPatchStatus.ABORT;
        }
        return status;
    }

    private void moveForCustomBinaries(List<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>> patches, List<FilePatch> appliedPatches) throws IOException {
        for (Pair<VirtualFile, ApplyFilePatchBase<BinaryType>> patch : patches) {
            if (!appliedPatches.contains(((ApplyFilePatchBase)patch.getSecond()).getPatch())) continue;
            this.myVerifier.doMoveIfNeeded((VirtualFile)patch.getFirst());
        }
    }

    private <V extends FilePatch, T extends ApplyFilePatchBase<V>> ApplyPatchStatus applyList(List<Pair<VirtualFile, T>> patches, ApplyPatchContext context2, ApplyPatchStatus status, CommitContext commiContext) throws IOException {
        for (Pair<VirtualFile, T> patch : patches) {
            ApplyPatchStatus patchStatus = ApplyPatchAction.applyOnly(this.myProject, (ApplyFilePatchBase)patch.getSecond(), context2, (VirtualFile)patch.getFirst(), commiContext, this.myReverseConflict, this.myLeftConflictPanelTitle, this.myRightConflictPanelTitle);
            if (patchStatus == ApplyPatchStatus.ABORT) {
                return patchStatus;
            }
            status = ApplyPatchStatus.and(status, patchStatus);
            if (patchStatus == ApplyPatchStatus.FAILURE) {
                this.myFailedPatches.add((FilePatch)((ApplyFilePatchBase)patch.getSecond()).getPatch());
                continue;
            }
            if (patchStatus == ApplyPatchStatus.SKIP) continue;
            this.myVerifier.doMoveIfNeeded((VirtualFile)patch.getFirst());
            this.myRemainingPatches.remove(((ApplyFilePatchBase)patch.getSecond()).getPatch());
        }
        return status;
    }

    protected static void showApplyStatus(@NotNull Project project2, ApplyPatchStatus status) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "showApplyStatus"));
        }
        VcsNotifier vcsNotifier = VcsNotifier.getInstance(project2);
        if (status == ApplyPatchStatus.ALREADY_APPLIED) {
            vcsNotifier.notifyMinorInfo(VcsBundle.message((String)"patch.apply.dialog.title", (Object[])new Object[0]), VcsBundle.message((String)"patch.apply.already.applied", (Object[])new Object[0]));
        } else if (status == ApplyPatchStatus.PARTIAL) {
            vcsNotifier.notifyMinorInfo(VcsBundle.message((String)"patch.apply.dialog.title", (Object[])new Object[0]), VcsBundle.message((String)"patch.apply.partially.applied", (Object[])new Object[0]));
        } else if (status == ApplyPatchStatus.SUCCESS) {
            vcsNotifier.notifySuccess(VcsBundle.message((String)"patch.apply.success.applied.text", (Object[])new Object[0]));
        }
    }

    @NotNull
    public List<FilePatch> getRemainingPatches() {
        List<FilePatch> list2 = this.myRemainingPatches;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "getRemainingPatches"));
        }
        return list2;
    }

    private ReadonlyStatusHandler.OperationStatus getReadOnlyFilesStatus(@NotNull List<VirtualFile> filesToMakeWritable) {
        if (filesToMakeWritable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToMakeWritable", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "getReadOnlyFilesStatus"));
        }
        VirtualFile[] fileArray = VfsUtilCore.toVirtualFileArray(filesToMakeWritable);
        return ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(fileArray);
    }

    public static void showError(Project project2, String message2) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            return;
        }
        WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)project2, (String)message2, (String)VcsBundle.message((String)"patch.apply.dialog.title", (Object[])new Object[0])), null, (Project)project2);
    }

    private static class FilesMover
    implements Consumer<Collection<FilePath>> {
        private final ChangeListManager myChangeListManager;
        private final LocalChangeList myTargetChangeList;

        public FilesMover(ChangeListManager changeListManager, LocalChangeList targetChangeList) {
            this.myChangeListManager = changeListManager;
            this.myTargetChangeList = targetChangeList;
        }

        public void consume(Collection<FilePath> directlyAffected) {
            ArrayList<Change> changes = new ArrayList<Change>();
            for (FilePath file2 : directlyAffected) {
                Change change = this.myChangeListManager.getChange(file2);
                if (change == null) continue;
                changes.add(change);
            }
            this.myChangeListManager.moveChangesTo(this.myTargetChangeList, changes.toArray(new Change[changes.size()]));
        }
    }

    public class ApplyPatchTask {
        private ApplyPatchStatus myStatus;
        private final boolean myShowNotification;
        private final boolean mySystemOperation;
        private VcsShowConfirmationOption.Value myAddconfirmationvalue;
        private VcsShowConfirmationOption.Value myDeleteconfirmationvalue;

        public ApplyPatchTask(boolean showNotification2, boolean systemOperation) {
            this.myShowNotification = showNotification2;
            this.mySystemOperation = systemOperation;
        }

        public void run() {
            PatchApplier.this.myRemainingPatches.addAll(PatchApplier.this.myPatches);
            ApplyPatchStatus patchStatus = PatchApplier.this.nonWriteActionPreCheck();
            Label beforeLabel = LocalHistory.getInstance().putSystemLabel(PatchApplier.this.myProject, "Before patch");
            TriggerAdditionOrDeletion trigger = new TriggerAdditionOrDeletion(PatchApplier.this.myProject);
            ApplyPatchStatus applyStatus = this.getApplyPatchStatus(trigger);
            this.myStatus = ApplyPatchStatus.SUCCESS.equals((Object)patchStatus) ? applyStatus : ApplyPatchStatus.and(patchStatus, applyStatus);
            trigger.processIt();
            LocalHistory.getInstance().putSystemLabel(PatchApplier.this.myProject, "After patch");
            if (this.myStatus == ApplyPatchStatus.FAILURE) {
                PatchApplier.suggestRollback(PatchApplier.this.myProject, Collections.singletonList(PatchApplier.this), beforeLabel);
            } else if (this.myStatus == ApplyPatchStatus.ABORT) {
                PatchApplier.rollbackUnderProgress(PatchApplier.this.myProject, PatchApplier.this.myProject.getBaseDir(), beforeLabel);
            }
            if (this.myShowNotification || !ApplyPatchStatus.SUCCESS.equals((Object)this.myStatus)) {
                PatchApplier.showApplyStatus(PatchApplier.this.myProject, this.myStatus);
            }
            PatchApplier.this.refreshFiles(trigger.getAffected());
        }

        @NotNull
        private ApplyPatchStatus getApplyPatchStatus(final @NotNull TriggerAdditionOrDeletion trigger) {
            if (trigger == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trigger", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier$ApplyPatchTask", "getApplyPatchStatus"));
            }
            final Ref refStatus = Ref.create(null);
            try {
                this.setConfirmationToDefault();
                CommandProcessor.getInstance().executeCommand(PatchApplier.this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        if (PatchApplier.this.createFiles() != ApplyPatchStatus.SUCCESS) {
                            refStatus.set((Object)PatchApplier.this.createFiles());
                        }
                        PatchApplier.this.addSkippedItems(trigger);
                        trigger.prepare();
                        refStatus.set((Object)ApplyPatchStatus.and((ApplyPatchStatus)((Object)refStatus.get()), PatchApplier.this.executeWritable()));
                    }
                }, VcsBundle.message((String)"patch.apply.command", (Object[])new Object[0]), null);
            }
            finally {
                this.returnConfirmationBack();
                VcsFileListenerContextHelper.getInstance((Project)PatchApplier.this.myProject).clearContext();
            }
            ApplyPatchStatus status = (ApplyPatchStatus)((Object)refStatus.get());
            ApplyPatchStatus applyPatchStatus = status == null ? ApplyPatchStatus.ALREADY_APPLIED : status;
            if (applyPatchStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier$ApplyPatchTask", "getApplyPatchStatus"));
            }
            return applyPatchStatus;
        }

        private void returnConfirmationBack() {
            if (this.mySystemOperation) {
                ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)PatchApplier.this.myProject);
                VcsShowConfirmationOption addConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, null);
                addConfirmation.setValue(this.myAddconfirmationvalue);
                VcsShowConfirmationOption deleteConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, null);
                deleteConfirmation.setValue(this.myDeleteconfirmationvalue);
            }
        }

        private void setConfirmationToDefault() {
            if (this.mySystemOperation) {
                ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)PatchApplier.this.myProject);
                VcsShowConfirmationOption addConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, null);
                this.myAddconfirmationvalue = addConfirmation.getValue();
                addConfirmation.setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
                VcsShowConfirmationOption deleteConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, null);
                this.myDeleteconfirmationvalue = deleteConfirmation.getValue();
                deleteConfirmation.setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
            }
        }

        public ApplyPatchStatus getStatus() {
            return this.myStatus;
        }
    }
}

