/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.splitter;

import com.intellij.openapi.diff.impl.EditingSides;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.splitter.DividerPolygon;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class DiffDividerPaint {
    private final EditingSides mySides;
    private final FragmentSide myLeftSide;
    private final int myDiffDividerPolygonsOffset;

    public DiffDividerPaint(EditingSides sides, FragmentSide leftSide, int diffDividerPolygonsOffset) {
        this.mySides = sides;
        this.myLeftSide = leftSide;
        this.myDiffDividerPolygonsOffset = diffDividerPolygonsOffset;
    }

    public void paint(Graphics g2, JComponent component) {
        if (!this.hasAllEditors()) {
            return;
        }
        int width = component.getWidth();
        int height = component.getHeight();
        int editorHeight = this.mySides.getEditor(this.myLeftSide).getComponent().getHeight();
        Graphics2D gg = (Graphics2D)g2.create(0, height - editorHeight, width, editorHeight);
        DividerPolygon.paintPolygons(DividerPolygon.createVisiblePolygons(this.mySides, this.myLeftSide, this.myDiffDividerPolygonsOffset), gg, width);
        gg.dispose();
    }

    public EditingSides getSides() {
        return this.mySides;
    }

    public FragmentSide getLeftSide() {
        return this.myLeftSide;
    }

    private boolean hasAllEditors() {
        return this.mySides.getEditor(FragmentSide.SIDE1) != null && this.mySides.getEditor(FragmentSide.SIDE2) != null;
    }
}

