/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NonNls;

public class ContextLogger {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.util.ContextLogger");
    private final Logger myLogger;
    private final Context myInfo;
    private boolean myFirstError = true;

    public ContextLogger(Logger logger, Object context2) {
        this(logger, new SimpleContext(context2));
    }

    public ContextLogger(Logger logger, Context context2) {
        this.myLogger = logger;
        this.myInfo = context2;
    }

    public ContextLogger(String info) {
        this(LOG, info);
        this.assertTrue(this.isTestMode());
    }

    public void assertTrue(boolean condition) {
        this.assertTrue(condition, "");
    }

    public void assertTrue(boolean condition, String message2) {
        if (condition) {
            return;
        }
        this.logError("Assertion: " + message2);
    }

    private void logError(@NonNls String message2) {
        if (this.myFirstError) {
            this.myLogger.error(message2, this.myInfo.getDetails());
            this.myFirstError = false;
        } else {
            this.myLogger.error(message2);
        }
    }

    private boolean isTestMode() {
        Application application = ApplicationManager.getApplication();
        return application == null || application.isUnitTestMode();
    }

    public void notImplemented() {
        this.throwTestException("Not implemented");
    }

    private void throwTestException(@NonNls String message2) {
        if (this.isTestMode()) {
            throw new RuntimeException(message2);
        }
        this.logError(message2);
    }

    public void notTested() {
        this.throwTestException("Not Tested");
    }

    public void error(String message2) {
        this.logError(message2);
    }

    public static class SimpleContext
    implements Context {
        private final Object[] myContext;

        public SimpleContext(Object obj) {
            this(new Object[]{obj});
        }

        public SimpleContext(Object[] data) {
            this.myContext = data;
        }

        @Override
        public String[] getDetails() {
            String[] result2 = new String[this.myContext.length];
            for (int i2 = 0; i2 < this.myContext.length; ++i2) {
                Object object = this.myContext[i2];
                result2[i2] = String.valueOf(object);
            }
            return result2;
        }
    }

    public static interface Context {
        public String[] getDetails();
    }
}

