/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.EditingSides;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.util.Disposer;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SyncScrollSupport
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.util.SyncScrollSupport");
    private boolean myDuringVerticalScroll = false;
    @NotNull
    private final ArrayList<ScrollListener> myScrollers = new ArrayList();
    private boolean myEnabled = true;

    public void install(EditingSides[] sideContainers) {
        Disposer.dispose((Disposable)this);
        Editor[] editors = new Editor[sideContainers.length + 1];
        editors[0] = sideContainers[0].getEditor(FragmentSide.SIDE1);
        for (int i2 = 0; i2 < sideContainers.length; ++i2) {
            EditingSides sideContainer = sideContainers[i2];
            LOG.assertTrue(sideContainer.getEditor(FragmentSide.SIDE1) == editors[i2]);
            editors[i2 + 1] = sideContainer.getEditor(FragmentSide.SIDE2);
        }
        if (editors.length == 3) {
            this.install3(editors, sideContainers);
        } else if (editors.length == 2) {
            this.install2(editors, sideContainers);
        } else {
            LOG.error(String.valueOf(editors.length));
        }
    }

    public void dispose() {
        for (ScrollListener scrollListener : this.myScrollers) {
            Disposer.dispose((Disposable)scrollListener);
        }
        this.myScrollers.clear();
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    private void install2(@NotNull Editor[] editors, @NotNull EditingSides[] sideContainers) {
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "install2"));
        }
        if (sideContainers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sideContainers", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "install2"));
        }
        this.addSlavesScroller(editors[0], new ScrollingContext(FragmentSide.SIDE1, sideContainers[0], FragmentSide.SIDE1));
        this.addSlavesScroller(editors[1], new ScrollingContext(FragmentSide.SIDE2, sideContainers[0], FragmentSide.SIDE2));
    }

    private void install3(@NotNull Editor[] editors, @NotNull EditingSides[] sideContainers) {
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "install3"));
        }
        if (sideContainers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sideContainers", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "install3"));
        }
        this.addSlavesScroller(editors[0], new ScrollingContext(FragmentSide.SIDE1, sideContainers[0], FragmentSide.SIDE2), new ScrollingContext(FragmentSide.SIDE1, sideContainers[1], FragmentSide.SIDE1));
        this.addSlavesScroller(editors[1], new ScrollingContext(FragmentSide.SIDE2, sideContainers[0], FragmentSide.SIDE1), new ScrollingContext(FragmentSide.SIDE1, sideContainers[1], FragmentSide.SIDE1));
        this.addSlavesScroller(editors[2], new ScrollingContext(FragmentSide.SIDE2, sideContainers[1], FragmentSide.SIDE2), new ScrollingContext(FragmentSide.SIDE2, sideContainers[0], FragmentSide.SIDE1));
    }

    private void addSlavesScroller(@NotNull Editor editor, ScrollingContext ... contexts) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "addSlavesScroller"));
        }
        if (contexts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contexts", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "addSlavesScroller"));
        }
        ScrollListener scroller = new ScrollListener(contexts, editor);
        scroller.install();
        this.myScrollers.add(scroller);
    }

    private static void syncHorizontalScroll(@NotNull ScrollingContext context2, @NotNull Rectangle newRectangle, @NotNull Rectangle oldRectangle) {
        FragmentSide masterSide;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "syncHorizontalScroll"));
        }
        if (newRectangle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRectangle", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "syncHorizontalScroll"));
        }
        if (oldRectangle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRectangle", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "syncHorizontalScroll"));
        }
        int newScrollOffset = newRectangle.x;
        if (newScrollOffset == oldRectangle.x) {
            return;
        }
        EditingSides sidesContainer = context2.getSidesContainer();
        Editor slaveEditor = sidesContainer.getEditor((masterSide = context2.getMasterSide()).otherSide());
        if (slaveEditor == null) {
            return;
        }
        SyncScrollSupport.doScrollHorizontally(slaveEditor.getScrollingModel(), newScrollOffset);
    }

    private static void syncVerticalScroll(@NotNull ScrollingContext context2, @NotNull Rectangle newRectangle, @NotNull Rectangle oldRectangle) {
        int offset;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "syncVerticalScroll"));
        }
        if (newRectangle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRectangle", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "syncVerticalScroll"));
        }
        if (oldRectangle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRectangle", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "syncVerticalScroll"));
        }
        if (newRectangle.y == oldRectangle.y) {
            return;
        }
        EditingSides sidesContainer = context2.getSidesContainer();
        FragmentSide masterSide = context2.getMasterSide();
        FragmentSide masterDiffSide = context2.getMasterDiffSide();
        Editor master = sidesContainer.getEditor(masterSide);
        Editor slave = sidesContainer.getEditor(masterSide.otherSide());
        if (master == null || slave == null) {
            return;
        }
        if (master.isDisposed() || slave.isDisposed()) {
            return;
        }
        int masterVerticalScrollOffset = master.getScrollingModel().getVerticalScrollOffset();
        int slaveVerticalScrollOffset = slave.getScrollingModel().getVerticalScrollOffset();
        Rectangle viewRect = master.getScrollingModel().getVisibleArea();
        int middleY = viewRect.height / 3;
        if (master.getDocument().getTextLength() == 0) {
            return;
        }
        LogicalPosition masterPos = master.xyToLogicalPosition(new Point(viewRect.x, masterVerticalScrollOffset + middleY));
        int masterCenterLine = masterPos.line;
        int scrollToLine = sidesContainer.getLineBlocks().transform(masterDiffSide, masterCenterLine);
        if (scrollToLine < 0) {
            offset = slaveVerticalScrollOffset + newRectangle.y - oldRectangle.y;
        } else {
            int correction = (masterVerticalScrollOffset + middleY) % master.getLineHeight();
            Point point = slave.logicalPositionToXY(new LogicalPosition(scrollToLine, masterPos.column));
            offset = point.y - middleY + correction;
        }
        int deltaHeaderOffset = SyncScrollSupport.getHeaderOffset(slave) - SyncScrollSupport.getHeaderOffset(master);
        SyncScrollSupport.doScrollVertically(slave.getScrollingModel(), offset + deltaHeaderOffset);
    }

    private static int getHeaderOffset(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "getHeaderOffset"));
        }
        JComponent header = editor.getHeaderComponent();
        return header == null ? 0 : header.getHeight();
    }

    private static void doScrollVertically(@NotNull ScrollingModel model2, int offset) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "doScrollVertically"));
        }
        model2.disableAnimation();
        try {
            model2.scrollVertically(offset);
        }
        finally {
            model2.enableAnimation();
        }
    }

    private static void doScrollHorizontally(@NotNull ScrollingModel model2, int offset) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "doScrollHorizontally"));
        }
        model2.disableAnimation();
        try {
            model2.scrollHorizontally(offset);
        }
        finally {
            model2.enableAnimation();
        }
    }

    public static void scrollEditor(@NotNull Editor editor, int logicalLine) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/diff/impl/util/SyncScrollSupport", "scrollEditor"));
        }
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(logicalLine, 0));
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.disableAnimation();
        scrollingModel.scrollToCaret(ScrollType.CENTER);
        scrollingModel.enableAnimation();
    }

    private static class ScrollingContext {
        @NotNull
        private final EditingSides mySidesContainer;
        @NotNull
        private final FragmentSide myMasterSide;
        @NotNull
        private final FragmentSide myMasterDiffSide;

        public ScrollingContext(@NotNull FragmentSide masterSide, @NotNull EditingSides sidesContainer, @NotNull FragmentSide masterDiffSide) {
            if (masterSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "masterSide", "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollingContext", "<init>"));
            }
            if (sidesContainer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sidesContainer", "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollingContext", "<init>"));
            }
            if (masterDiffSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "masterDiffSide", "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollingContext", "<init>"));
            }
            this.mySidesContainer = sidesContainer;
            this.myMasterSide = masterSide;
            this.myMasterDiffSide = masterDiffSide;
        }

        @NotNull
        public EditingSides getSidesContainer() {
            EditingSides editingSides = this.mySidesContainer;
            if (editingSides == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollingContext", "getSidesContainer"));
            }
            return editingSides;
        }

        @NotNull
        public FragmentSide getMasterSide() {
            FragmentSide fragmentSide = this.myMasterSide;
            if (fragmentSide == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollingContext", "getMasterSide"));
            }
            return fragmentSide;
        }

        @NotNull
        public FragmentSide getMasterDiffSide() {
            FragmentSide fragmentSide = this.myMasterDiffSide;
            if (fragmentSide == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollingContext", "getMasterDiffSide"));
            }
            return fragmentSide;
        }
    }

    private class ScrollListener
    implements VisibleAreaListener,
    Disposable {
        private ScrollingContext[] myScrollContexts;
        @NotNull
        private final Editor myEditor;

        public ScrollListener(@NotNull ScrollingContext[] scrollContexts, Editor editor) {
            if (scrollContexts == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollContexts", "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollListener", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/diff/impl/util/SyncScrollSupport$ScrollListener", "<init>"));
            }
            this.myScrollContexts = scrollContexts;
            this.myEditor = editor;
        }

        public void install() {
            this.myEditor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this);
        }

        public void dispose() {
            this.myEditor.getScrollingModel().removeVisibleAreaListener((VisibleAreaListener)this);
            this.myScrollContexts = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visibleAreaChanged(VisibleAreaEvent e2) {
            if (!SyncScrollSupport.this.myEnabled || SyncScrollSupport.this.myDuringVerticalScroll) {
                return;
            }
            Rectangle newRectangle = e2.getNewRectangle();
            Rectangle oldRectangle = e2.getOldRectangle();
            if (newRectangle == null || oldRectangle == null) {
                return;
            }
            SyncScrollSupport.this.myDuringVerticalScroll = true;
            try {
                for (ScrollingContext context2 : this.myScrollContexts) {
                    SyncScrollSupport.syncVerticalScroll(context2, newRectangle, oldRectangle);
                    SyncScrollSupport.syncHorizontalScroll(context2, newRectangle, oldRectangle);
                }
            }
            finally {
                SyncScrollSupport.this.myDuringVerticalScroll = false;
            }
        }
    }
}

