/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.SettingsImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.project.DumbAware;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractToggleUseSoftWrapsAction
extends ToggleAction
implements DumbAware {
    private final SoftWrapAppliancePlaces myAppliancePlace;
    private final boolean myGlobal;

    public AbstractToggleUseSoftWrapsAction(@NotNull SoftWrapAppliancePlaces appliancePlace, boolean global) {
        if (appliancePlace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appliancePlace", "com/intellij/openapi/editor/actions/AbstractToggleUseSoftWrapsAction", "<init>"));
        }
        this.myAppliancePlace = appliancePlace;
        this.myGlobal = global;
    }

    public void update(@NotNull AnActionEvent e2) {
        EditorSettings settings;
        Editor editor;
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/actions/AbstractToggleUseSoftWrapsAction", "update"));
        }
        if (this.myGlobal && (editor = this.getEditor(e2)) != null && (settings = editor.getSettings()) instanceof SettingsImpl && ((SettingsImpl)settings).getSoftWrapAppliancePlace() != this.myAppliancePlace) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        super.update(e2);
    }

    public boolean isSelected(AnActionEvent e2) {
        if (this.myGlobal) {
            return EditorSettingsExternalizable.getInstance().isUseSoftWraps(this.myAppliancePlace);
        }
        Editor editor = this.getEditor(e2);
        return editor != null && editor.getSettings().isUseSoftWraps();
    }

    public void setSelected(AnActionEvent e2, boolean state) {
        Editor editor = this.getEditor(e2);
        if (editor == null) {
            return;
        }
        AbstractToggleUseSoftWrapsAction.toggleSoftWraps(editor, this.myGlobal ? this.myAppliancePlace : null, state);
    }

    public static void toggleSoftWraps(@NotNull Editor editor, @Nullable SoftWrapAppliancePlaces places, boolean state) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/AbstractToggleUseSoftWrapsAction", "toggleSoftWraps"));
        }
        Point point = editor.getScrollingModel().getVisibleArea().getLocation();
        LogicalPosition anchorPosition = editor.xyToLogicalPosition(point);
        int intraLineShift = point.y - editor.logicalPositionToXY((LogicalPosition)anchorPosition).y;
        if (places != null) {
            EditorSettingsExternalizable.getInstance().setUseSoftWraps(state, places);
            EditorFactory.getInstance().refreshAllEditors();
        }
        if (editor.getSettings().isUseSoftWraps() != state) {
            editor.getSettings().setUseSoftWraps(state);
        }
        editor.getScrollingModel().disableAnimation();
        editor.getScrollingModel().scrollVertically(editor.logicalPositionToXY((LogicalPosition)anchorPosition).y + intraLineShift);
        editor.getScrollingModel().enableAnimation();
    }

    @Nullable
    protected Editor getEditor(AnActionEvent e2) {
        return (Editor)e2.getData(CommonDataKeys.EDITOR);
    }
}

