/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAware;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeEditorFontSizeAction
extends AnAction
implements DumbAware {
    private final int myStep;

    protected ChangeEditorFontSizeAction(@Nullable String text2, int increaseStep) {
        super(text2);
        this.myStep = increaseStep;
    }

    public void actionPerformed(AnActionEvent e2) {
        int size;
        EditorImpl editor = ChangeEditorFontSizeAction.getEditor(e2);
        if (editor != null && (size = editor.getFontSize() + this.myStep) >= 8 && size <= EditorFontsConstants.getMaxEditorFontSize()) {
            editor.setFontSize(size);
        }
    }

    @Nullable
    private static EditorImpl getEditor(AnActionEvent e2) {
        Editor editor = (Editor)e2.getData(CommonDataKeys.EDITOR);
        if (editor instanceof EditorImpl) {
            return (EditorImpl)editor;
        }
        return null;
    }

    public void update(AnActionEvent e2) {
        e2.getPresentation().setEnabled(ChangeEditorFontSizeAction.getEditor(e2) != null);
    }

    public static class DecreaseEditorFontSize
    extends ChangeEditorFontSizeAction {
        protected DecreaseEditorFontSize() {
            super(EditorBundle.message((String)"decrease.editor.font", (Object[])new Object[0]), -1);
        }
    }

    public static class IncreaseEditorFontSize
    extends ChangeEditorFontSizeAction {
        protected IncreaseEditorFontSize() {
            super(EditorBundle.message((String)"increase.editor.font", (Object[])new Object[0]), 1);
        }
    }
}

